/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.ai.deployment;

import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.rag.content.retriever.ContentRetriever;
import dev.langchain4j.store.embedding.EmbeddingStore;
import jakarta.inject.Named;
import java.util.HashSet;
import java.util.List;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.Type;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;
import org.wildfly.extension.ai.AILogger;
import org.wildfly.extension.ai.Capabilities;
import org.wildfly.extension.ai.deployment.AIAttachements;

public class AIDependencyProcessor
implements DeploymentUnitProcessor {
    public static final String[] OPTIONAL_MODULES = new String[]{"dev.langchain4j.openai", "dev.langchain4j.ollama", "dev.langchain4j.weaviate", "dev.langchain4j.web-search-engines"};
    public static final String[] EXPORTED_MODULES = new String[]{"dev.langchain4j", "io.smallrye.llm", "org.wildfly.extension.ai.injection"};

    public void deploy(DeploymentPhaseContext deploymentPhaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = deploymentPhaseContext.getDeploymentUnit();
        ModuleSpecification moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        for (String module : OPTIONAL_MODULES) {
            moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, module, true, false, true, false));
        }
        for (String module : EXPORTED_MODULES) {
            ModuleDependency modDep = new ModuleDependency(moduleLoader, module, false, true, true, false);
            modDep.addImportFilter(s -> s.equals("META-INF"), true);
            moduleSpecification.addSystemDependency(modDep);
        }
        CompositeIndex index = (CompositeIndex)deploymentUnit.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
        if (index == null) {
            throw AILogger.ROOT_LOGGER.unableToResolveAnnotationIndex(deploymentUnit);
        }
        List annotations = index.getAnnotations(DotName.createSimple(Named.class));
        if (annotations == null || annotations.isEmpty()) {
            return;
        }
        HashSet<String> requiredChatModels = new HashSet<String>();
        HashSet<String> requiredEmbeddingModels = new HashSet<String>();
        HashSet<String> requiredEmbeddingStores = new HashSet<String>();
        HashSet<String> requiredContentRetrievers = new HashSet<String>();
        for (AnnotationInstance annotation : annotations) {
            FieldInfo field;
            if (annotation.target().kind() != AnnotationTarget.Kind.FIELD || (field = annotation.target().asField()).type().kind() != Type.Kind.CLASS) continue;
            try {
                Class<?> fieldClass = Class.forName(field.type().asClassType().name().toString());
                if (ChatLanguageModel.class.isAssignableFrom(fieldClass)) {
                    AILogger.ROOT_LOGGER.debug("We need the ChatLanguageModel in the class " + field.declaringClass());
                    String chatLanguageModelName = annotation.value().asString();
                    AILogger.ROOT_LOGGER.debug("We need the ChatLanguageModel called " + chatLanguageModelName);
                    requiredChatModels.add(chatLanguageModelName);
                    continue;
                }
                if (EmbeddingModel.class.isAssignableFrom(fieldClass)) {
                    AILogger.ROOT_LOGGER.debug("We need the EmbeddingModel in the class " + field.declaringClass());
                    String embeddingModelName = annotation.value().asString();
                    AILogger.ROOT_LOGGER.debug("We need the EmbeddingModel called " + embeddingModelName);
                    requiredEmbeddingModels.add(embeddingModelName);
                    continue;
                }
                if (EmbeddingStore.class.isAssignableFrom(fieldClass)) {
                    AILogger.ROOT_LOGGER.debug("We need the EmbeddingStore in the class " + field.declaringClass());
                    String embeddingStoreName = annotation.value().asString();
                    AILogger.ROOT_LOGGER.debug("We need the EmbeddingStore called " + embeddingStoreName);
                    requiredEmbeddingStores.add(embeddingStoreName);
                    continue;
                }
                if (!ContentRetriever.class.isAssignableFrom(fieldClass)) continue;
                AILogger.ROOT_LOGGER.debug("We need the ContentRetriever in the class " + field.declaringClass());
                String contentRetrieverName = annotation.value().asString();
                AILogger.ROOT_LOGGER.debug("We need the ContentRetriever called " + contentRetrieverName);
                requiredContentRetrievers.add(contentRetrieverName);
            }
            catch (ClassNotFoundException ex) {
                AILogger.ROOT_LOGGER.error("Coudln't get the class type for " + field.type().asClassType().name().toString() + " to be able to check what to inject", ex);
            }
        }
        if (!(requiredChatModels.isEmpty() && requiredEmbeddingModels.isEmpty() && requiredEmbeddingStores.isEmpty())) {
            if (!requiredChatModels.isEmpty()) {
                for (String chatLanguageModelName : requiredChatModels) {
                    deploymentUnit.addToAttachmentList(AIAttachements.CHAT_MODEL_KEYS, (Object)chatLanguageModelName);
                    deploymentPhaseContext.addDeploymentDependency(Capabilities.CHAT_MODEL_PROVIDER_CAPABILITY.getCapabilityServiceName(new String[]{chatLanguageModelName}), AIAttachements.CHAT_MODELS);
                }
            }
            if (!requiredEmbeddingModels.isEmpty()) {
                for (String embeddingModelName : requiredEmbeddingModels) {
                    deploymentUnit.addToAttachmentList(AIAttachements.EMBEDDING_MODEL_KEYS, (Object)embeddingModelName);
                    deploymentPhaseContext.addDeploymentDependency(Capabilities.EMBEDDING_MODEL_PROVIDER_CAPABILITY.getCapabilityServiceName(new String[]{embeddingModelName}), AIAttachements.EMBEDDING_MODELS);
                }
            }
            if (!requiredEmbeddingStores.isEmpty()) {
                for (String embeddingStoreName : requiredEmbeddingStores) {
                    deploymentUnit.addToAttachmentList(AIAttachements.EMBEDDING_STORE_KEYS, (Object)embeddingStoreName);
                    deploymentPhaseContext.addDeploymentDependency(Capabilities.EMBEDDING_STORE_PROVIDER_CAPABILITY.getCapabilityServiceName(new String[]{embeddingStoreName}), AIAttachements.EMBEDDING_STORES);
                }
            }
            if (!requiredContentRetrievers.isEmpty()) {
                for (String contentRetrieverName : requiredContentRetrievers) {
                    deploymentUnit.addToAttachmentList(AIAttachements.CONTENT_RETRIEVER_KEYS, (Object)contentRetrieverName);
                    deploymentPhaseContext.addDeploymentDependency(Capabilities.CONTENT_RETRIEVER_PROVIDER_CAPABILITY.getCapabilityServiceName(new String[]{contentRetrieverName}), AIAttachements.CONTENT_RETRIEVERS);
                }
            }
        }
    }
}

