/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.ai.chat;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.OperationContext;
import org.wildfly.extension.ai.Capabilities;
import org.wildfly.extension.ai.injection.chat.WildFlyChatModelConfig;
import org.wildfly.extension.opentelemetry.api.WildFlyOpenTelemetryConfig;
import org.wildfly.service.capture.ValueRegistry;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.capability.CapabilityServiceInstaller;

public abstract class AbstractChatModelProviderServiceConfigurator
implements ResourceServiceConfigurator {
    private final ValueRegistry<String, WildFlyChatModelConfig> registry;

    AbstractChatModelProviderServiceConfigurator(ValueRegistry<String, WildFlyChatModelConfig> registry) {
        this.registry = registry;
    }

    ResourceServiceInstaller installService(String name, Supplier<WildFlyChatModelConfig> factory) {
        Consumer captor = this.registry.add((Object)name);
        final ResourceServiceInstaller installer = (ResourceServiceInstaller)((CapabilityServiceInstaller.Builder)((CapabilityServiceInstaller.Builder)CapabilityServiceInstaller.builder(Capabilities.CHAT_MODEL_PROVIDER_CAPABILITY, factory).withCaptor(captor)).asActive()).build();
        final Consumer<OperationContext> remover = ctx -> this.registry.remove((Object)ctx.getCurrentAddressValue());
        return new ResourceServiceInstaller(){

            public Consumer<OperationContext> install(OperationContext context) {
                return installer.install(context).andThen(remover);
            }
        };
    }

    ResourceServiceInstaller installService(String name, Supplier<WildFlyChatModelConfig> factory, ServiceDependency<WildFlyOpenTelemetryConfig> openTelemetryConfig) {
        Consumer captor = this.registry.add((Object)name);
        final ResourceServiceInstaller installer = (ResourceServiceInstaller)((CapabilityServiceInstaller.Builder)((CapabilityServiceInstaller.Builder)((CapabilityServiceInstaller.Builder)CapabilityServiceInstaller.builder(Capabilities.CHAT_MODEL_PROVIDER_CAPABILITY, factory).requires(openTelemetryConfig)).withCaptor(captor)).asActive()).build();
        final Consumer<OperationContext> remover = ctx -> this.registry.remove((Object)ctx.getCurrentAddressValue());
        return new ResourceServiceInstaller(){

            public Consumer<OperationContext> install(OperationContext context) {
                return installer.install(context).andThen(remover);
            }
        };
    }
}

