/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.ai.chat;

import java.util.Collection;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.ResourceRegistration;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.descriptions.ParentResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.RuntimePackageDependency;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.ai.AIAttributeDefinitions;
import org.wildfly.extension.ai.Capabilities;
import org.wildfly.extension.ai.chat.ChatModelConnectionCheckerOperationHandler;
import org.wildfly.extension.ai.chat.GeminiChatModelProviderServiceConfigurator;
import org.wildfly.extension.ai.injection.chat.WildFlyChatModelConfig;
import org.wildfly.service.capture.ValueExecutorRegistry;
import org.wildfly.service.capture.ValueRegistry;
import org.wildfly.subsystem.resource.ChildResourceDefinitionRegistrar;
import org.wildfly.subsystem.resource.ManagementResourceRegistrar;
import org.wildfly.subsystem.resource.ManagementResourceRegistrationContext;
import org.wildfly.subsystem.resource.ResourceDescriptor;
import org.wildfly.subsystem.resource.operation.ResourceOperationRuntimeHandler;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;

public class GeminiChatLanguageModelProviderRegistrar
implements ChildResourceDefinitionRegistrar {
    private static final String[] THRESHOLDS = new String[]{"HARM_BLOCK_THRESHOLD_UNSPECIFIED", "BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"};
    public static final SimpleAttributeDefinition ALLOWED_CODE_EXECUTION = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("allowed-code-execution", ModelType.BOOLEAN, true).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition CIVIC_INTEGRITY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("civic-integrity", ModelType.STRING, true).setAllowedValues(THRESHOLDS)).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition DANGEROUS_CONTENT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("dangerous-content", ModelType.STRING, true).setAllowedValues(THRESHOLDS)).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition HARASSMENT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("harassment", ModelType.STRING, true).setAllowedValues(THRESHOLDS)).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition HATE_SPEECH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("hate-speech", ModelType.STRING, true).setAllowedValues(THRESHOLDS)).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition INCLUDE_CODE_EXECUTION_OUTPUT = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("include-code-execution-output", ModelType.BOOLEAN, true).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition MAX_OUTPUT_TOKEN = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("max-output-token", ModelType.INT, true).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition SEXUALLY_EXPLICIT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("sexually-explicit", ModelType.STRING, true).setAllowedValues(THRESHOLDS)).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition TOP_K = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("top-k", ModelType.INT, true).setAllowExpression(true)).build();
    public static final Collection<AttributeDefinition> ATTRIBUTES = List.of(ALLOWED_CODE_EXECUTION, AIAttributeDefinitions.API_KEY, CIVIC_INTEGRITY, AIAttributeDefinitions.CONNECT_TIMEOUT, DANGEROUS_CONTENT, HARASSMENT, HATE_SPEECH, INCLUDE_CODE_EXECUTION_OUTPUT, AIAttributeDefinitions.LOG_REQUESTS_RESPONSES, MAX_OUTPUT_TOKEN, AIAttributeDefinitions.MODEL_NAME, AIAttributeDefinitions.RESPONSE_FORMAT, SEXUALLY_EXPLICIT, AIAttributeDefinitions.STREAMING, AIAttributeDefinitions.TEMPERATURE, TOP_K, AIAttributeDefinitions.TOP_P);
    private final ResourceDescriptor descriptor;
    static final String NAME = "gemini-chat-model";
    public static final PathElement PATH = PathElement.pathElement((String)"gemini-chat-model");
    public static final ResourceRegistration REGISTRATION = ResourceRegistration.of((PathElement)PATH);
    private final ValueExecutorRegistry<String, WildFlyChatModelConfig> registry = ValueExecutorRegistry.newInstance();

    public GeminiChatLanguageModelProviderRegistrar(ParentResourceDescriptionResolver parentResolver) {
        this.descriptor = ((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)ResourceDescriptor.builder((ResourceDescriptionResolver)parentResolver.createChildResolver(PATH)).addCapability(Capabilities.CHAT_MODEL_PROVIDER_CAPABILITY)).addAttributes(ATTRIBUTES)).withRuntimeHandler(ResourceOperationRuntimeHandler.configureService((ResourceServiceConfigurator)new GeminiChatModelProviderServiceConfigurator((ValueRegistry<String, WildFlyChatModelConfig>)this.registry)))).build();
    }

    public ManagementResourceRegistration register(ManagementResourceRegistration parent, ManagementResourceRegistrationContext context) {
        ResourceDefinition definition = ResourceDefinition.builder((ResourceRegistration)REGISTRATION, (ResourceDescriptionResolver)this.descriptor.getResourceDescriptionResolver()).build();
        ManagementResourceRegistration resourceRegistration = parent.registerSubModel(definition);
        ChatModelConnectionCheckerOperationHandler.register(resourceRegistration, this.descriptor, this.registry);
        resourceRegistration.registerAdditionalRuntimePackages(new RuntimePackageDependency[]{RuntimePackageDependency.required((String)"dev.langchain4j.gemini")});
        ManagementResourceRegistrar.of((ResourceDescriptor)this.descriptor).register(resourceRegistration);
        return resourceRegistration;
    }
}

