/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.ai.chat;

import java.util.function.Supplier;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.ai.AIAttributeDefinitions;
import org.wildfly.extension.ai.chat.AbstractChatModelProviderServiceConfigurator;
import org.wildfly.extension.ai.chat.GeminiChatLanguageModelProviderRegistrar;
import org.wildfly.extension.ai.injection.chat.WildFlyChatModelConfig;
import org.wildfly.extension.ai.injection.chat.WildFlyGeminiChatModelConfig;
import org.wildfly.service.capture.ValueRegistry;
import org.wildfly.subsystem.service.ResourceServiceInstaller;

public class GeminiChatModelProviderServiceConfigurator
extends AbstractChatModelProviderServiceConfigurator {
    public GeminiChatModelProviderServiceConfigurator(ValueRegistry<String, WildFlyChatModelConfig> registry) {
        super(registry);
    }

    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        final Long connectTimeOut = AIAttributeDefinitions.CONNECT_TIMEOUT.resolveModelAttribute(context, model).asLong();
        final String key = AIAttributeDefinitions.API_KEY.resolveModelAttribute(context, model).asString();
        final Boolean allowCodeExecution = GeminiChatLanguageModelProviderRegistrar.ALLOWED_CODE_EXECUTION.resolveModelAttribute(context, model).asBooleanOrNull();
        final Boolean includeCodeExecutionOutput = GeminiChatLanguageModelProviderRegistrar.INCLUDE_CODE_EXECUTION_OUTPUT.resolveModelAttribute(context, model).asBooleanOrNull();
        final Boolean logRequestsAndResponses = AIAttributeDefinitions.LOG_REQUESTS_RESPONSES.resolveModelAttribute(context, model).asBooleanOrNull();
        final Integer maxOutputTokens = GeminiChatLanguageModelProviderRegistrar.MAX_OUTPUT_TOKEN.resolveModelAttribute(context, model).asIntOrNull();
        final String modelName = AIAttributeDefinitions.MODEL_NAME.resolveModelAttribute(context, model).asString();
        final boolean isJson = AIAttributeDefinitions.ResponseFormat.isJson(AIAttributeDefinitions.RESPONSE_FORMAT.resolveModelAttribute(context, model).asStringOrNull());
        final Boolean streaming = AIAttributeDefinitions.STREAMING.resolveModelAttribute(context, model).asBooleanOrNull();
        final Double temperature = AIAttributeDefinitions.TEMPERATURE.resolveModelAttribute(context, model).asDoubleOrNull();
        final Integer topK = GeminiChatLanguageModelProviderRegistrar.TOP_K.resolveModelAttribute(context, model).asIntOrNull();
        final Double topP = AIAttributeDefinitions.TOP_P.resolveModelAttribute(context, model).asDoubleOrNull();
        final boolean isObservable = context.getCapabilityServiceSupport().hasCapability("org.wildfly.extension.opentelemetry");
        Supplier<WildFlyChatModelConfig> factory = new Supplier<WildFlyChatModelConfig>(){

            @Override
            public WildFlyChatModelConfig get() {
                return new WildFlyGeminiChatModelConfig().allowCodeExecution(allowCodeExecution).apiKey(key).includeCodeExecutionOutput(includeCodeExecutionOutput).logRequestsAndResponses(logRequestsAndResponses).maxOutputTokens(maxOutputTokens).modelName(modelName).setJson(isJson).setObservable(isObservable).setStreaming(streaming.booleanValue()).temperature(temperature).timeout(connectTimeOut.longValue()).topK(topK).topP(topP);
            }
        };
        return this.installService(context.getCurrentAddressValue(), factory);
    }
}

