/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.ai.chat;

import java.util.function.Supplier;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.ai.AIAttributeDefinitions;
import org.wildfly.extension.ai.chat.AbstractChatModelProviderServiceConfigurator;
import org.wildfly.extension.ai.injection.chat.WildFlyChatModelConfig;
import org.wildfly.extension.ai.injection.chat.WildFlyOllamaChatModelConfig;
import org.wildfly.extension.opentelemetry.api.WildFlyOpenTelemetryConfig;
import org.wildfly.service.capture.ValueRegistry;
import org.wildfly.service.descriptor.NullaryServiceDescriptor;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;

public class OllamaChatModelProviderServiceConfigurator
extends AbstractChatModelProviderServiceConfigurator {
    public OllamaChatModelProviderServiceConfigurator(ValueRegistry<String, WildFlyChatModelConfig> registry) {
        super(registry);
    }

    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        final String baseUrl = AIAttributeDefinitions.BASE_URL.resolveModelAttribute(context, model).asString();
        final Long connectTimeOut = AIAttributeDefinitions.CONNECT_TIMEOUT.resolveModelAttribute(context, model).asLong();
        final Boolean logRequests = AIAttributeDefinitions.LOG_REQUESTS.resolveModelAttribute(context, model).asBooleanOrNull();
        final Boolean logResponses = AIAttributeDefinitions.LOG_RESPONSES.resolveModelAttribute(context, model).asBooleanOrNull();
        final Integer maxRetries = AIAttributeDefinitions.MAX_RETRIES.resolveModelAttribute(context, model).asIntOrNull();
        final String modelName = AIAttributeDefinitions.MODEL_NAME.resolveModelAttribute(context, model).asString();
        final boolean isJson = AIAttributeDefinitions.ResponseFormat.isJson(AIAttributeDefinitions.RESPONSE_FORMAT.resolveModelAttribute(context, model).asStringOrNull());
        final Boolean streaming = AIAttributeDefinitions.STREAMING.resolveModelAttribute(context, model).asBooleanOrNull();
        final Double temperature = AIAttributeDefinitions.TEMPERATURE.resolveModelAttribute(context, model).asDoubleOrNull();
        final boolean isObservable = context.getCapabilityServiceSupport().hasCapability("org.wildfly.extension.opentelemetry");
        ServiceDependency openTelemetryConfig = isObservable ? ServiceDependency.on((NullaryServiceDescriptor)WildFlyOpenTelemetryConfig.SERVICE_DESCRIPTOR) : null;
        Supplier<WildFlyChatModelConfig> factory = new Supplier<WildFlyChatModelConfig>(){

            @Override
            public WildFlyChatModelConfig get() {
                return new WildFlyOllamaChatModelConfig().baseUrl(baseUrl).logRequests(logRequests).logResponses(logResponses).maxRetries(maxRetries).setJson(isJson).setObservable(isObservable).setStreaming(streaming.booleanValue()).temperature(temperature).timeout(connectTimeOut.longValue()).modelName(modelName);
            }
        };
        if (isObservable) {
            return this.installService(context.getCurrentAddressValue(), factory, (ServiceDependency<WildFlyOpenTelemetryConfig>)openTelemetryConfig);
        }
        return this.installService(context.getCurrentAddressValue(), factory);
    }
}

