/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.ai.memory;

import java.util.function.Supplier;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.ai.Capabilities;
import org.wildfly.extension.ai.injection.memory.WildFlyChatMemoryProviderConfig;
import org.wildfly.extension.ai.memory.ChatMemoryProviderRegistrar;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.capability.CapabilityServiceInstaller;

public class ChatMemoryProviderServiceConfigurator
implements ResourceServiceConfigurator {
    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        final String type = ChatMemoryProviderRegistrar.TYPE.resolveModelAttribute(context, model).asString();
        final int size = ChatMemoryProviderRegistrar.SIZE.resolveModelAttribute(context, model).asInt();
        final boolean useHttpSession = ChatMemoryProviderRegistrar.USE_HTTP_SESSION.resolveModelAttribute(context, model).asBoolean();
        Supplier<WildFlyChatMemoryProviderConfig> factory = new Supplier<WildFlyChatMemoryProviderConfig>(){

            @Override
            public WildFlyChatMemoryProviderConfig get() {
                return new WildFlyChatMemoryProviderConfig().type(type).size(size).useHttpSession(useHttpSession);
            }
        };
        return (ResourceServiceInstaller)((CapabilityServiceInstaller.Builder)((CapabilityServiceInstaller.Builder)CapabilityServiceInstaller.builder(Capabilities.CHAT_MEMORY_PROVIDER_CAPABILITY, (Supplier)factory).blocking()).asActive()).build();
    }
}

