/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.ai.rag.retriever;

import java.time.Duration;
import java.util.function.Supplier;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.ai.AIAttributeDefinitions;
import org.wildfly.extension.ai.Capabilities;
import org.wildfly.extension.ai.injection.retriever.GoogleWebSearchContentRetrieverConfig;
import org.wildfly.extension.ai.injection.retriever.TavilyWebSearchContentRetrieverConfig;
import org.wildfly.extension.ai.injection.retriever.WildFlyContentRetrieverConfig;
import org.wildfly.extension.ai.rag.retriever.EmbeddingStoreContentRetrieverProviderRegistrar;
import org.wildfly.extension.ai.rag.retriever.WebSearchContentContentRetrieverProviderRegistrar;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.capability.CapabilityServiceInstaller;

public class WebSearchContentRetrieverProviderServiceConfigurator
implements ResourceServiceConfigurator {
    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        ModelNode googleConfiguration = WebSearchContentContentRetrieverProviderRegistrar.GOOGLE_SEARCH_ENGINE.resolveModelAttribute(context, model);
        ModelNode tavilyConfiguration = WebSearchContentContentRetrieverProviderRegistrar.TAVILY_SEARCH_ENGINE.resolveModelAttribute(context, model);
        Integer maxResults = EmbeddingStoreContentRetrieverProviderRegistrar.MAX_RESULTS.resolveModelAttribute(context, model).asIntOrNull();
        Object contentRetrieverConfig = googleConfiguration.isDefined() ? new GoogleWebSearchContentRetrieverConfig().apiKey(googleConfiguration.get(AIAttributeDefinitions.API_KEY.getName()).asStringOrNull()).csi(googleConfiguration.get("custom-search-id").asStringOrNull()).includeImages(googleConfiguration.get("include-images").asBooleanOrNull()).logRequests(googleConfiguration.get(AIAttributeDefinitions.LOG_REQUESTS.getName()).asBooleanOrNull()).logResponses(googleConfiguration.get(AIAttributeDefinitions.LOG_RESPONSES.getName()).asBooleanOrNull()).maxRetries(googleConfiguration.get("max-retries").asIntOrNull()).siteRestrict(googleConfiguration.get("site-restrict").asBooleanOrNull()).timeout(Duration.ofMillis(googleConfiguration.get(AIAttributeDefinitions.CONNECT_TIMEOUT.getName()).asLong())).maxResults(maxResults) : new TavilyWebSearchContentRetrieverConfig().apiKey(tavilyConfiguration.get(AIAttributeDefinitions.API_KEY.getName()).asStringOrNull()).baseUrl(tavilyConfiguration.get(AIAttributeDefinitions.BASE_URL.getName()).asString()).excludeDomains(StringListAttributeDefinition.unwrapValue((ExpressionResolver)context, (ModelNode)tavilyConfiguration.get("exclude-domains"))).includeAnswer(tavilyConfiguration.get("include-answer").asBooleanOrNull()).includeDomains(StringListAttributeDefinition.unwrapValue((ExpressionResolver)context, (ModelNode)tavilyConfiguration.get("include-domains"))).includeRawContent(tavilyConfiguration.get("include-raw-content").asBooleanOrNull()).searchDepth(tavilyConfiguration.get("search-depth").asStringOrNull()).timeout(Duration.ofMillis(tavilyConfiguration.get(AIAttributeDefinitions.CONNECT_TIMEOUT.getName()).asLong())).maxResults(maxResults);
        Supplier<WildFlyContentRetrieverConfig> factory = new Supplier<WildFlyContentRetrieverConfig>((WildFlyContentRetrieverConfig)contentRetrieverConfig){
            final /* synthetic */ WildFlyContentRetrieverConfig val$contentRetrieverConfig;
            {
                this.val$contentRetrieverConfig = wildFlyContentRetrieverConfig;
            }

            @Override
            public WildFlyContentRetrieverConfig get() {
                return this.val$contentRetrieverConfig;
            }
        };
        return (ResourceServiceInstaller)((CapabilityServiceInstaller.Builder)((CapabilityServiceInstaller.Builder)CapabilityServiceInstaller.builder(Capabilities.CONTENT_RETRIEVER_PROVIDER_CAPABILITY, (Supplier)factory).blocking()).asActive()).build();
    }
}

