/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container.domain;

import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.arquillian.container.spi.client.protocol.metadata.HTTPContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.Servlet;
import org.jboss.as.arquillian.container.domain.Authentication;
import org.jboss.as.arquillian.container.domain.Domain;
import org.jboss.as.arquillian.container.domain.NetworkUtils;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;

public class ManagementClient {
    private static final String SUBDEPLOYMENT = "subdeployment";
    private static final String UNDERTOW = "undertow";
    private static final String JMX = "jmx";
    private static final String PROTOCOL_HTTP = "http";
    private static final String NAME = "name";
    private static final String SERVLET = "servlet";
    private static final String POSTFIX_WEB = ".war";
    private static final String POSTFIX_EAR = ".ear";
    private final String mgmtAddress;
    private final int mgmtPort;
    private final ModelControllerClient client;
    private final Map<String, URI> subsystemURICache;
    private ModelNode rootNode = null;
    private MBeanServerConnection connection;
    private JMXConnector connector;

    public ManagementClient(ModelControllerClient client, String mgmtAddress, int managementPort) {
        if (client == null) {
            throw new IllegalArgumentException("Client must be specified");
        }
        this.client = client;
        this.mgmtAddress = mgmtAddress;
        this.subsystemURICache = new HashMap<String, URI>();
        this.mgmtPort = managementPort;
    }

    public ModelControllerClient getControllerClient() {
        return this.client;
    }

    public Domain createDomain(Map<String, String> containerNameMap) {
        this.lazyLoadRootNode();
        Domain domain = new Domain();
        for (String hostNodeName : this.rootNode.get("host").keys()) {
            for (String serverConfigName : this.rootNode.get("host").get(hostNodeName).get("server-config").keys()) {
                ModelNode serverConfig = this.rootNode.get("host").get(hostNodeName).get("server-config").get(serverConfigName);
                Domain.Server server = new Domain.Server(serverConfig.get(NAME).asString(), hostNodeName, serverConfig.get("group").asString(), serverConfig.get("auto-start").asBoolean());
                if (containerNameMap.containsKey(server.getUniqueName())) {
                    server.setContainerName(containerNameMap.get(server.getUniqueName()));
                }
                domain.addServer(server);
            }
        }
        for (String serverGroupName : this.rootNode.get("server-group").keys()) {
            Domain.ServerGroup group = new Domain.ServerGroup(serverGroupName);
            if (containerNameMap.containsKey(group.getName())) {
                group.setContainerName(containerNameMap.get(group.getName()));
            }
            domain.addServerGroup(group);
        }
        return domain;
    }

    public String getServerState(Domain.Server server) {
        this.lazyLoadRootNode();
        ModelNode hostNode = this.rootNode.get("host").get(server.getHost());
        if (!hostNode.isDefined()) {
            throw new IllegalArgumentException("Host not found on domain " + server.getHost());
        }
        ModelNode serverConfig = hostNode.get("server-config").get(server.getName());
        if (!serverConfig.isDefined()) {
            throw new IllegalArgumentException("Server " + server + " not found on host " + server.getHost());
        }
        return serverConfig.get("status").asString();
    }

    public HTTPContext getHTTPDeploymentMetaData(Domain.Server server, String uniqueDeploymentName) {
        URI webURI = this.getProtocolURI(server, PROTOCOL_HTTP);
        HTTPContext context = new HTTPContext(webURI.getHost(), webURI.getPort());
        try {
            ModelNode deploymentNode = this.readResource(this.createHostServerDeploymentAddress(server.getHost(), server.getName(), uniqueDeploymentName), false);
            if (this.isWebArchive(uniqueDeploymentName)) {
                this.extractWebArchiveContexts(context, deploymentNode);
            } else if (this.isEnterpriseArchive(uniqueDeploymentName)) {
                this.extractEnterpriseArchiveContexts(context, deploymentNode);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not extract deployment information for server: " + server + " on deployment: " + uniqueDeploymentName, e);
        }
        return context;
    }

    public void startServerGroup(String groupName) {
        try {
            this.executeOperation("start-servers", new ModelNode().add("server-group", groupName));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not start server-group " + groupName, e);
        }
    }

    public void stopServerGroup(String groupName) {
        try {
            this.executeOperation("stop-servers", new ModelNode().add("server-group", groupName));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not stop server-group " + groupName, e);
        }
    }

    public void startServer(Domain.Server server) {
        try {
            this.executeOperation("start", new ModelNode().add("host", server.getHost()).add("server-config", server.getName()));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not start server " + server, e);
        }
    }

    public void stopServer(Domain.Server server) {
        try {
            this.executeOperation("stop", new ModelNode().add("host", server.getHost()).add("server-config", server.getName()));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not stop server " + server, e);
        }
    }

    public boolean isServerStarted(Domain.Server server) {
        try {
            ModelNode result = this.readAttribute("status", this.createHostServerConfigAddress(server.getHost(), server.getName()));
            return result.asString().equalsIgnoreCase("STARTED") && (result = this.readAttribute("server-state", this.createHostServerAddress(server.getHost(), server.getName()))).asString().equalsIgnoreCase("running");
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isDomainInRunningState() {
        try {
            ModelNode op = new ModelNode();
            op.get("operation").set("read-children-names");
            op.get("address").setEmptyList();
            op.get("child-type").set("server-group");
            ModelNode rsp = this.client.execute(op);
            return "success".equals(rsp.get("outcome").asString()) && rsp.get("result").asList().size() > 0;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public void close() {
        try {
            this.getControllerClient().close();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not close connection", e);
        }
        finally {
            if (this.connector != null) {
                try {
                    this.connector.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not close JMX connection", e);
                }
            }
        }
    }

    private URI getProtocolURI(Domain.Server server, String subsystem) {
        String cacheKey = server + subsystem;
        URI subsystemURI = this.subsystemURICache.get(cacheKey);
        if (subsystemURI != null) {
            return subsystemURI;
        }
        subsystemURI = this.extractProtocolURI(server, subsystem);
        this.subsystemURICache.put(cacheKey, subsystemURI);
        return subsystemURI;
    }

    private URI extractProtocolURI(Domain.Server server, String protocol) {
        try {
            ModelNode node = this.readResource(this.createHostServerSocketBindingsAddress(server.getHost(), server.getName(), this.getSocketBindingGroup(server.getGroup())));
            ModelNode socketBinding = node.get("socket-binding").get(protocol);
            return URI.create(protocol + "://" + socketBinding.get("bound-address").asString() + ":" + socketBinding.get("bound-port"));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not extract address information from server: " + server + " for protocol " + protocol + ". Is the server running?", e);
        }
    }

    private void readRootNode() throws Exception {
        this.rootNode = this.readResource(new ModelNode());
    }

    private String getSocketBindingGroup(String serverGroup) {
        this.lazyLoadRootNode();
        return this.rootNode.get("server-group").get(serverGroup).get("socket-binding-group").asString();
    }

    private boolean isEnterpriseArchive(String deploymentName) {
        return deploymentName.endsWith(POSTFIX_EAR);
    }

    private boolean isWebArchive(String deploymentName) {
        return deploymentName.endsWith(POSTFIX_WEB);
    }

    private ModelNode createHostServerAddress(String host, String server) {
        return new ModelNode().add("host", host).add("server", server);
    }

    private ModelNode createHostServerConfigAddress(String host, String server) {
        return new ModelNode().add("host", host).add("server-config", server);
    }

    private ModelNode createHostServerDeploymentAddress(String host, String server, String deploymentName) {
        return new ModelNode().add("host", host).add("server", server).add("deployment", deploymentName);
    }

    private ModelNode createHostServerSocketBindingsAddress(String host, String server, String socketBindingGroup) {
        return new ModelNode().add("host", host).add("server", server).add("socket-binding-group", socketBindingGroup);
    }

    private void extractEnterpriseArchiveContexts(HTTPContext context, ModelNode deploymentNode) {
        if (deploymentNode.hasDefined(SUBDEPLOYMENT)) {
            for (ModelNode subdeployment : deploymentNode.get(SUBDEPLOYMENT).asList()) {
                String deploymentName = (String)subdeployment.keys().iterator().next();
                if (!this.isWebArchive(deploymentName)) continue;
                this.extractWebArchiveContexts(context, deploymentName, subdeployment.get(deploymentName));
            }
        }
    }

    private void extractWebArchiveContexts(HTTPContext context, ModelNode deploymentNode) {
        this.extractWebArchiveContexts(context, deploymentNode.get(NAME).asString(), deploymentNode);
    }

    private void extractWebArchiveContexts(HTTPContext context, String deploymentName, ModelNode deploymentNode) {
        ModelNode webSubSystem;
        ModelNode subsystem;
        if (deploymentNode.hasDefined("subsystem") && (subsystem = deploymentNode.get("subsystem")).hasDefined(UNDERTOW) && (webSubSystem = subsystem.get(UNDERTOW)).isDefined() && webSubSystem.hasDefined("context-root")) {
            String contextName = webSubSystem.get("context-root").asString();
            if (webSubSystem.hasDefined(SERVLET)) {
                for (ModelNode servletNode : webSubSystem.get(SERVLET).asList()) {
                    for (String servletName : servletNode.keys()) {
                        context.add(new Servlet(servletName, this.toContextName(contextName)));
                    }
                }
            }
            context.add(new Servlet("default", this.toContextName(contextName)));
        }
    }

    private String toContextName(String deploymentName) {
        String correctedName = deploymentName;
        if (correctedName.startsWith("/")) {
            correctedName = correctedName.substring(1);
        }
        if (correctedName.indexOf(".") != -1) {
            correctedName = correctedName.substring(0, correctedName.lastIndexOf("."));
        }
        return correctedName;
    }

    private void lazyLoadRootNode() {
        try {
            if (this.rootNode == null) {
                this.readRootNode();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private ModelNode readResource(ModelNode address) throws Exception {
        return this.readResource(address, true);
    }

    private ModelNode readResource(ModelNode address, boolean includeRuntime) throws Exception {
        ModelNode operation = new ModelNode();
        operation.get("operation").set("read-resource");
        operation.get("recursive").set("true");
        operation.get("include-runtime").set(includeRuntime);
        operation.get("address").set(address);
        return this.executeForResult(operation);
    }

    private ModelNode readAttribute(String attribute, ModelNode address) throws Exception {
        ModelNode operation = new ModelNode();
        operation.get("operation").set("read-attribute");
        operation.get(NAME).set(attribute);
        operation.get("address").set(address);
        return this.executeForResult(operation);
    }

    private ModelNode executeOperation(String operation, ModelNode address) throws Exception {
        ModelNode request = new ModelNode();
        request.get("operation").set(operation);
        request.get("address").set(address);
        return this.executeForResult(request);
    }

    private ModelNode executeForResult(ModelNode operation) throws Exception {
        ModelNode result = this.client.execute(operation);
        this.checkSuccessful(result, operation);
        return result.get("result");
    }

    private void checkSuccessful(ModelNode result, ModelNode operation) throws UnSuccessfulOperationException {
        if (!"success".equals(result.get("outcome").asString())) {
            System.out.println(result);
            throw new UnSuccessfulOperationException(result.get("failure-description").toString());
        }
    }

    private MBeanServerConnection getConnection() {
        if (this.connection == null) {
            try {
                HashMap<String, CallbackHandler> env = new HashMap<String, CallbackHandler>();
                env.put(CallbackHandler.class.getName(), Authentication.getCallbackHandler());
                this.connection = JMXConnectorFactory.connect(this.getRemoteJMXURL(), env).getMBeanServerConnection();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.connection;
    }

    private JMXServiceURL getRemoteJMXURL() {
        try {
            return new JMXServiceURL("service:jmx:remoting-jmx://" + NetworkUtils.formatPossibleIpv6Address(this.mgmtAddress) + ":" + this.mgmtPort);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create JMXServiceURL:" + this, e);
        }
    }

    private static class UnSuccessfulOperationException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public UnSuccessfulOperationException(String message) {
            super(message);
        }
    }
}

