/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container.managed;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramSocket;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.as.arquillian.container.CommonDeployableContainer;
import org.jboss.as.arquillian.container.managed.ManagedContainerConfiguration;
import org.jboss.as.arquillian.container.managed.PortAcquisitionTimeoutException;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.server.ServerMessages;
import org.jboss.dmr.ModelNode;

public final class ManagedDeployableContainer
extends CommonDeployableContainer<ManagedContainerConfiguration> {
    static final String TEMP_CONTAINER_DIRECTORY = "arquillian-temp-container";
    static final String CONFIG_DIR = "configuration";
    static final String SERVER_BASE_DIR = "standalone";
    static final String LOG_DIR = "log";
    static final String DATA_DIR = "data";
    private static final int PORT_RANGE_MIN = 1;
    private static final int PORT_RANGE_MAX = 65535;
    private final Logger log = Logger.getLogger(ManagedDeployableContainer.class.getName());
    private Thread shutdownThread;
    private Process process;

    public Class<ManagedContainerConfiguration> getConfigurationClass() {
        return ManagedContainerConfiguration.class;
    }

    private static boolean processHasDied(Process process) {
        try {
            process.exitValue();
            return true;
        }
        catch (IllegalThreadStateException e) {
            return false;
        }
    }

    protected void startInternal() throws LifecycleException {
        ManagedContainerConfiguration config = (ManagedContainerConfiguration)this.getContainerConfiguration();
        if (this.isServerRunning()) {
            if (config.isAllowConnectingToRunningServer()) {
                return;
            }
            this.failDueToRunning();
        }
        try {
            String bundlesPath;
            String jbossHome = config.getJbossHome();
            File jbossHomeDir = new File(jbossHome).getCanonicalFile();
            if (!jbossHomeDir.isDirectory()) {
                throw new IllegalStateException("Cannot find: " + jbossHomeDir);
            }
            String modulesPath = config.getModulePath();
            if (modulesPath == null || modulesPath.isEmpty()) {
                modulesPath = jbossHome + File.separatorChar + "modules";
            }
            if ((bundlesPath = config.getBundlePath()) == null || bundlesPath.isEmpty()) {
                bundlesPath = jbossHome + File.separatorChar + "bundles";
            }
            String additionalJavaOpts = config.getJavaVmArguments();
            File modulesJar = new File(jbossHome + File.separatorChar + "jboss-modules.jar");
            if (!modulesJar.exists()) {
                throw new IllegalStateException("Cannot find: " + modulesJar);
            }
            ArrayList<String> cmd = new ArrayList<String>();
            String javaExec = config.getJavaHome() + File.separatorChar + "bin" + File.separatorChar + "java";
            if (config.getJavaHome().contains(" ")) {
                javaExec = "\"" + javaExec + "\"";
            }
            cmd.add(javaExec);
            if (additionalJavaOpts != null) {
                for (String opt : additionalJavaOpts.split("\\s+")) {
                    cmd.add(opt);
                }
            }
            if (config.isEnableAssertions()) {
                cmd.add("-ea");
            }
            String serverBaseDir = this.getSystemPropertyValue(cmd, "jboss.server.base.dir", jbossHome + File.separatorChar + SERVER_BASE_DIR);
            if (config.isSetupCleanServerBaseDir() || config.getCleanServerBaseDir() != null) {
                serverBaseDir = ManagedDeployableContainer.setupCleanServerDirectories(serverBaseDir, jbossHome, config.getCleanServerBaseDir()).getAbsolutePath();
                this.replaceSystemPropertyValue(cmd, "jboss.server.base.dir", serverBaseDir);
            }
            String bootLogFileDefaultValue = serverBaseDir + File.separatorChar + LOG_DIR + File.separatorChar + "server.log";
            String loggingConfigurationDefaultValue = serverBaseDir + File.separatorChar + CONFIG_DIR + File.separatorChar + "logging.properties";
            cmd.add("-Djboss.home.dir=" + jbossHome);
            cmd.add("-Dorg.jboss.boot.log.file=" + this.getSystemPropertyValue(cmd, "org.jboss.boot.log.file", ManagedDeployableContainer.getFile(bootLogFileDefaultValue, jbossHome).getAbsolutePath()));
            cmd.add("-Dlogging.configuration=" + this.getSystemPropertyValue(cmd, "logging.configuration", ManagedDeployableContainer.getFile(loggingConfigurationDefaultValue, jbossHome).toURI().toString()));
            cmd.add("-Djboss.bundles.dir=" + bundlesPath);
            cmd.add("-jar");
            cmd.add(modulesJar.getAbsolutePath());
            cmd.add("-mp");
            cmd.add(modulesPath);
            cmd.add("org.jboss.as.standalone");
            cmd.add("-server-config");
            cmd.add(config.getServerConfig());
            if (config.isAdminOnly()) {
                cmd.add("--admin-only");
            }
            this.waitOnPorts();
            this.log.info("Starting container with: " + ((Object)cmd).toString());
            ProcessBuilder processBuilder = new ProcessBuilder(cmd);
            processBuilder.redirectErrorStream(true);
            this.process = processBuilder.start();
            new Thread(new ConsoleConsumer()).start();
            final Process proc = this.process;
            this.shutdownThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    if (proc != null) {
                        proc.destroy();
                        try {
                            proc.waitFor();
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            });
            Runtime.getRuntime().addShutdownHook(this.shutdownThread);
            long startupTimeout = ((ManagedContainerConfiguration)this.getContainerConfiguration()).getStartupTimeoutInSeconds();
            long timeout = startupTimeout * 1000L;
            boolean serverAvailable = false;
            long sleep = 1000L;
            while (timeout > 0L && !serverAvailable) {
                long before = System.currentTimeMillis();
                serverAvailable = this.getManagementClient().isServerInRunningState();
                timeout -= System.currentTimeMillis() - before;
                if (serverAvailable) continue;
                if (ManagedDeployableContainer.processHasDied(proc)) break;
                Thread.sleep(sleep);
                timeout -= sleep;
                sleep = Math.max(sleep / 2L, 100L);
            }
            if (!serverAvailable) {
                this.destroyProcess();
                throw new TimeoutException(String.format("Managed server was not started within [%d] s", ((ManagedContainerConfiguration)this.getContainerConfiguration()).getStartupTimeoutInSeconds()));
            }
        }
        catch (Exception e) {
            throw new LifecycleException("Could not start container", (Throwable)e);
        }
    }

    private void waitOnPorts() throws PortAcquisitionTimeoutException {
        Integer[] ports = ((ManagedContainerConfiguration)this.getContainerConfiguration()).getWaitForPorts();
        int timeoutInSeconds = ((ManagedContainerConfiguration)this.getContainerConfiguration()).getWaitForPortsTimeoutInSeconds();
        if (ports != null && ports.length > 0) {
            for (int i = 0; i < ports.length; ++i) {
                int port = ports[i];
                long start = System.currentTimeMillis();
                while (!this.isPortAvailable(port)) {
                    int elapsedSeconds = (int)((System.currentTimeMillis() - start) / 1000L);
                    if (elapsedSeconds > timeoutInSeconds) {
                        throw new PortAcquisitionTimeoutException(port, timeoutInSeconds);
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        Thread.interrupted();
                    }
                    this.log.warning("Waiting on port " + port + " to become available for " + (timeoutInSeconds - elapsedSeconds) + "s");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isPortAvailable(int port) {
        if (port < 1 || port > 65535) {
            throw new IllegalArgumentException("Port specified is out of range: " + port);
        }
        ServerSocket ss = null;
        DatagramSocket ds = null;
        try {
            ss = new ServerSocket(port);
            ds = new DatagramSocket(port);
            ss.setReuseAddress(true);
            ds.setReuseAddress(true);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
        }
        finally {
            if (ds != null) {
                ds.close();
            }
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (IOException e) {}
            }
        }
        return false;
    }

    protected void stopInternal() throws LifecycleException {
        if (this.shutdownThread != null) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownThread);
            this.shutdownThread = null;
        }
        try {
            if (this.process != null) {
                Thread shutdown = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(((ManagedContainerConfiguration)ManagedDeployableContainer.this.getContainerConfiguration()).getStopTimeoutInSeconds() * 1000);
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                        if (ManagedDeployableContainer.this.process != null) {
                            ManagedDeployableContainer.this.process.destroy();
                        }
                    }
                });
                shutdown.start();
                ModelNode op = new ModelNode();
                op.get("operation").set("shutdown");
                this.getManagementClient().getControllerClient().executeAsync(op, null);
                this.process.waitFor();
                this.process = null;
                shutdown.interrupt();
            }
        }
        catch (Exception e) {
            try {
                if (this.process != null) {
                    this.process.destroy();
                    this.process.waitFor();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new LifecycleException("Could not stop container", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isServerRunning() {
        Socket socket = null;
        try {
            socket = new Socket(((ManagedContainerConfiguration)this.getContainerConfiguration()).getManagementAddress(), ((ManagedContainerConfiguration)this.getContainerConfiguration()).getManagementPort());
        }
        catch (Exception ignored) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not close isServerStarted socket", e);
                }
            }
        }
        return true;
    }

    private void failDueToRunning() throws LifecycleException {
        throw new LifecycleException("The server is already running! Managed containers do not support connecting to running server instances due to the possible harmful effect of connecting to the wrong server. Please stop server before running or change to another type of container.\nTo disable this check and allow Arquillian to connect to a running server, set allowConnectingToRunningServer to true in the container configuration");
    }

    private int destroyProcess() {
        if (this.process == null) {
            return 0;
        }
        this.process.destroy();
        try {
            return this.process.waitFor();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void replaceSystemPropertyValue(List<String> cmdArguments, String systemPropertyName, String newValue) {
        String argument = "-D" + systemPropertyName + "=";
        Iterator<String> cmdArgumentsIterator = cmdArguments.iterator();
        while (cmdArgumentsIterator.hasNext()) {
            String cmdArgument = cmdArgumentsIterator.next();
            if (!cmdArgument.startsWith(argument)) continue;
            cmdArgumentsIterator.remove();
        }
        cmdArguments.add(argument + newValue);
    }

    private String getSystemPropertyValue(List<String> cmdArguments, String systemPropertyName, String defaultValue) {
        String argument = "-D" + systemPropertyName + "=";
        for (String cmdArgument : cmdArguments) {
            if (!cmdArgument.startsWith(argument)) continue;
            return cmdArgument.substring(argument.length());
        }
        return defaultValue;
    }

    static File getFile(String filePathname, String jbossHome) {
        File relative;
        File result = new File(filePathname);
        if (!result.exists() && !result.isAbsolute() && (relative = new File(jbossHome, filePathname)).exists()) {
            result = relative;
        }
        return result;
    }

    static File setupCleanServerDirectories(String serverBaseDir, String jbossHome, String cleanServerBaseDirPath) throws IOException {
        File cleanServerBaseDir = cleanServerBaseDirPath != null ? new File(cleanServerBaseDirPath) : ManagedDeployableContainer.createTempServerBaseDirectory();
        if (!cleanServerBaseDir.exists()) {
            throw ServerMessages.MESSAGES.serverBaseDirectoryDoesNotExist(cleanServerBaseDir);
        }
        if (!cleanServerBaseDir.isDirectory()) {
            throw ServerMessages.MESSAGES.serverBaseDirectoryIsNotADirectory(cleanServerBaseDir);
        }
        ManagedDeployableContainer.copyOriginalDirectoryToCleanServerBaseDir(CONFIG_DIR, serverBaseDir, jbossHome, cleanServerBaseDir);
        ManagedDeployableContainer.copyOriginalDirectoryToCleanServerBaseDir(DATA_DIR, serverBaseDir, jbossHome, cleanServerBaseDir);
        File deploymentsDir = new File(cleanServerBaseDir, "deployments");
        deploymentsDir.mkdir();
        return cleanServerBaseDir;
    }

    static void copyOriginalDirectoryToCleanServerBaseDir(String originalDirName, String serverBaseDir, String jbossHome, File cleanServerBaseDir) throws IOException {
        File originalDir = ManagedDeployableContainer.getFile(serverBaseDir + File.separatorChar + originalDirName, jbossHome);
        File cleanDir = new File(cleanServerBaseDir, originalDirName);
        cleanDir.mkdir();
        if (originalDir.exists()) {
            ManagedDeployableContainer.copyDirectory(originalDir, cleanDir);
        }
    }

    static File createTempServerBaseDirectory() throws IOException {
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        File tempContainer = new File(tempDir, TEMP_CONTAINER_DIRECTORY);
        if (tempContainer.exists()) {
            ManagedDeployableContainer.deleteRecursively(tempContainer);
        }
        if (!tempContainer.mkdir()) {
            throw new IOException("Could not create temp directory: " + tempContainer.getAbsolutePath());
        }
        return tempContainer;
    }

    private static void copyDirectory(File src, File dest) {
        for (String current : src.list()) {
            File srcFile = new File(src, current);
            File destFile = new File(dest, current);
            if (srcFile.isDirectory()) {
                destFile.mkdir();
                ManagedDeployableContainer.copyDirectory(srcFile, destFile);
                continue;
            }
            try {
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(srcFile));
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(destFile));
                try {
                    int i;
                    while ((i = ((InputStream)in).read()) != -1) {
                        ((OutputStream)out).write(i);
                    }
                }
                catch (IOException e) {
                    throw ServerMessages.MESSAGES.errorCopyingFile(srcFile.getAbsolutePath(), destFile.getAbsolutePath(), e);
                }
                finally {
                    StreamUtils.safeClose((Closeable)in);
                    StreamUtils.safeClose((Closeable)out);
                }
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static void deleteRecursively(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                for (String name : file.list()) {
                    ManagedDeployableContainer.deleteRecursively(new File(file, name));
                }
            }
            file.delete();
        }
    }

    private class ConsoleConsumer
    implements Runnable {
        private ConsoleConsumer() {
        }

        @Override
        public void run() {
            InputStream stream = ManagedDeployableContainer.this.process.getInputStream();
            boolean writeOutput = ((ManagedContainerConfiguration)ManagedDeployableContainer.this.getContainerConfiguration()).isOutputToConsole();
            try {
                int num;
                byte[] buf = new byte[32];
                while ((num = stream.read(buf)) != -1) {
                    if (!writeOutput) continue;
                    System.out.write(buf, 0, num);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

