/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.batch.jberet;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jberet.repository.JobRepository;
import org.jberet.spi.BatchEnvironment;
import org.jberet.spi.ContextClassLoaderJobOperatorContextSelector;
import org.jberet.spi.JobExecutor;
import org.jberet.spi.JobOperatorContext;
import org.jberet.spi.JobOperatorContextSelector;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.deployment.jbossallxml.JBossAllXMLParser;
import org.jboss.as.server.deployment.jbossallxml.JBossAllXmlParserRegisteringProcessor;
import org.jboss.as.threads.ThreadFactoryResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.extension.batch.jberet.AttributeMarshallers;
import org.wildfly.extension.batch.jberet.AttributeParsers;
import org.wildfly.extension.batch.jberet.BatchConfiguration;
import org.wildfly.extension.batch.jberet.BatchConfigurationService;
import org.wildfly.extension.batch.jberet.BatchResourceDescriptionResolver;
import org.wildfly.extension.batch.jberet.DefaultBatchEnvironment;
import org.wildfly.extension.batch.jberet._private.Capabilities;
import org.wildfly.extension.batch.jberet.deployment.BatchAttachments;
import org.wildfly.extension.batch.jberet.deployment.BatchCleanupProcessor;
import org.wildfly.extension.batch.jberet.deployment.BatchDependencyProcessor;
import org.wildfly.extension.batch.jberet.deployment.BatchDeploymentDescriptorParser_1_0;
import org.wildfly.extension.batch.jberet.deployment.BatchDeploymentDescriptorParser_2_0;
import org.wildfly.extension.batch.jberet.deployment.BatchDeploymentDescriptorParser_3_0;
import org.wildfly.extension.batch.jberet.deployment.BatchDeploymentResourceProcessor;
import org.wildfly.extension.batch.jberet.deployment.BatchEnvironmentProcessor;
import org.wildfly.extension.batch.jberet.job.repository.InMemoryJobRepositoryDefinition;
import org.wildfly.extension.batch.jberet.job.repository.JdbcJobRepositoryDefinition;
import org.wildfly.extension.batch.jberet.thread.pool.BatchThreadPoolResourceDefinition;
import org.wildfly.security.auth.server.SecurityDomain;

public class BatchSubsystemDefinition
extends SimpleResourceDefinition {
    public static final String NAME = "batch-jberet";
    public static final PathElement SUBSYSTEM_PATH = PathElement.pathElement((String)"subsystem", (String)"batch-jberet");
    static final String THREAD_FACTORY = "thread-factory";
    static final SimpleAttributeDefinition DEFAULT_JOB_REPOSITORY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"default-job-repository", (ModelType)ModelType.STRING, (boolean)false).setAllowExpression(false)).setAttributeGroup("environment")).setAttributeMarshaller(AttributeMarshallers.NAMED)).setCapabilityReference(Capabilities.JOB_REPOSITORY_CAPABILITY.getName(), Capabilities.BATCH_CONFIGURATION_CAPABILITY)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition DEFAULT_THREAD_POOL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"default-thread-pool", (ModelType)ModelType.STRING, (boolean)false).setAllowExpression(false)).setAttributeGroup("environment")).setAttributeMarshaller(AttributeMarshallers.NAMED)).setCapabilityReference(Capabilities.THREAD_POOL_CAPABILITY.getName(), Capabilities.BATCH_CONFIGURATION_CAPABILITY)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition RESTART_JOBS_ON_RESUME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"restart-jobs-on-resume", (ModelType)ModelType.BOOLEAN, (boolean)true).setAllowExpression(true)).setDefaultValue(ModelNode.TRUE)).setAttributeParser(AttributeParsers.VALUE)).setAttributeMarshaller(AttributeMarshallers.VALUE)).build();
    static final SimpleAttributeDefinition SECURITY_DOMAIN = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"security-domain", (ModelType)ModelType.STRING, (boolean)true).setAttributeMarshaller(AttributeMarshallers.NAMED)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setCapabilityReference("org.wildfly.security.security-domain", Capabilities.BATCH_CONFIGURATION_CAPABILITY)).setAccessConstraints(new AccessConstraintDefinition[]{SensitiveTargetAccessConstraintDefinition.ELYTRON_SECURITY_DOMAIN_REF})).build();
    private final boolean registerRuntimeOnly;

    BatchSubsystemDefinition(boolean registerRuntimeOnly) {
        super(new SimpleResourceDefinition.Parameters(SUBSYSTEM_PATH, (ResourceDescriptionResolver)BatchResourceDescriptionResolver.getResourceDescriptionResolver()).setAddHandler((OperationStepHandler)BatchSubsystemAdd.INSTANCE).setRemoveHandler((OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE).addCapabilities(new RuntimeCapability[]{Capabilities.BATCH_CONFIGURATION_CAPABILITY}));
        this.registerRuntimeOnly = registerRuntimeOnly;
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        resourceRegistration.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE);
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        super.registerChildren(resourceRegistration);
        resourceRegistration.registerSubModel((ResourceDefinition)new InMemoryJobRepositoryDefinition());
        resourceRegistration.registerSubModel((ResourceDefinition)new JdbcJobRepositoryDefinition());
        resourceRegistration.registerSubModel((ResourceDefinition)new BatchThreadPoolResourceDefinition(this.registerRuntimeOnly));
        ThreadFactoryResourceDefinition threadFactoryResource = new ThreadFactoryResourceDefinition();
        resourceRegistration.registerSubModel((ResourceDefinition)threadFactoryResource);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        ReloadRequiredWriteAttributeHandler writeHandler = new ReloadRequiredWriteAttributeHandler(new AttributeDefinition[]{DEFAULT_JOB_REPOSITORY, DEFAULT_THREAD_POOL, SECURITY_DOMAIN});
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)DEFAULT_JOB_REPOSITORY, null, (OperationStepHandler)writeHandler);
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)DEFAULT_THREAD_POOL, null, (OperationStepHandler)writeHandler);
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)SECURITY_DOMAIN, null, (OperationStepHandler)writeHandler);
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)RESTART_JOBS_ON_RESUME, null, (OperationStepHandler)new AbstractWriteAttributeHandler<Boolean>(new AttributeDefinition[]{RESTART_JOBS_ON_RESUME}){

            protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Boolean> handbackHolder) throws OperationFailedException {
                this.setValue(context, resolvedValue);
                return false;
            }

            protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Boolean handback) throws OperationFailedException {
                this.setValue(context, valueToRestore);
            }

            private void setValue(OperationContext context, ModelNode value) {
                BatchConfigurationService service = (BatchConfigurationService)context.getServiceRegistry(true).getService(context.getCapabilityServiceName(Capabilities.BATCH_CONFIGURATION_CAPABILITY.getName(), BatchConfiguration.class)).getService();
                service.setRestartOnResume(value.asBoolean());
            }
        });
    }

    static class BatchSubsystemAdd
    extends AbstractBoottimeAddStepHandler {
        static final BatchSubsystemAdd INSTANCE = new BatchSubsystemAdd();
        private final ContextClassLoaderJobOperatorContextSelector selector = new ContextClassLoaderJobOperatorContextSelector(() -> JobOperatorContext.create((BatchEnvironment)DefaultBatchEnvironment.INSTANCE));

        private BatchSubsystemAdd() {
            super(new AttributeDefinition[]{DEFAULT_JOB_REPOSITORY, DEFAULT_THREAD_POOL, RESTART_JOBS_ON_RESUME, SECURITY_DOMAIN});
            JobOperatorContext.setJobOperatorContextSelector((JobOperatorContextSelector)this.selector);
        }

        protected void performBoottime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            final boolean rcPresent = context.hasOptionalCapability("org.wildfly.request-controller", null, null);
            context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

                public void execute(DeploymentProcessorTarget processorTarget) {
                    JBossAllXmlParserRegisteringProcessor jbossAllProcessor = JBossAllXmlParserRegisteringProcessor.builder().addParser(BatchDeploymentDescriptorParser_1_0.ROOT_ELEMENT, BatchAttachments.BATCH_ENVIRONMENT_META_DATA, (JBossAllXMLParser)new BatchDeploymentDescriptorParser_1_0()).addParser(BatchDeploymentDescriptorParser_2_0.ROOT_ELEMENT, BatchAttachments.BATCH_ENVIRONMENT_META_DATA, (JBossAllXMLParser)new BatchDeploymentDescriptorParser_2_0()).addParser(BatchDeploymentDescriptorParser_3_0.ROOT_ELEMENT, BatchAttachments.BATCH_ENVIRONMENT_META_DATA, (JBossAllXMLParser)new BatchDeploymentDescriptorParser_3_0()).build();
                    processorTarget.addDeploymentProcessor(BatchSubsystemDefinition.NAME, Phase.STRUCTURE, 2587, (DeploymentUnitProcessor)jbossAllProcessor);
                    processorTarget.addDeploymentProcessor(BatchSubsystemDefinition.NAME, Phase.DEPENDENCIES, 6912, (DeploymentUnitProcessor)new BatchDependencyProcessor());
                    processorTarget.addDeploymentProcessor(BatchSubsystemDefinition.NAME, Phase.POST_MODULE, 12544, (DeploymentUnitProcessor)new BatchEnvironmentProcessor(rcPresent, selector));
                    processorTarget.addDeploymentProcessor(BatchSubsystemDefinition.NAME, Phase.INSTALL, 8304, (DeploymentUnitProcessor)new BatchDeploymentResourceProcessor(BatchSubsystemDefinition.NAME));
                    processorTarget.addDeploymentProcessor(BatchSubsystemDefinition.NAME, Phase.CLEANUP, 1280, (DeploymentUnitProcessor)new BatchCleanupProcessor());
                }
            }, OperationContext.Stage.RUNTIME);
            ModelNode defaultJobRepository = DEFAULT_JOB_REPOSITORY.resolveModelAttribute(context, model);
            ModelNode defaultThreadPool = DEFAULT_THREAD_POOL.resolveModelAttribute(context, model);
            ModelNode securityDomain = SECURITY_DOMAIN.resolveModelAttribute(context, model);
            boolean restartOnResume = RESTART_JOBS_ON_RESUME.resolveModelAttribute(context, model).asBoolean();
            ServiceTarget target = context.getServiceTarget();
            ServiceName sn = context.getCapabilityServiceName(Capabilities.BATCH_CONFIGURATION_CAPABILITY.getName(), BatchConfiguration.class);
            ServiceBuilder serviceBuilder = target.addService(sn);
            Consumer batchConfigurationConsumer = serviceBuilder.provides(new ServiceName[]{sn});
            Supplier jobRepositorySupplier = serviceBuilder.requires(context.getCapabilityServiceName(Capabilities.JOB_REPOSITORY_CAPABILITY.getName(), defaultJobRepository.asString(), JobRepository.class));
            Supplier jobExecutorSupplier = serviceBuilder.requires(context.getCapabilityServiceName(Capabilities.THREAD_POOL_CAPABILITY.getName(), defaultThreadPool.asString(), JobExecutor.class));
            Supplier securityDomainSupplier = securityDomain.isDefined() ? serviceBuilder.requires(context.getCapabilityServiceName("org.wildfly.security.security-domain", securityDomain.asString(), SecurityDomain.class)) : null;
            serviceBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND);
            BatchConfigurationService service = new BatchConfigurationService(batchConfigurationConsumer, jobRepositorySupplier, jobExecutorSupplier, securityDomainSupplier);
            service.setRestartOnResume(restartOnResume);
            serviceBuilder.setInstance((Service)service);
            serviceBuilder.install();
        }
    }
}

