/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Predicate;
import javax.security.auth.callback.CallbackHandler;
import org.wildfly.common.Assert;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;
import org.wildfly.security.http.HttpServerAuthenticationMechanismFactory;
import org.wildfly.security.http.util.ElytronMessages;

public final class FilterServerMechanismFactory
implements HttpServerAuthenticationMechanismFactory {
    private final HttpServerAuthenticationMechanismFactory delegate;
    private final Predicate<String> predicate;

    public FilterServerMechanismFactory(HttpServerAuthenticationMechanismFactory delegate, Predicate<String> predicate) {
        this.delegate = Assert.checkNotNullParam("delegate", delegate);
        this.predicate = Assert.checkNotNullParam("predicate", predicate);
    }

    public FilterServerMechanismFactory(HttpServerAuthenticationMechanismFactory delegate, boolean include, String ... mechanismNames) {
        this.delegate = Assert.checkNotNullParam("delegate", delegate);
        HashSet nameSet = new HashSet(mechanismNames.length);
        Collections.addAll(nameSet, mechanismNames);
        Predicate<String> predicate = nameSet::contains;
        this.predicate = include ? predicate : predicate.negate();
    }

    public FilterServerMechanismFactory(HttpServerAuthenticationMechanismFactory delegate, boolean include, Collection<String> mechanismNames) {
        this.delegate = Assert.checkNotNullParam("delegate", delegate);
        HashSet<String> nameSet = new HashSet<String>(Assert.checkNotNullParam("mechanismNames", mechanismNames));
        Predicate<String> predicate = nameSet::contains;
        this.predicate = include ? predicate : predicate.negate();
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> properties) {
        Object[] allMechanisms = this.delegate.getMechanismNames(properties);
        ArrayList<String> filtered = new ArrayList<String>(allMechanisms.length);
        for (String string : allMechanisms) {
            if (!this.predicate.test(string)) continue;
            filtered.add(string);
        }
        if (filtered.size() == 0 && ElytronMessages.log.isTraceEnabled()) {
            ElytronMessages.log.tracef("No mechanisms after filtering by %s (original mechanisms: %s)", (Object)FilterServerMechanismFactory.class.getSimpleName(), (Object)Arrays.toString(allMechanisms));
        }
        return filtered.toArray(new String[filtered.size()]);
    }

    @Override
    public HttpServerAuthenticationMechanism createAuthenticationMechanism(String mechanismName, Map<String, ?> properties, CallbackHandler callbackHandler) throws HttpAuthenticationException {
        return this.predicate.test(mechanismName) ? this.delegate.createAuthenticationMechanism(mechanismName, properties, callbackHandler) : null;
    }
}

