/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.jboss.ejb.client.EJBClientManagedTransactionContext;
import org.jboss.ejb.client.EJBReceiver;
import org.jboss.ejb.client.EJBReceiverContext;
import org.jboss.ejb.client.Logs;
import org.jboss.ejb.client.XidTransactionID;

class RecoveryOnlyEJBXAResource
implements XAResource {
    private final EJBReceiverContext receiverContext;
    private final String transactionOriginNodeIdentifier;

    RecoveryOnlyEJBXAResource(String transactionOriginNodeIdentifier, EJBReceiverContext receiverContext) {
        this.receiverContext = receiverContext;
        this.transactionOriginNodeIdentifier = transactionOriginNodeIdentifier;
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        XidTransactionID transactionID = new XidTransactionID(xid);
        EJBReceiver receiver = this.receiverContext.getReceiver();
        Logs.TXN.debugf("Sending commit request for Xid %s to EJB receiver with node name %s during recovery. One phase? %s", (Object)xid, (Object)receiver.getNodeName(), (Object)onePhase);
        receiver.sendCommit(this.receiverContext, transactionID, onePhase);
    }

    @Override
    public void end(Xid xid, int i) throws XAException {
        Logs.TXN.debugf("Ignoring end request on XAResource %s since this XAResource is only meant for transaction recovery", (Object)this);
    }

    @Override
    public void forget(Xid xid) throws XAException {
        XidTransactionID transactionID = new XidTransactionID(xid);
        EJBReceiver receiver = this.receiverContext.getReceiver();
        Logs.TXN.debugf("Sending forget request for Xid %s to EJB receiver with node name %s during recovery", (Object)xid, (Object)receiver.getNodeName());
        receiver.sendForget(this.receiverContext, transactionID);
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return 0;
    }

    @Override
    public boolean isSameRM(XAResource xaResource) throws XAException {
        if (xaResource == null) {
            return false;
        }
        boolean toReturn = EJBClientManagedTransactionContext.isEJBXAResourceClass(xaResource.getClass().getName());
        if (toReturn && (toReturn = xaResource instanceof RecoveryOnlyEJBXAResource)) {
            EJBReceiver receiver = this.receiverContext.getReceiver();
            RecoveryOnlyEJBXAResource other = (RecoveryOnlyEJBXAResource)xaResource;
            EJBReceiver otherReceiver = other.receiverContext.getReceiver();
            toReturn = receiver.getNodeName().equals(otherReceiver.getNodeName());
        }
        return toReturn;
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        Logs.TXN.debugf("Prepare wasn't supposed to be called on %s since this XAResource is only meant for transaction recovery. Ignoring the prepare request for xid %s", (Object)this, (Object)xid);
        return 0;
    }

    @Override
    public Xid[] recover(int flags) throws XAException {
        EJBReceiver receiver = this.receiverContext.getReceiver();
        Logs.TXN.debugf("Send recover request for transaction origin node identifier %s to EJB receiver with node name %s", (Object)this.transactionOriginNodeIdentifier, (Object)receiver.getNodeName());
        return receiver.sendRecover(this.receiverContext, this.transactionOriginNodeIdentifier, flags);
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        XidTransactionID transactionID = new XidTransactionID(xid);
        EJBReceiver receiver = this.receiverContext.getReceiver();
        Logs.TXN.debugf("Sending rollback request for Xid %s to EJB receiver with node name %s during recovery", (Object)xid, (Object)receiver.getNodeName());
        receiver.sendRollback(this.receiverContext, transactionID);
    }

    @Override
    public boolean setTransactionTimeout(int i) throws XAException {
        return false;
    }

    @Override
    public void start(Xid xid, int i) throws XAException {
        Logs.TXN.debugf("Ignoring start request on XAResource %s since this XAResource is only meant for transaction recovery", (Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RecoveryOnlyEJBXAResource");
        sb.append("{receiverContext=").append(this.receiverContext);
        sb.append(", transactionOriginNodeIdentifier='").append(this.transactionOriginNodeIdentifier).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

