/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.common.net;

import java.io.Serializable;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import org.wildfly.common.Assert;
import org.wildfly.common._private.CommonMessages;
import org.wildfly.common.math.HashMath;
import org.wildfly.common.net.Inet;

public final class CidrAddress
implements Serializable {
    private static final long serialVersionUID = -6548529324373774149L;
    public static final CidrAddress INET4_ANY_CIDR = new CidrAddress(Inet.INET4_ANY, 0);
    public static final CidrAddress INET6_ANY_CIDR = new CidrAddress(Inet.INET6_ANY, 0);
    private final InetAddress networkAddress;
    private final byte[] cachedBytes;
    private final int netmaskBits;
    private Inet4Address broadcast;
    private String toString;
    private int hashCode;

    CidrAddress(InetAddress networkAddress, int netmaskBits) {
        this.networkAddress = networkAddress;
        this.cachedBytes = networkAddress.getAddress();
        this.netmaskBits = netmaskBits;
    }

    public static CidrAddress create(InetAddress networkAddress, int netmaskBits) {
        Assert.checkNotNullParam("networkAddress", networkAddress);
        Assert.checkMinimumParameter("netmaskBits", 0, netmaskBits);
        if (networkAddress instanceof Inet4Address) {
            Assert.checkMaximumParameter("netmaskBits", 32, netmaskBits);
            if (netmaskBits == 0) {
                return INET4_ANY_CIDR;
            }
        } else if (networkAddress instanceof Inet6Address) {
            Assert.checkMaximumParameter("netmaskBits", 128, netmaskBits);
            if (netmaskBits == 0) {
                return INET6_ANY_CIDR;
            }
        } else {
            throw Assert.unreachableCode();
        }
        byte[] bytes = networkAddress.getAddress();
        CidrAddress.maskBits0(bytes, netmaskBits);
        String name = Inet.toOptimalString(bytes);
        try {
            return new CidrAddress(InetAddress.getByAddress(name, bytes), netmaskBits);
        }
        catch (UnknownHostException e) {
            throw Assert.unreachableCode();
        }
    }

    public static CidrAddress create(byte[] addressBytes, int netmaskBits) {
        return CidrAddress.create(addressBytes, netmaskBits, true);
    }

    static CidrAddress create(byte[] addressBytes, int netmaskBits, boolean clone) {
        Assert.checkNotNullParam("networkAddress", addressBytes);
        Assert.checkMinimumParameter("netmaskBits", 0, netmaskBits);
        int length = addressBytes.length;
        if (length == 4) {
            Assert.checkMaximumParameter("netmaskBits", 32, netmaskBits);
            if (netmaskBits == 0) {
                return INET4_ANY_CIDR;
            }
        } else if (length == 16) {
            Assert.checkMaximumParameter("netmaskBits", 128, netmaskBits);
            if (netmaskBits == 0) {
                return INET6_ANY_CIDR;
            }
        } else {
            throw CommonMessages.msg.invalidAddressBytes(length);
        }
        byte[] bytes = clone ? (byte[])addressBytes.clone() : addressBytes;
        CidrAddress.maskBits0(bytes, netmaskBits);
        String name = Inet.toOptimalString(bytes);
        try {
            return new CidrAddress(InetAddress.getByAddress(name, bytes), netmaskBits);
        }
        catch (UnknownHostException e) {
            throw Assert.unreachableCode();
        }
    }

    public boolean isMatchedBy(InetAddress address) {
        Assert.checkNotNullParam("address", address);
        if (address instanceof Inet4Address) {
            return this.isMatchedBy((Inet4Address)address);
        }
        if (address instanceof Inet6Address) {
            return this.isMatchedBy((Inet6Address)address);
        }
        throw Assert.unreachableCode();
    }

    public boolean isMatchedBy(Inet4Address address) {
        Assert.checkNotNullParam("address", address);
        return this.networkAddress instanceof Inet4Address && CidrAddress.bitsMatch(this.cachedBytes, address.getAddress(), this.netmaskBits);
    }

    public boolean isMatchedBy(Inet6Address address) {
        Assert.checkNotNullParam("address", address);
        return this.networkAddress instanceof Inet6Address && CidrAddress.bitsMatch(this.cachedBytes, address.getAddress(), this.netmaskBits);
    }

    public InetAddress getNetworkAddress() {
        return this.networkAddress;
    }

    public Inet4Address getBroadcastAddress() {
        Inet4Address broadcast = this.broadcast;
        if (broadcast == null) {
            int netmaskBits = this.netmaskBits;
            if (netmaskBits >= 31) {
                return null;
            }
            byte[] cachedBytes = this.cachedBytes;
            if (cachedBytes.length == 4) {
                if (netmaskBits == 0) {
                    this.broadcast = Inet.INET4_BROADCAST;
                    return this.broadcast;
                }
                byte[] bytes = CidrAddress.maskBits1((byte[])cachedBytes.clone(), netmaskBits);
                try {
                    this.broadcast = (Inet4Address)InetAddress.getByAddress(Inet.toOptimalString(bytes), bytes);
                    return this.broadcast;
                }
                catch (UnknownHostException e) {
                    throw Assert.unreachableCode();
                }
            }
            return null;
        }
        return broadcast;
    }

    public int getNetmaskBits() {
        return this.netmaskBits;
    }

    public boolean equals(Object obj) {
        return obj instanceof CidrAddress && this.equals((CidrAddress)obj);
    }

    public boolean equals(CidrAddress obj) {
        return obj == this || obj != null && this.netmaskBits == obj.netmaskBits && Arrays.equals(this.cachedBytes, obj.cachedBytes);
    }

    public int hashCode() {
        int hashCode = this.hashCode;
        if (hashCode == 0) {
            hashCode = HashMath.multiHashOrdered(this.netmaskBits, Arrays.hashCode(this.cachedBytes));
            if (hashCode == 0) {
                hashCode = 1;
            }
            this.hashCode = hashCode;
        }
        return hashCode;
    }

    public String toString() {
        String toString = this.toString;
        if (toString == null) {
            this.toString = String.format("%s/%d", Inet.toOptimalString(this.cachedBytes), this.netmaskBits);
            return this.toString;
        }
        return toString;
    }

    Object writeReplace() {
        return new Ser(this.cachedBytes, this.netmaskBits);
    }

    private static boolean bitsMatch(byte[] address, byte[] test, int bits) {
        int i;
        int length = address.length;
        assert (length == test.length);
        for (i = 0; bits >= 8 && i < length; ++i, bits -= 8) {
            if (address[i] == test[i]) continue;
            return false;
        }
        if (bits > 0) {
            assert (bits < 8);
            int mask = 255 << 8 - bits;
            if ((address[i] & 0xFF & mask) != (test[i] & 0xFF & mask)) {
                return false;
            }
        }
        return true;
    }

    private static byte[] maskBits0(byte[] address, int bits) {
        int i;
        int length = address.length;
        for (i = 0; bits >= 8 && i < length; ++i, bits -= 8) {
        }
        if (bits > 0) {
            assert (bits < 8);
            int mask = 255 << 8 - bits;
            int n = i++;
            address[n] = (byte)(address[n] & mask);
        }
        while (i < length) {
            address[i++] = 0;
        }
        return address;
    }

    private static byte[] maskBits1(byte[] address, int bits) {
        int i;
        int length = address.length;
        for (i = 0; bits >= 8 && i < length; ++i, bits -= 8) {
        }
        if (bits > 0) {
            assert (bits < 8);
            int mask = 255 >>> 8 - bits;
            int n = i++;
            address[n] = (byte)(address[n] | mask);
        }
        while (i < length) {
            address[i++] = -1;
        }
        return address;
    }

    static final class Ser
    implements Serializable {
        private static final long serialVersionUID = 6367919693596329038L;
        final byte[] b;
        final int m;

        Ser(byte[] b, int m) {
            this.b = b;
            this.m = m;
        }

        Object readResolve() {
            return CidrAddress.create(this.b, this.m, false);
        }
    }
}

