/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import javax.net.ssl.SSLContext;
import org.jboss.remoting3.Attachable;
import org.jboss.remoting3.ConfigurationEndpointSupplier;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.ConnectionPeerIdentity;
import org.jboss.remoting3.DuplicateRegistrationException;
import org.jboss.remoting3.EndpointBuilder;
import org.jboss.remoting3.EndpointGetterHolder;
import org.jboss.remoting3.EndpointImpl;
import org.jboss.remoting3.HandleableCloseable;
import org.jboss.remoting3.OpenListener;
import org.jboss.remoting3.Registration;
import org.jboss.remoting3.ServiceRegistrationException;
import org.jboss.remoting3.ToConnectionFuture;
import org.jboss.remoting3.UnknownURISchemeException;
import org.jboss.remoting3._private.Messages;
import org.jboss.remoting3.spi.ConnectionProviderFactory;
import org.wildfly.common.Assert;
import org.wildfly.common.context.ContextManager;
import org.wildfly.common.context.Contextual;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.AuthenticationContextConfigurationClient;
import org.xnio.FailedIoFuture;
import org.xnio.IoFuture;
import org.xnio.OptionMap;
import org.xnio.XnioWorker;

public interface Endpoint
extends HandleableCloseable<Endpoint>,
Attachable,
Contextual<Endpoint> {
    public static final ContextManager<Endpoint> ENDPOINT_CONTEXT_MANAGER = AccessController.doPrivileged(() -> {
        ContextManager<Endpoint> contextManager = new ContextManager<Endpoint>(Endpoint.class, "jboss-remoting.endpoint");
        contextManager.setGlobalDefaultSupplierIfNotSet(ConfigurationEndpointSupplier::new);
        return contextManager;
    });

    @Override
    default public ContextManager<Endpoint> getInstanceContextManager() {
        return EndpointImpl.ENDPOINT_CONTEXT_MANAGER;
    }

    public static Endpoint getCurrent() {
        return EndpointGetterHolder.SUPPLIER.get();
    }

    public String getName();

    public Registration registerService(String var1, OpenListener var2, OptionMap var3) throws ServiceRegistrationException;

    default public IoFuture<ConnectionPeerIdentity> getConnectedIdentity(URI destination, String abstractType, String abstractTypeAuthority, AuthenticationContext context) {
        SSLContext sslContext;
        Assert.checkNotNullParam("destination", destination);
        Assert.checkNotNullParam("context", context);
        AuthenticationContextConfigurationClient client = EndpointImpl.AUTH_CONFIGURATION_CLIENT;
        try {
            sslContext = client.getSSLContext(destination, context);
        }
        catch (GeneralSecurityException e) {
            return new FailedIoFuture<ConnectionPeerIdentity>(Messages.conn.failedToConfigureSslContext(e));
        }
        AuthenticationConfiguration authenticationConfiguration = client.getAuthenticationConfiguration(destination, context, -1, abstractType, abstractTypeAuthority);
        return this.getConnectedIdentity(destination, sslContext, authenticationConfiguration);
    }

    default public IoFuture<ConnectionPeerIdentity> getConnectedIdentity(URI destination, String abstractType, String abstractTypeAuthority) {
        return this.getConnectedIdentity(destination, abstractType, abstractTypeAuthority, AuthenticationContext.captureCurrent());
    }

    public IoFuture<ConnectionPeerIdentity> getConnectedIdentity(URI var1, SSLContext var2, AuthenticationConfiguration var3);

    default public IoFuture<ConnectionPeerIdentity> getConnectedIdentityIfExists(URI destination, String abstractType, String abstractTypeAuthority, AuthenticationContext context) {
        SSLContext sslContext;
        Assert.checkNotNullParam("destination", destination);
        Assert.checkNotNullParam("context", context);
        AuthenticationContextConfigurationClient client = EndpointImpl.AUTH_CONFIGURATION_CLIENT;
        try {
            sslContext = client.getSSLContext(destination, context);
        }
        catch (GeneralSecurityException e) {
            return new FailedIoFuture<ConnectionPeerIdentity>(Messages.conn.failedToConfigureSslContext(e));
        }
        AuthenticationConfiguration authenticationConfiguration = client.getAuthenticationConfiguration(destination, context, -1, abstractType, abstractTypeAuthority);
        return this.getConnectedIdentityIfExists(destination, sslContext, authenticationConfiguration);
    }

    public IoFuture<ConnectionPeerIdentity> getConnectedIdentityIfExists(URI var1, SSLContext var2, AuthenticationConfiguration var3);

    @Deprecated
    default public IoFuture<Connection> getConnection(URI destination) {
        return this.getConnection(destination, (String)null, null);
    }

    @Deprecated
    default public IoFuture<Connection> getConnection(URI destination, String abstractType, String abstractTypeAuthority) {
        return new ToConnectionFuture(this.getConnectedIdentity(destination, abstractType, abstractTypeAuthority));
    }

    @Deprecated
    default public IoFuture<Connection> getConnection(URI destination, SSLContext sslContext, AuthenticationConfiguration authenticationConfiguration) {
        return new ToConnectionFuture(this.getConnectedIdentity(destination, sslContext, authenticationConfiguration));
    }

    @Deprecated
    default public IoFuture<Connection> getConnection(URI destination, SSLContext sslContext, AuthenticationConfiguration connectionConfiguration, AuthenticationConfiguration operateConfiguration) {
        return this.getConnection(destination, sslContext, operateConfiguration);
    }

    @Deprecated
    default public IoFuture<Connection> getConnectionIfExists(URI destination, SSLContext sslContext, AuthenticationConfiguration connectionConfiguration, AuthenticationConfiguration operateConfiguration) {
        return new ToConnectionFuture(this.getConnectedIdentityIfExists(destination, sslContext, operateConfiguration));
    }

    @Deprecated
    default public IoFuture<Connection> getConnectionIfExists(URI destination, String abstractType, String abstractTypeAuthority) {
        SSLContext sslContext;
        AuthenticationContext context = AuthenticationContext.captureCurrent();
        AuthenticationContextConfigurationClient client = EndpointImpl.AUTH_CONFIGURATION_CLIENT;
        try {
            sslContext = client.getSSLContext(destination, context);
        }
        catch (GeneralSecurityException e) {
            return new FailedIoFuture<Connection>(Messages.conn.failedToConfigureSslContext(e));
        }
        AuthenticationConfiguration authenticationConfiguration = client.getAuthenticationConfiguration(destination, context, -1, abstractType, abstractTypeAuthority);
        return this.getConnectionIfExists(destination, sslContext, authenticationConfiguration, authenticationConfiguration);
    }

    @Deprecated
    default public IoFuture<Connection> getConnectionIfExists(URI destination) {
        return this.getConnectionIfExists(destination, null, null);
    }

    default public IoFuture<Connection> connect(URI destination) {
        return this.connect(destination, OptionMap.EMPTY);
    }

    public IoFuture<Connection> connect(URI var1, OptionMap var2);

    public IoFuture<Connection> connect(URI var1, OptionMap var2, AuthenticationContext var3);

    public IoFuture<Connection> connect(URI var1, InetSocketAddress var2, OptionMap var3, AuthenticationContext var4);

    public IoFuture<Connection> connect(URI var1, InetSocketAddress var2, OptionMap var3, SSLContext var4, AuthenticationConfiguration var5);

    public Registration addConnectionProvider(String var1, ConnectionProviderFactory var2, OptionMap var3) throws DuplicateRegistrationException, IOException;

    public <T> T getConnectionProviderInterface(String var1, Class<T> var2) throws UnknownURISchemeException, ClassCastException;

    public boolean isValidUriScheme(String var1);

    public XnioWorker getXnioWorker();

    public static EndpointBuilder builder() {
        return new EndpointBuilder();
    }
}

