/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.x500.cert.acme;

import org.wildfly.common.Assert;

public final class AcmeMetadata {
    private final String termsOfServiceUrl;
    private final String websiteUrl;
    private final String[] caaIdentities;
    private final boolean externalAccountRequired;

    private AcmeMetadata(Builder builder) {
        this.termsOfServiceUrl = builder.termsOfServiceUrl;
        this.websiteUrl = builder.websiteUrl;
        this.caaIdentities = builder.caaIdentities;
        this.externalAccountRequired = builder.externalAccountRequired;
    }

    public String getTermsOfServiceUrl() {
        return this.termsOfServiceUrl;
    }

    public String getWebsiteUrl() {
        return this.websiteUrl;
    }

    public String[] getCAAIdentities() {
        return this.caaIdentities;
    }

    public boolean isExternalAccountRequired() {
        return this.externalAccountRequired;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String termsOfServiceUrl;
        private String websiteUrl;
        private String[] caaIdentities;
        private boolean externalAccountRequired;

        Builder() {
        }

        public Builder setTermsOfServiceUrl(String termsOfServiceUrl) {
            Assert.checkNotNullParam("termsOfServiceUrl", termsOfServiceUrl);
            this.termsOfServiceUrl = termsOfServiceUrl;
            return this;
        }

        public Builder setWebsiteUrl(String websiteUrl) {
            Assert.checkNotNullParam("websiteUrl", websiteUrl);
            this.websiteUrl = websiteUrl;
            return this;
        }

        public Builder setCaaIdentities(String[] caaIdentities) {
            Assert.checkNotNullParam("caaIdentities", caaIdentities);
            this.caaIdentities = caaIdentities;
            return this;
        }

        public Builder setExternalAccountRequired(boolean externalAccountRequired) {
            this.externalAccountRequired = externalAccountRequired;
            return this;
        }

        public AcmeMetadata build() throws IllegalArgumentException {
            return new AcmeMetadata(this);
        }
    }
}

