/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.client.impl;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.ModelControllerClientConfiguration;
import org.jboss.as.controller.client.impl.AbstractModelControllerClient;
import org.jboss.as.controller.client.impl.ProtocolConfigurationFactory;
import org.jboss.as.controller.client.logging.ControllerClientLogger;
import org.jboss.as.protocol.ProtocolConnectionConfiguration;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.protocol.mgmt.ManagementChannelAssociation;
import org.jboss.as.protocol.mgmt.ManagementChannelHandler;
import org.jboss.as.protocol.mgmt.ManagementClientChannelStrategy;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.CloseHandler;
import org.jboss.remoting3.Endpoint;

public class RemotingModelControllerClient
extends AbstractModelControllerClient {
    private Endpoint endpoint;
    private ManagementClientChannelStrategy strategy;
    private boolean closed;
    private final ManagementChannelHandler channelAssociation;
    private final ModelControllerClientConfiguration clientConfiguration;
    private final StackTraceElement[] allocationStackTrace;

    public RemotingModelControllerClient(ModelControllerClientConfiguration configuration) {
        this.channelAssociation = new ManagementChannelHandler(new ManagementClientChannelStrategy(){

            @Override
            public Channel getChannel() throws IOException {
                return RemotingModelControllerClient.this.getOrCreateChannel();
            }

            @Override
            public synchronized void close() throws IOException {
            }
        }, configuration.getExecutor(), this);
        this.clientConfiguration = configuration;
        this.allocationStackTrace = Thread.currentThread().getStackTrace();
    }

    @Override
    protected ManagementChannelAssociation getChannelAssociation() throws IOException {
        return this.channelAssociation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        RemotingModelControllerClient remotingModelControllerClient = this;
        synchronized (remotingModelControllerClient) {
            Endpoint endpoint;
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.channelAssociation.shutdown();
            if (this.strategy != null) {
                StreamUtils.safeClose(this.strategy);
                this.strategy = null;
            }
            if ((endpoint = this.endpoint) != null) {
                this.endpoint = null;
                try {
                    endpoint.closeAsync();
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
            }
            this.channelAssociation.shutdownNow();
            try {
                this.channelAssociation.awaitCompletion(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ignore) {
                Thread.currentThread().interrupt();
            }
            finally {
                StreamUtils.safeClose(this.clientConfiguration);
            }
            if (endpoint != null) {
                try {
                    endpoint.awaitClosed();
                }
                catch (InterruptedException e) {
                    InterruptedIOException cause = new InterruptedIOException(e.getLocalizedMessage());
                    cause.initCause(e);
                    throw cause;
                }
            }
        }
    }

    protected synchronized Channel getOrCreateChannel() throws IOException {
        if (this.closed) {
            throw ControllerClientLogger.ROOT_LOGGER.objectIsClosed(ModelControllerClient.class.getSimpleName());
        }
        if (this.strategy == null) {
            try {
                this.endpoint = Endpoint.builder().setEndpointName("management-client").build();
                ProtocolConnectionConfiguration configuration = ProtocolConfigurationFactory.create(this.clientConfiguration, this.endpoint);
                this.strategy = ManagementClientChannelStrategy.create(configuration, this.channelAssociation, this.clientConfiguration.getCallbackHandler(), this.clientConfiguration.getSaslOptions(), this.clientConfiguration.getSSLContext(), new CloseHandler<Channel>(){

                    @Override
                    public void handleClose(Channel closed, IOException exception) {
                        RemotingModelControllerClient.this.channelAssociation.handleChannelClosed(closed, exception);
                    }
                });
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.strategy.getChannel();
    }

    protected void finalize() throws Throwable {
        try {
            if (!this.closed) {
                ControllerClientLogger.LeakDescription t = ControllerClientLogger.ROOT_LOGGER.controllerClientNotClosed();
                t.setStackTrace(this.allocationStackTrace);
                ControllerClientLogger.ROOT_LOGGER.leakedControllerClient(t);
                StreamUtils.safeClose(this);
            }
        }
        finally {
            super.finalize();
        }
    }
}

