/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.auth;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.PhysicalAddress;
import org.jgroups.annotations.Property;
import org.jgroups.auth.AuthToken;
import org.jgroups.util.NameCache;

public class RegexMembership
extends AuthToken {
    @Property(description="The regular expression against which the IP address or logical host of a joiner will be matched")
    protected String match_string = null;
    @Property(description="Matches the IP address of the joiner against the match string")
    protected boolean match_ip_address = true;
    @Property(description="Matches the logical name of the joiner against the match string")
    protected boolean match_logical_name = false;
    protected Pattern pattern;

    @Override
    public String getName() {
        return "org.jgroups.auth.RegexMembership";
    }

    @Override
    public void init() throws Exception {
        super.init();
        if (!this.match_ip_address && !this.match_logical_name) {
            throw new IllegalArgumentException("either match_ip_address or match_logical_address has to be true");
        }
        if (this.match_string == null) {
            throw new IllegalArgumentException("match_string cannot be null");
        }
        this.pattern = Pattern.compile(this.match_string);
    }

    @Override
    public boolean authenticate(AuthToken token, Message msg) {
        Address sender = msg.getSrc();
        if (this.match_ip_address) {
            String ip_addr;
            Object src = sender != null ? (PhysicalAddress)this.auth.down(new Event(87, sender)) : null;
            String string = ip_addr = src != null ? src.toString() : null;
            if (ip_addr != null) {
                Matcher matcher = this.pattern.matcher(ip_addr);
                boolean result = matcher.matches();
                if (this.log.isTraceEnabled()) {
                    this.log.trace("matching ip_address: pattern= " + this.pattern + ", input= " + ip_addr + ", result= " + result);
                }
                if (result) {
                    return true;
                }
            }
        }
        if (this.match_logical_name) {
            String logical_name;
            String string = logical_name = sender != null ? NameCache.get(sender) : null;
            if (logical_name != null) {
                Matcher matcher = this.pattern.matcher(logical_name);
                boolean result = matcher.matches();
                if (this.log.isTraceEnabled()) {
                    this.log.trace("matching logical_name: pattern= " + this.pattern + ", input= " + logical_name + ", result= " + result);
                }
                if (result) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void writeTo(DataOutput out) {
    }

    @Override
    public void readFrom(DataInput in) {
    }

    @Override
    public int size() {
        return 0;
    }
}

