/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.encryption;

import java.security.GeneralSecurityException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.ValidIdRange;
import org.jboss.logging.annotations.ValidIdRanges;

@MessageLogger(projectCode="ELY", length=5)
@ValidIdRanges(value={@ValidIdRange(min=19000, max=19999)})
public interface ElytronMessages
extends BasicLogger {
    public static final ElytronMessages log = Logger.getMessageLogger(ElytronMessages.class, "org.wildfly.security");

    @Message(id=19000, value="Invalid size value. Must be one of 128, 192, or 256")
    public GeneralSecurityException badKeySize();

    @Message(id=19001, value="Invalid prefix importing SecretKey")
    public GeneralSecurityException badKeyPrefix();

    @Message(id=19002, value="Unsupported version '%d' the maximum supported version is '%d'")
    public GeneralSecurityException unsupportedVersion(int var1, int var2);

    @Message(id=19003, value="Unexpected token type '%s', expected '%s'")
    public GeneralSecurityException unexpectedTokenType(String var1, String var2);
}

