/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.command.man.parser;

import java.util.ArrayList;
import java.util.List;
import org.aesh.command.man.parser.ManParameter;
import org.aesh.terminal.utils.ANSI;
import org.aesh.terminal.utils.Config;

public class ManSection {
    private String name;
    private final List<ManParameter> parameters = new ArrayList<ManParameter>();

    public ManSection parseSection(List<String> input, int columns) {
        if (input.get(0).startsWith("[[")) {
            input.remove(0);
        }
        this.name = input.get(0);
        input.remove(0);
        if (input.get(0).startsWith("-") && input.get(0).trim().length() == this.name.length()) {
            input.remove(0);
            ArrayList<String> newOption = new ArrayList<String>();
            boolean startingNewOption = false;
            boolean paramName = false;
            for (String in : input) {
                if (in.trim().length() > 0) {
                    newOption.add(in);
                    continue;
                }
                if (newOption.size() <= 0) continue;
                this.parameters.add(new ManParameter().parseParams(newOption, columns));
                newOption.clear();
            }
            if (!newOption.isEmpty()) {
                this.parameters.add(new ManParameter().parseParams(newOption, columns));
            }
        }
        return this;
    }

    public String getName() {
        return this.name;
    }

    public List<ManParameter> getParameters() {
        return this.parameters;
    }

    public List<String> getAsList() {
        ArrayList<String> out = new ArrayList<String>();
        out.add(ANSI.BOLD + this.name + "\u001b[0;39m");
        for (ManParameter param : this.parameters) {
            out.addAll(param.getAsList());
        }
        out.add(" ");
        return out;
    }

    public String printToTerminal() {
        StringBuilder builder = new StringBuilder();
        builder.append(ANSI.BOLD).append(this.name).append("\u001b[0;39m");
        builder.append(Config.getLineSeparator());
        for (ManParameter param : this.parameters) {
            builder.append(param.printToTerminal());
        }
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ManSection)) {
            return false;
        }
        ManSection that = (ManSection)o;
        return this.name.equals(that.name) && this.parameters.equals(that.parameters);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.parameters.hashCode();
        return result;
    }
}

