/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.key;

import java.math.BigInteger;
import java.security.Key;
import java.security.interfaces.RSAPrivateCrtKey;
import java.util.Objects;
import org.wildfly.security.key.RawRSAPrivateKey;

class RawRSAPrivateCrtKey
extends RawRSAPrivateKey
implements RSAPrivateCrtKey {
    private static final long serialVersionUID = -4564257533496478680L;
    private final BigInteger publicExponent;
    private final BigInteger primeP;
    private final BigInteger primeQ;
    private final BigInteger primeExponentP;
    private final BigInteger primeExponentQ;
    private final BigInteger crtCoefficient;

    RawRSAPrivateCrtKey(RSAPrivateCrtKey original) {
        super(original);
        this.publicExponent = original.getPublicExponent();
        this.primeP = original.getPrimeP();
        this.primeQ = original.getPrimeQ();
        this.primeExponentP = original.getPrimeExponentP();
        this.primeExponentQ = original.getPrimeExponentQ();
        this.crtCoefficient = original.getCrtCoefficient();
    }

    RawRSAPrivateCrtKey(Key original) {
        this((RSAPrivateCrtKey)original);
    }

    @Override
    public BigInteger getPublicExponent() {
        return this.publicExponent;
    }

    @Override
    public BigInteger getPrimeP() {
        return this.primeP;
    }

    @Override
    public BigInteger getPrimeQ() {
        return this.primeQ;
    }

    @Override
    public BigInteger getPrimeExponentP() {
        return this.primeExponentP;
    }

    @Override
    public BigInteger getPrimeExponentQ() {
        return this.primeExponentQ;
    }

    @Override
    public BigInteger getCrtCoefficient() {
        return this.crtCoefficient;
    }

    @Override
    boolean isEqual(Key key) {
        return key instanceof RSAPrivateCrtKey && this.isEqual((RSAPrivateCrtKey)key);
    }

    boolean isEqual(RSAPrivateCrtKey key) {
        return super.isEqual(key) && Objects.equals(this.publicExponent, key.getPublicExponent()) && Objects.equals(this.primeP, key.getPrimeP()) && Objects.equals(this.primeQ, key.getPrimeQ()) && Objects.equals(this.primeExponentP, key.getPrimeExponentP()) && Objects.equals(this.primeExponentQ, key.getPrimeExponentQ()) && Objects.equals(this.crtCoefficient, key.getCrtCoefficient());
    }
}

