/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.net.URI;
import org.wildfly.common.math.HashMath;
import org.wildfly.common.net.CidrAddress;
import org.wildfly.common.net.Inet;
import org.wildfly.security.auth.client.MatchHostRule;
import org.wildfly.security.auth.client.MatchRule;

class MatchNetworkRule
extends MatchRule {
    private final CidrAddress cidrAddress;

    MatchNetworkRule(MatchRule parent, CidrAddress cidrAddress) {
        super(parent.without(MatchHostRule.class));
        this.cidrAddress = cidrAddress;
    }

    @Override
    public boolean matches(URI uri, String abstractType, String abstractTypeAuthority) {
        String host = uri.getHost();
        if (host == null) {
            return false;
        }
        byte[] hostBytes = host.startsWith("[") && host.endsWith("]") ? Inet.parseInet6AddressToBytes(host) : Inet.parseInet4AddressToBytes(host);
        return hostBytes != null && this.cidrAddress.matches(hostBytes) && super.matches(uri, abstractType, abstractTypeAuthority);
    }

    @Override
    MatchRule reparent(MatchRule newParent) {
        return new MatchNetworkRule(newParent, this.cidrAddress);
    }

    @Override
    public boolean isNetworkMatched() {
        return true;
    }

    @Override
    public CidrAddress getMatchNetwork() {
        return this.cidrAddress;
    }

    @Override
    public int hashCode() {
        return HashMath.multiHashUnordered(this.parentHashCode(), 5953, this.cidrAddress.hashCode());
    }

    @Override
    boolean halfEqual(MatchRule other) {
        return this.cidrAddress.equals(other.getMatchNetwork()) && this.parentHalfEqual(other);
    }

    @Override
    StringBuilder asString(StringBuilder b) {
        return this.parentAsString(b).append("network=").append(this.cidrAddress).append(',');
    }
}

