/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.Objects;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Collectors;
import org.jgroups.Message;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.stack.Protocol;
import org.jgroups.util.BoundedList;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Util;

@MBean(description="Measures incoming and outgoing message rates")
public class RATE
extends Protocol {
    @Property(description="Computes the size of a message as the payload size (false) or the serialized size (true)")
    protected boolean measure_serialized_size;
    @Property(description="Interval (ms) at which to measure the accumulated traffic")
    protected long interval = 1000L;
    @Property(description="Last N measurements to keep in history")
    protected int history_size = 60;
    protected volatile long current_send_rate;
    protected volatile long highest_send_rate;
    protected volatile long current_receive_rate;
    protected volatile long highest_receive_rate;
    protected final LongAdder out = new LongAdder();
    protected final LongAdder in = new LongAdder();
    protected BoundedList<Long> send_history;
    protected BoundedList<Long> recv_history;
    protected TimeScheduler timer;
    protected Future<?> f;
    protected final Runnable task = () -> {
        this.current_send_rate = this.out.sumThenReset();
        if (this.current_send_rate > 0L) {
            if (this.current_send_rate > this.highest_send_rate) {
                this.highest_send_rate = this.current_send_rate;
            }
            this.send_history.add(this.current_send_rate);
        }
        this.current_receive_rate = this.in.sumThenReset();
        if (this.current_receive_rate > 0L) {
            if (this.current_receive_rate > this.highest_receive_rate) {
                this.highest_receive_rate = this.current_receive_rate;
            }
            this.recv_history.add(this.current_receive_rate);
        }
    };

    public boolean measureSerializedSize() {
        return this.measure_serialized_size;
    }

    public RATE measureSerializedSize(boolean b) {
        this.measure_serialized_size = b;
        return this;
    }

    public long interval() {
        return this.interval;
    }

    public RATE interval(long i) {
        this.interval = i;
        return this;
    }

    @ManagedAttribute(description="Current send rate")
    public String currentSendRate() {
        return Util.printBytes(this.current_send_rate);
    }

    @ManagedAttribute(description="Highest send rate")
    public String highestSendRate() {
        return Util.printBytes(this.highest_send_rate);
    }

    @ManagedAttribute(description="Current receive rate")
    public String currentReceiveRate() {
        return Util.printBytes(this.current_receive_rate);
    }

    @ManagedAttribute(description="Highest receive rate")
    public String highestReceiveRate() {
        return Util.printBytes(this.highest_receive_rate);
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.send_history = new BoundedList(this.history_size);
        this.recv_history = new BoundedList(this.history_size);
        this.timer = Objects.requireNonNull(this.getTransport().getTimer());
    }

    @Override
    public void start() throws Exception {
        super.start();
        this.f = this.timer.scheduleWithFixedDelay(this.task, 1000L, this.interval, TimeUnit.MILLISECONDS, false);
    }

    @Override
    public void stop() {
        super.stop();
        this.f.cancel(false);
    }

    @Override
    public Object down(Message msg) {
        long size = this.size(msg);
        this.out.add(size);
        return this.down_prot.down(msg);
    }

    @Override
    public Object up(Message msg) {
        long size = this.size(msg);
        this.in.add(size);
        return this.up_prot.up(msg);
    }

    @Override
    public void up(MessageBatch batch) {
        long size = this.size(batch);
        this.in.add(size);
        this.up_prot.up(batch);
    }

    @Override
    public void resetStats() {
        this.highest_receive_rate = 0L;
        this.highest_send_rate = 0L;
    }

    @ManagedOperation(description="Prints the send history (skipping 0 values)")
    public String printSendHistory() {
        return this.send_history.stream().map(Util::printBytes).collect(Collectors.joining(","));
    }

    @ManagedOperation(description="Prints the receive history (skipping 0 values)")
    public String printReceiveHistory() {
        return this.recv_history.stream().map(Util::printBytes).collect(Collectors.joining(","));
    }

    protected long size(Message msg) {
        return this.measure_serialized_size ? (long)msg.serializedSize() : (long)msg.getLength();
    }

    protected long size(MessageBatch batch) {
        return this.measure_serialized_size ? batch.totalSize() : (long)batch.length();
    }
}

