/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.credential;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Objects;
import java.util.function.Supplier;
import org.wildfly.common.Assert;
import org.wildfly.security.credential.AlgorithmCredential;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.PasswordGuessEvidence;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.provider.util.ProviderUtil;

public final class PasswordCredential
implements AlgorithmCredential {
    private final Password password;

    public PasswordCredential(Password password) {
        Assert.checkNotNullParam("password", password);
        this.password = password;
    }

    public Password getPassword() {
        return this.password;
    }

    public <P extends Password> P getPassword(Class<P> type) {
        return this.getPassword().castAs(type);
    }

    @Override
    public String getAlgorithm() {
        return this.password.getAlgorithm();
    }

    @Override
    public boolean supportsParameters(Class<? extends AlgorithmParameterSpec> paramSpecClass) {
        return paramSpecClass.isInstance(this.password.getParameterSpec());
    }

    @Override
    public <P extends AlgorithmParameterSpec> P getParameters(Class<P> paramSpecClass) {
        AlgorithmParameterSpec parameterSpec = this.password.getParameterSpec();
        return (P)(paramSpecClass.isInstance(parameterSpec) ? (AlgorithmParameterSpec)paramSpecClass.cast(parameterSpec) : null);
    }

    @Override
    public boolean impliesParameters(AlgorithmParameterSpec parameterSpec) {
        Assert.checkNotNullParam("parameterSpec", parameterSpec);
        return this.password.impliesParameters(parameterSpec);
    }

    @Override
    public boolean impliesSameParameters(AlgorithmCredential other) {
        Assert.checkNotNullParam("other", other);
        return Objects.equals(this.password.getParameterSpec(), other.getParameters());
    }

    @Override
    public boolean canVerify(Class<? extends Evidence> evidenceClass, String algorithmName) {
        return PasswordCredential.canVerifyEvidence(evidenceClass, algorithmName);
    }

    public static boolean canVerifyEvidence(Class<? extends Evidence> evidenceClass, String algorithmName) {
        Assert.checkNotNullParam("evidenceClass", evidenceClass);
        return evidenceClass == PasswordGuessEvidence.class && algorithmName == null;
    }

    @Override
    public boolean verify(Supplier<Provider[]> providerSupplier, Evidence evidence) {
        return this.verify(providerSupplier, evidence, StandardCharsets.UTF_8);
    }

    public boolean verify(Supplier<Provider[]> providerSupplier, Evidence evidence, Charset hashCharset) {
        Assert.checkNotNullParam("providerSupplier", providerSupplier);
        Assert.checkNotNullParam("evidence", evidence);
        Assert.checkNotNullParam("hashCharset", hashCharset);
        if (evidence instanceof PasswordGuessEvidence) {
            try {
                PasswordFactory factory = PasswordFactory.getInstance(this.password.getAlgorithm(), providerSupplier);
                return factory.verify(factory.translate(this.password), ((PasswordGuessEvidence)evidence).getGuess(), hashCharset);
            }
            catch (InvalidKeyException | NoSuchAlgorithmException generalSecurityException) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean verify(Evidence evidence, Charset hashCharset) {
        return this.verify(ProviderUtil.INSTALLED_PROVIDERS, evidence, hashCharset);
    }

    @Override
    public PasswordCredential clone() {
        Password password = this.password;
        Password clone = password.clone();
        return clone == password ? this : new PasswordCredential(clone);
    }

    public int hashCode() {
        return this.password.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof PasswordCredential && this.password.equals(((PasswordCredential)obj).password);
    }
}

