/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.extensions.mkdir;

import java.util.List;
import org.aesh.command.Command;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandResult;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.option.Arguments;
import org.aesh.command.option.Option;
import org.aesh.command.shell.Shell;
import org.aesh.io.Resource;
import org.aesh.terminal.utils.Config;

@CommandDefinition(name="mkdir", description="create directory(ies), if they do not already exist.")
public class Mkdir
implements Command<CommandInvocation> {
    @Option(shortName=104, name="help", hasValue=false, description="display this help and exit")
    private boolean help;
    @Option(shortName=112, name="parents", hasValue=false, description="make parent directories as needed")
    private boolean parents;
    @Option(shortName=118, name="verbose", hasValue=false, description="print a message for each created directory")
    private boolean verbose;
    @Arguments(description="directory(ies) to create")
    private List<Resource> arguments;

    @Override
    public CommandResult execute(CommandInvocation commandInvocation) {
        if (this.help || this.arguments == null || this.arguments.isEmpty()) {
            commandInvocation.getShell().writeln(commandInvocation.getHelpInfo("mkdir"));
            return CommandResult.SUCCESS;
        }
        for (Resource f : this.arguments) {
            Resource currentWorkingDirectory = commandInvocation.getConfiguration().getAeshContext().getCurrentWorkingDirectory();
            Shell shell = commandInvocation.getShell();
            Resource pathResolved = f.resolve(currentWorkingDirectory).get(0);
            if (this.parents || f.getName().contains(Config.getPathSeparator())) {
                this.makeDirs(this.arguments, pathResolved, shell);
                continue;
            }
            this.makeDir(pathResolved, shell);
        }
        return CommandResult.SUCCESS;
    }

    private void makeDir(Resource dir, Shell shell) {
        if (!dir.exists()) {
            dir.mkdirs();
            if (this.verbose) {
                shell.writeln("created directory '" + dir.getName() + "'");
            }
        } else {
            shell.writeln("cannot create directory '" + dir.getName() + "': Directory exists");
        }
    }

    private void makeDirs(List<Resource> resources, Resource dir, Shell shell) {
        if (!dir.exists()) {
            dir.mkdirs();
            if (this.verbose) {
                for (Resource r : resources) {
                    shell.writeln("created directory '" + r.getName() + "'");
                }
            }
        }
    }
}

