/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling;

import java.io.IOException;
import java.io.InvalidClassException;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;

public final class ModularClassResolver
implements ClassResolver {
    private final ModuleLoader moduleLoader;
    private static final ClassLoader MODULE_CLASS_LOADER = System.getSecurityManager() == null ? Module.class.getClassLoader() : AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

        @Override
        public ClassLoader run() {
            return Module.class.getClassLoader();
        }
    });

    private ModularClassResolver(ModuleLoader moduleLoader) {
        this.moduleLoader = moduleLoader;
    }

    public static ModularClassResolver getInstance(ModuleLoader moduleLoader) {
        return new ModularClassResolver(moduleLoader);
    }

    @Override
    public void annotateClass(Marshaller marshaller, Class<?> clazz) throws IOException {
        Module module = Module.forClass(clazz);
        if (module == null) {
            marshaller.writeObject(null);
        } else {
            ModuleIdentifier identifier = module.getIdentifier();
            marshaller.writeObject(identifier.getName());
            marshaller.writeObject(identifier.getSlot());
        }
    }

    @Override
    public void annotateProxyClass(Marshaller marshaller, Class<?> proxyClass) throws IOException {
        Module module = Module.forClass(proxyClass);
        if (module == null) {
            marshaller.writeObject(null);
        } else {
            ModuleIdentifier identifier = module.getIdentifier();
            marshaller.writeObject(identifier.getName());
            marshaller.writeObject(identifier.getSlot());
        }
    }

    @Override
    public String getClassName(Class<?> clazz) throws IOException {
        return clazz.getName();
    }

    @Override
    public String[] getProxyInterfaces(Class<?> proxyClass) throws IOException {
        Class<?>[] interfaces = proxyClass.getInterfaces();
        String[] names = new String[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            names[i] = this.getClassName(interfaces[i]);
        }
        return names;
    }

    @Override
    public Class<?> resolveClass(Unmarshaller unmarshaller, String className, long serialVersionUID) throws IOException, ClassNotFoundException {
        String name = (String)unmarshaller.readObject();
        if (name == null) {
            return Class.forName(className, false, MODULE_CLASS_LOADER);
        }
        String slot = (String)unmarshaller.readObject();
        ModuleIdentifier identifier = ModuleIdentifier.create(name, slot);
        try {
            final Module module = this.moduleLoader.loadModule(identifier);
            ClassLoader classLoader = System.getSecurityManager() == null ? module.getClassLoader() : AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return module.getClassLoader();
                }
            });
            return Class.forName(className, false, classLoader);
        }
        catch (ModuleLoadException e) {
            InvalidClassException ce = new InvalidClassException(className, "Module load failed");
            ce.initCause(e);
            throw ce;
        }
    }

    @Override
    public Class<?> resolveProxyClass(Unmarshaller unmarshaller, String[] names) throws IOException, ClassNotFoundException {
        ClassLoader classLoader;
        String name = (String)unmarshaller.readObject();
        if (name == null) {
            classLoader = MODULE_CLASS_LOADER;
        } else {
            Module module;
            String slot = (String)unmarshaller.readObject();
            ModuleIdentifier identifier = ModuleIdentifier.create(name, slot);
            try {
                module = this.moduleLoader.loadModule(identifier);
            }
            catch (ModuleLoadException e) {
                InvalidClassException ce = new InvalidClassException("Module load failed");
                ce.initCause(e);
                throw ce;
            }
            classLoader = module.getClassLoader();
        }
        int len = names.length;
        Class[] interfaces = new Class[len];
        for (int i = 0; i < len; ++i) {
            interfaces[i] = Class.forName(names[i], false, classLoader);
        }
        return Proxy.getProxyClass(classLoader, interfaces);
    }
}

