/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.launcher.logger;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.security.AccessController;
import java.util.Locale;
import org.wildfly.core.launcher.logger.LoggingLocale;

class Messages {
    private Messages() {
    }

    public static <T> T getBundle(Class<T> type) {
        if (System.getSecurityManager() == null) {
            try {
                MethodHandles.Lookup lookup = MethodHandles.privateLookupIn(type, MethodHandles.lookup());
                return Messages.doGetBundle(lookup, type);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("This library does not have private access to " + type);
            }
        }
        return (T)AccessController.doPrivileged(() -> {
            try {
                MethodHandles.Lookup lookup = MethodHandles.privateLookupIn(type, MethodHandles.lookup());
                return Messages.doGetBundle(lookup, type);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("This library does not have private access to " + type);
            }
        });
    }

    private static String join(String interfaceName, String lang, String country, String variant) {
        StringBuilder build = new StringBuilder();
        build.append(interfaceName).append('_').append("$bundle");
        if (lang != null && !lang.isEmpty()) {
            build.append('_');
            build.append(lang);
        }
        if (country != null && !country.isEmpty()) {
            build.append('_');
            build.append(country);
        }
        if (variant != null && !variant.isEmpty()) {
            build.append('_');
            build.append(variant);
        }
        return build.toString();
    }

    private static <T> T doGetBundle(MethodHandles.Lookup lookup, Class<T> type) {
        MethodHandle getter;
        Locale locale = LoggingLocale.getLocale();
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        Class<T> bundleClass = null;
        if (!variant.isEmpty()) {
            try {
                bundleClass = lookup.findClass(Messages.join(type.getName(), language, country, variant)).asSubclass(type);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("The given lookup does not have access to the implementation class");
            }
        }
        if (bundleClass == null && !country.isEmpty()) {
            try {
                bundleClass = lookup.findClass(Messages.join(type.getName(), language, country, null)).asSubclass(type);
            }
            catch (ClassNotFoundException e) {
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("The given lookup does not have access to the implementation class");
            }
        }
        if (bundleClass == null && !language.isEmpty()) {
            try {
                bundleClass = lookup.findClass(Messages.join(type.getName(), language, null, null)).asSubclass(type);
            }
            catch (ClassNotFoundException e) {
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("The given lookup does not have access to the implementation class");
            }
        }
        if (bundleClass == null) {
            try {
                bundleClass = lookup.findClass(Messages.join(type.getName(), null, null, null)).asSubclass(type);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Invalid bundle " + type + " (implementation not found)");
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("The given lookup does not have access to the implementation class");
            }
        }
        try {
            getter = lookup.findStaticGetter(bundleClass, "INSTANCE", bundleClass);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException("Bundle implementation " + bundleClass + " has no instance field");
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("The given lookup does not have access to the implementation class instance field");
        }
        try {
            return type.cast(getter.invoke());
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Bundle implementation " + bundleClass + " could not be instantiated", e);
        }
    }
}

