/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.Closeable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.IntBinaryOperator;
import java.util.function.Predicate;
import org.jgroups.Address;
import org.jgroups.EmptyMessage;
import org.jgroups.Message;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.conf.AttributeType;
import org.jgroups.protocols.NakAckHeader;
import org.jgroups.protocols.ReliableMulticast;
import org.jgroups.util.AckTable;
import org.jgroups.util.AverageMinMax;
import org.jgroups.util.Buffer;
import org.jgroups.util.Digest;
import org.jgroups.util.FixedBuffer;
import org.jgroups.util.Util;

public class NAKACK4
extends ReliableMulticast {
    protected final AckTable ack_table = new AckTable();
    @Property(description="Size of the send/receive buffers, in messages", writable=false)
    protected int capacity = 2048;
    @Property(description="Number of ACKs to skip before one is sent. For example, a value of 500 means that only every 500th ACk is sent; all others are dropped. If not set, defaulted to capacity/4", type=AttributeType.SCALAR)
    protected int ack_threshold;
    @ManagedAttribute(description="Number of ACKs received", type=AttributeType.SCALAR)
    protected final LongAdder acks_received = new LongAdder();
    protected final IntBinaryOperator add_acks = (current_acks_sent, acks_to_be_sent) -> {
        if (current_acks_sent + acks_to_be_sent >= this.ack_threshold) {
            return 0;
        }
        return current_acks_sent + acks_to_be_sent;
    };

    public int capacity() {
        return this.capacity;
    }

    public NAKACK4 capacity(int c) {
        this.capacity = c;
        return this;
    }

    public int ackThreshold() {
        return this.ack_threshold;
    }

    public NAKACK4 ackThreshold(int t) {
        this.ack_threshold = t;
        return this;
    }

    @ManagedAttribute(type=AttributeType.SCALAR)
    public long getNumUnackedMessages() {
        long minAck = this.ack_table.min();
        return minAck > 0L ? this.seqno.get() - minAck : 0L;
    }

    public long getNumUnackedMessages(Address dest) {
        long minAck = this.ack_table.min(dest);
        return minAck > 0L ? this.seqno.get() - minAck : 0L;
    }

    @ManagedAttribute(description="Number of times sender threads were blocked on a full send window", type=AttributeType.SCALAR)
    public long getNumBlockings() {
        FixedBuffer buf = (FixedBuffer)this.sendBuf();
        return buf != null ? buf.numBlockings() : -1L;
    }

    @ManagedAttribute(description="The number of received messages dropped due to full capacity of the buffer")
    public long getNumDroppedMessages() {
        long retval = 0L;
        for (ReliableMulticast.Entry e : this.xmit_table.values()) {
            if (!(e.buf() instanceof FixedBuffer)) continue;
            retval += ((FixedBuffer)e.buf()).numDroppedMessages();
        }
        return retval;
    }

    @ManagedAttribute(description="Average time blocked")
    public AverageMinMax getAvgTimeBlocked() {
        FixedBuffer buf = (FixedBuffer)this.sendBuf();
        return buf != null ? buf.avgTimeBlocked() : null;
    }

    @Override
    protected Buffer<Message> createXmitWindow(long initial_seqno) {
        return new FixedBuffer<Message>(this.capacity, initial_seqno);
    }

    @Override
    public boolean sendBufferCanBlock() {
        return true;
    }

    @Override
    public void resetStats() {
        super.resetStats();
        this.acks_received.reset();
        Buffer<Message> buf = this.sendBuf();
        if (buf != null) {
            buf.resetStats();
        }
    }

    @Override
    public void init() throws Exception {
        super.init();
        if (this.ack_threshold <= 0) {
            this.ack_threshold = this.capacity / 4;
            this.log.debug("defaulted ack_threshold to %d", this.ack_threshold);
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        this.ack_table.clear();
    }

    @ManagedOperation(description="Prints the ACKs received from members")
    public String printAckTable() {
        return "\n" + this.ack_table;
    }

    @ManagedOperation(description="Sends ACKs immediately for all receive buffers")
    public void sendAcks() {
        this.sendAcks(true);
    }

    @ManagedOperation(description="Sends ACKs immediately for all receive buffers")
    public void sendPendingAcks() {
        this.sendAcks(false);
    }

    protected void sendAcks(boolean always_send) {
        for (Map.Entry entry : this.xmit_table.entrySet()) {
            Address target = (Address)entry.getKey();
            ReliableMulticast.Entry val = (ReliableMulticast.Entry)entry.getValue();
            Buffer<Message> win = val != null ? val.buf() : null;
            if (win == null || !always_send && !this.needToSendAck(val)) continue;
            this.sendAck(target, win);
        }
    }

    @ManagedOperation
    public void changeCapacity(int new_capacity) {
        if (new_capacity == this.capacity) {
            return;
        }
        this.xmit_table.values().stream().map(ReliableMulticast.Entry::buf).forEach(buf -> ((FixedBuffer)buf).changeCapacity(new_capacity));
        this.capacity = new_capacity;
    }

    @Override
    protected void adjustReceivers(List<Address> members) {
        super.adjustReceivers(members);
        long old_min = this.ack_table.min();
        this.ack_table.adjust(members);
        long new_min = this.ack_table.min();
        if (new_min > old_min) {
            Buffer<Message> buf = this.sendBuf();
            if (buf == null) {
                this.log.warn("%s: local send buffer is null", this.local_addr);
            } else {
                buf.purge(new_min);
            }
        }
    }

    @Override
    protected void reset() {
        FixedBuffer buf = (FixedBuffer)this.sendBuf();
        Util.close((Closeable)buf);
        super.reset();
    }

    @Override
    protected void stable(Digest digest) {
        this.log.warn("%s: ignoring stable event %s", this.local_addr, digest);
    }

    @Override
    protected void handleAck(Address sender, long ack) {
        Buffer<Message> buf = this.sendBuf();
        if (buf == null) {
            this.log.warn("%s: local send buffer is null", this.local_addr);
            return;
        }
        if (this.is_trace) {
            this.log.trace("%s <-- %s: ACK(%d)", this.local_addr, sender, ack);
        }
        this.acks_received.increment();
        long[] rc = this.ack_table.ack(sender, ack);
        long old_min = rc[0];
        long new_min = rc[1];
        if (new_min > old_min) {
            buf.purge(new_min);
        }
    }

    @Override
    protected boolean needToSendAck(ReliableMulticast.Entry e) {
        return e.needToSendAck();
    }

    @Override
    protected boolean needToSendAck(ReliableMulticast.Entry e, int num_acks) {
        return e.update(num_acks, this.add_acks);
    }

    @Override
    protected void sendAck(Address to, Buffer<Message> win) {
        long hd = win.highestDelivered();
        if (this.is_trace) {
            this.log.trace("%s --> %s: ACK(%d)", this.local_addr, to, hd);
        }
        this.down_prot.down(new EmptyMessage(to).putHeader(this.id, NakAckHeader.createAckHeader(hd)).setFlag(Message.Flag.OOB));
    }

    @Override
    protected boolean addToSendBuffer(Buffer<Message> win, long seq, Message msg, Predicate<Message> filter) {
        return win.add(seq, msg, filter);
    }
}

