package org.wildfly.security.x500.cert.acme;

import java.util.Locale;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.wildfly.security.x500.cert.acme.AcmeException;
import org.jboss.logging.BasicLogger;
import java.time.Instant;
import java.lang.String;
import org.jboss.logging.Logger;
import java.util.Arrays;
import java.lang.IllegalArgumentException;
import java.lang.Exception;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2021-02-17T15:14:23-0500")
public class ElytronMessages_$logger extends DelegatingBasicLogger implements ElytronMessages, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    public ElytronMessages_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String unableToDetermineKeySize$str() {
        return "ELY10016: Unable to determine key size";
    }
    @Override
    public final IllegalArgumentException unableToDetermineKeySize() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unableToDetermineKeySize$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String unableToDetermineDefaultCompatibleSignatureAlgorithmName$str() {
        return "ELY10019: Unable to determine default compatible signature algorithm name for key algorithm name \"%s\"";
    }
    @Override
    public final IllegalArgumentException unableToDetermineDefaultCompatibleSignatureAlgorithmName(final String keyAlgorithmName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unableToDetermineDefaultCompatibleSignatureAlgorithmName$str(), keyAlgorithmName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String acmeAccountKeyPairGenerationFailed$str() {
        return "ELY10029: Failed to generate ACME account key pair";
    }
    @Override
    public final IllegalArgumentException acmeAccountKeyPairGenerationFailed(final Exception cause) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), acmeAccountKeyPairGenerationFailed$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noAcmeServerUrlGiven$str() {
        return "ELY10030: No ACME server URL given";
    }
    @Override
    public final IllegalArgumentException noAcmeServerUrlGiven() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), noAcmeServerUrlGiven$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unsupportedAcmeAccountSignatureAlgorithm$str() {
        return "ELY10031: Unsupported ACME account signature algorithm \"%s\"";
    }
    @Override
    public final IllegalArgumentException unsupportedAcmeAccountSignatureAlgorithm(final String signatureAlgorithm) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unsupportedAcmeAccountSignatureAlgorithm$str(), signatureAlgorithm));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToCreateAcmeSignature$str() {
        return "ELY10032: Unable to create ACME signature";
    }
    @Override
    public final IllegalArgumentException unableToCreateAcmeSignature(final Exception cause) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unableToCreateAcmeSignature$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToRetrieveAcmeServerDirectoryUrls$str() {
        return "ELY10033: Unable to retrieve ACME server directory URLs";
    }
    @Override
    public final org.wildfly.security.x500.cert.acme.AcmeException unableToRetrieveAcmeServerDirectoryUrls(final Exception cause) {
        final org.wildfly.security.x500.cert.acme.AcmeException result = new org.wildfly.security.x500.cert.acme.AcmeException(String.format(getLoggingLocale(), unableToRetrieveAcmeServerDirectoryUrls$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noNonceProvidedByAcmeServer$str() {
        return "ELY10034: No nonce provided by ACME server";
    }
    @Override
    public final org.wildfly.security.x500.cert.acme.AcmeException noNonceProvidedByAcmeServer() {
        final org.wildfly.security.x500.cert.acme.AcmeException result = new org.wildfly.security.x500.cert.acme.AcmeException(String.format(getLoggingLocale(), noNonceProvidedByAcmeServer$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noLocationUrlProvidedByAcmeServer$str() {
        return "ELY10035: No %s location URL provided by ACME server";
    }
    @Override
    public final org.wildfly.security.x500.cert.acme.AcmeException noLocationUrlProvidedByAcmeServer(final String urlType) {
        final org.wildfly.security.x500.cert.acme.AcmeException result = new org.wildfly.security.x500.cert.acme.AcmeException(String.format(getLoggingLocale(), noLocationUrlProvidedByAcmeServer$str(), urlType));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToObtainNewNonceFromAcmeServer$str() {
        return "ELY10036: Unable to obtain new nonce from ACME server";
    }
    @Override
    public final org.wildfly.security.x500.cert.acme.AcmeException unableToObtainNewNonceFromAcmeServer() {
        final org.wildfly.security.x500.cert.acme.AcmeException result = new org.wildfly.security.x500.cert.acme.AcmeException(String.format(getLoggingLocale(), unableToObtainNewNonceFromAcmeServer$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToObtainJsonResponseFromAcmeServer$str() {
        return "ELY10037: Unable to obtain JSON response from ACME server";
    }
    @Override
    public final org.wildfly.security.x500.cert.acme.AcmeException unableToObtainJsonResponseFromAcmeServer(final Exception cause) {
        final org.wildfly.security.x500.cert.acme.AcmeException result = new org.wildfly.security.x500.cert.acme.AcmeException(String.format(getLoggingLocale(), unableToObtainJsonResponseFromAcmeServer$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unexpectedResponseCodeFromAcmeServer$str() {
        return "ELY10038: Unexpected HTTP status code in response from ACME server \"%d\": \"%s\"";
    }
    @Override
    public final org.wildfly.security.x500.cert.acme.AcmeException unexpectedResponseCodeFromAcmeServer(final int responseCode, final String responseMessage) {
        final org.wildfly.security.x500.cert.acme.AcmeException result = new org.wildfly.security.x500.cert.acme.AcmeException(String.format(getLoggingLocale(), unexpectedResponseCodeFromAcmeServer$str(), responseCode, responseMessage));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String badAcmeNonce$str() {
        return "ELY10039: Bad ACME replay nonce, maximum retries attempted";
    }
    @Override
    public final org.wildfly.security.x500.cert.acme.AcmeException badAcmeNonce() {
        final org.wildfly.security.x500.cert.acme.AcmeException result = new org.wildfly.security.x500.cert.acme.AcmeException(String.format(getLoggingLocale(), badAcmeNonce$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unexpectedContentTypeFromAcmeServer$str() {
        return "ELY10040: Unexpected content type in response from ACME server \"%s\"";
    }
    @Override
    public final org.wildfly.security.x500.cert.acme.AcmeException unexpectedContentTypeFromAcmeServer(final String contentType) {
        final org.wildfly.security.x500.cert.acme.AcmeException result = new org.wildfly.security.x500.cert.acme.AcmeException(String.format(getLoggingLocale(), unexpectedContentTypeFromAcmeServer$str(), contentType));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidContentTypeFromAcmeServer$str() {
        return "ELY10041: Invalid content type in response from ACME server";
    }
    @Override
    public final org.wildfly.security.x500.cert.acme.AcmeException invalidContentTypeFromAcmeServer() {
        final org.wildfly.security.x500.cert.acme.AcmeException result = new org.wildfly.security.x500.cert.acme.AcmeException(String.format(getLoggingLocale(), invalidContentTypeFromAcmeServer$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String domainNameIsNull$str() {
        return "ELY10042: Domain name is null";
    }
    @Override
    public final org.wildfly.security.x500.cert.acme.AcmeException domainNameIsNull() {
        final org.wildfly.security.x500.cert.acme.AcmeException result = new org.wildfly.security.x500.cert.acme.AcmeException(String.format(getLoggingLocale(), domainNameIsNull$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String domainNamesIsEmpty$str() {
        return "ELY10043: Domain names is empty";
    }
    @Override
    public final org.wildfly.security.x500.cert.acme.AcmeException domainNamesIsEmpty() {
        final org.wildfly.security.x500.cert.acme.AcmeException result = new org.wildfly.security.x500.cert.acme.AcmeException(String.format(getLoggingLocale(), domainNamesIsEmpty$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noCertificateUrlProvidedByAcmeServer$str() {
        return "ELY10044: No certificate URL provided by ACME server";
    }
    @Override
    public final org.wildfly.security.x500.cert.acme.AcmeException noCertificateUrlProvidedByAcmeServer() {
        final org.wildfly.security.x500.cert.acme.AcmeException result = new org.wildfly.security.x500.cert.acme.AcmeException(String.format(getLoggingLocale(), noCertificateUrlProvidedByAcmeServer$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noCertificateWillBeIssuedByAcmeServer$str() {
        return "ELY10045: No certificate will be issued by the ACME server";
    }
    @Override
    public final org.wildfly.security.x500.cert.acme.AcmeException noCertificateWillBeIssuedByAcmeServer() {
        final org.wildfly.security.x500.cert.acme.AcmeException result = new org.wildfly.security.x500.cert.acme.AcmeException(String.format(getLoggingLocale(), noCertificateWillBeIssuedByAcmeServer$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToGetEncodedFormOfCertificateToBeRevoked$str() {
        return "ELY10046: Unable to get encoded form of certificate to be revoked";
    }
    @Override
    public final org.wildfly.security.x500.cert.acme.AcmeException unableToGetEncodedFormOfCertificateToBeRevoked(final Exception cause) {
        final org.wildfly.security.x500.cert.acme.AcmeException result = new org.wildfly.security.x500.cert.acme.AcmeException(String.format(getLoggingLocale(), unableToGetEncodedFormOfCertificateToBeRevoked$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToDetermineKeyAuthorizationString$str() {
        return "ELY10047: Unable to determine key authorization string";
    }
    @Override
    public final org.wildfly.security.x500.cert.acme.AcmeException unableToDetermineKeyAuthorizationString(final Exception cause) {
        final org.wildfly.security.x500.cert.acme.AcmeException result = new org.wildfly.security.x500.cert.acme.AcmeException(String.format(getLoggingLocale(), unableToDetermineKeyAuthorizationString$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String challengeResponseFailedValidationByAcmeServer$str() {
        return "ELY10048: Challenge response failed validation by the ACME server";
    }
    @Override
    public final org.wildfly.security.x500.cert.acme.AcmeException challengeResponseFailedValidationByAcmeServer() {
        final org.wildfly.security.x500.cert.acme.AcmeException result = new org.wildfly.security.x500.cert.acme.AcmeException(String.format(getLoggingLocale(), challengeResponseFailedValidationByAcmeServer$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToDownloadCertificateChainFromAcmeServer$str() {
        return "ELY10049: Unable to download certificate chain from ACME server";
    }
    @Override
    public final org.wildfly.security.x500.cert.acme.AcmeException unableToDownloadCertificateChainFromAcmeServer(final Exception cause) {
        final org.wildfly.security.x500.cert.acme.AcmeException result = new org.wildfly.security.x500.cert.acme.AcmeException(String.format(getLoggingLocale(), unableToDownloadCertificateChainFromAcmeServer$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String acmeAccountDoesNotExist$str() {
        return "ELY10050: ACME account does not exist";
    }
    @Override
    public final org.wildfly.security.x500.cert.acme.AcmeException acmeAccountDoesNotExist() {
        final org.wildfly.security.x500.cert.acme.AcmeException result = new org.wildfly.security.x500.cert.acme.AcmeException(String.format(getLoggingLocale(), acmeAccountDoesNotExist$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String userActionRequired$str() {
        return "ELY10051: User action required since the ACME server's terms of service have changed, visit \"%s\" for details";
    }
    @Override
    public final org.wildfly.security.x500.cert.acme.AcmeException userActionRequired(final String url) {
        final org.wildfly.security.x500.cert.acme.AcmeException result = new org.wildfly.security.x500.cert.acme.AcmeException(String.format(getLoggingLocale(), userActionRequired$str(), url));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String rateLimitExceededTryAgainLater$str() {
        return "ELY10052: Rate limit has been exceeded, try again after \"%s\"";
    }
    @Override
    public final org.wildfly.security.x500.cert.acme.AcmeException rateLimitExceededTryAgainLater(final Instant instant) {
        final org.wildfly.security.x500.cert.acme.AcmeException result = new org.wildfly.security.x500.cert.acme.AcmeException(String.format(getLoggingLocale(), rateLimitExceededTryAgainLater$str(), instant));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String rateLimitExceeded$str() {
        return "ELY10053: Rate limit has been exceeded";
    }
    @Override
    public final org.wildfly.security.x500.cert.acme.AcmeException rateLimitExceeded() {
        final org.wildfly.security.x500.cert.acme.AcmeException result = new org.wildfly.security.x500.cert.acme.AcmeException(String.format(getLoggingLocale(), rateLimitExceeded$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String resourceNotSupportedByAcmeServer$str() {
        return "ELY10054: Resource not supported by the ACME server \"%s\"";
    }
    @Override
    public final org.wildfly.security.x500.cert.acme.AcmeException resourceNotSupportedByAcmeServer(final String resource) {
        final org.wildfly.security.x500.cert.acme.AcmeException result = new org.wildfly.security.x500.cert.acme.AcmeException(String.format(getLoggingLocale(), resourceNotSupportedByAcmeServer$str(), resource));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unsupportedAcmeAccountPublicKeyType$str() {
        return "ELY10055: Unsupported ACME account public key type \"%s\"";
    }
    @Override
    public final IllegalArgumentException unsupportedAcmeAccountPublicKeyType(final String keyAlgorithmName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unsupportedAcmeAccountPublicKeyType$str(), keyAlgorithmName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToDetermineCurveParameterFromAlgHeader$str() {
        return "ELY10056: Unable to determine curve parameter from alg header \"%s\"";
    }
    @Override
    public final IllegalArgumentException unableToDetermineCurveParameterFromAlgHeader(final String algHeader) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unableToDetermineCurveParameterFromAlgHeader$str(), algHeader));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noAcmeServerStagingUrlGiven$str() {
        return "ELY10057: No ACME server staging URL given";
    }
    @Override
    public final org.wildfly.security.x500.cert.acme.AcmeException noAcmeServerStagingUrlGiven() {
        final org.wildfly.security.x500.cert.acme.AcmeException result = new org.wildfly.security.x500.cert.acme.AcmeException(String.format(getLoggingLocale(), noAcmeServerStagingUrlGiven$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
