package org.wildfly.httpclient.ejb;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import java.io.InvalidClassException;
import java.io.IOException;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.InterruptedException;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.util.Arrays;
import org.jboss.ejb.client.EJBLocator;
import javax.ejb.EJBException;
import java.lang.IllegalArgumentException;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2021-12-02T04:08:15-0300")
public class EjbHttpClientMessages_$logger extends DelegatingBasicLogger implements EjbHttpClientMessages, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = EjbHttpClientMessages_$logger.class.getName();
    public EjbHttpClientMessages_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String unexpectedDataInResponse$str() {
        return "WFHTTPEJB000001: Unexpected data in response";
    }
    @Override
    public final IOException unexpectedDataInResponse() {
        final IOException result = new IOException(String.format(getLoggingLocale(), unexpectedDataInResponse$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String noSessionIdInResponse$str() {
        return "WFHTTPEJB000002: No session id in response";
    }
    @Override
    public final IOException noSessionIdInResponse() {
        final IOException result = new IOException(String.format(getLoggingLocale(), noSessionIdInResponse$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String couldNotResolveTargetForLocator$str() {
        return "WFHTTPEJB000003: Could not resolve target for locator %s";
    }
    @Override
    public final IllegalStateException couldNotResolveTargetForLocator(final EJBLocator locator) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), couldNotResolveTargetForLocator$str(), locator));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String couldNotCreateHttpEjbReceiverFor$str() {
        return "WFHTTPEJB000004: Could create HTTP EJBReceiver for protocol %s";
    }
    @Override
    public final IllegalArgumentException couldNotCreateHttpEjbReceiverFor(final String s) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), couldNotCreateHttpEjbReceiverFor$str(), s));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String notStateful$str() {
        return "WFHTTPEJB000006: EJB not stateful";
    }
    @Override
    public final IllegalArgumentException notStateful() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), notStateful$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String sessionNotActive$str() {
        return "WFHTTPEJB000007: Session was not active";
    }
    @Override
    public final IllegalArgumentException sessionNotActive() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), sessionNotActive$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noSuchMethod$str() {
        return "WFHTTPEJB000008: Session was not active";
    }
    @Override
    public final IllegalArgumentException noSuchMethod() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), noSuchMethod$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String wrongViewType$str() {
        return "WFHTTPEJB000009: Wrong view type";
    }
    @Override
    public final EJBException wrongViewType() {
        final EJBException result = new EJBException(String.format(getLoggingLocale(), wrongViewType$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotEnlistTx$str() {
        return "WFHTTPEJB000010: Cannot enlist in transaction";
    }
    @Override
    public final IllegalStateException cannotEnlistTx() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cannotEnlistTx$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidTransactionType$str() {
        return "WFHTTPEJB000011: Invalid transaction type %s";
    }
    @Override
    public final IOException invalidTransactionType(final int type) {
        final IOException result = new IOException(String.format(getLoggingLocale(), invalidTransactionType$str(), type));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void unableToPerformEjbDiscovery(final Throwable e) {
        super.log.logf(FQCN, ERROR, e, unableToPerformEjbDiscovery$str());
    }
    protected String unableToPerformEjbDiscovery$str() {
        return "WFHTTPEJB000012: Unable to perform EJB discovery";
    }
    @Override
    public final void httpDiscoveryInterrupted(final InterruptedException e) {
        super.log.logf(FQCN, INFO, e, httpDiscoveryInterrupted$str());
    }
    protected String httpDiscoveryInterrupted$str() {
        return "WFHTTPEJB000013: HTTP discovery has been interrupted";
    }
    protected String cannotResolveFilteredClass$str() {
        return "WFHTTPEJB000014: Exception resolving class %s for unmarshalling; it has either been blacklisted or not whitelisted";
    }
    @Override
    public final InvalidClassException cannotResolveFilteredClass(final String clazz) {
        final InvalidClassException result = new InvalidClassException(String.format(getLoggingLocale(), cannotResolveFilteredClass$str(), clazz));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
