package org.wildfly.httpclient.transaction;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import javax.transaction.xa.XAException;
import jakarta.transaction.SystemException;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import java.util.Arrays;
import jakarta.transaction.RollbackException;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2022-09-19T20:44:24+0200")
public class HttpRemoteTransactionMessages_$logger extends DelegatingBasicLogger implements HttpRemoteTransactionMessages, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = HttpRemoteTransactionMessages_$logger.class.getName();
    public HttpRemoteTransactionMessages_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String operationInterrupted$str() {
        return "TXNWFHTTP000001: The protocol operation was interrupted locally";
    }
    @Override
    public final SystemException operationInterrupted() {
        final SystemException result = new SystemException(String.format(getLoggingLocale(), operationInterrupted$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String rollbackOnlyRollback$str() {
        return "TXNWFHTTP000002: Rollback-only transaction rolled back";
    }
    @Override
    public final RollbackException rollbackOnlyRollback() {
        final RollbackException result = new RollbackException(String.format(getLoggingLocale(), rollbackOnlyRollback$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidTxnState$str() {
        return "TXNWFHTTP000003: Invalid transaction state";
    }
    @Override
    public final IllegalStateException invalidTxnState() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), invalidTxnState$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String interruptedXA$str() {
        return "TXNWFHTTP000004: Transaction operation failed due to thread interruption";
    }
    @Override
    public final XAException interruptedXA(final int errorCode) {
        final XAException result = new XAException(String.format(getLoggingLocale(), interruptedXA$str()));
        _copyStackTraceMinusOne(result);
        result.errorCode = errorCode;
        return result;
    }
}
