/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.client.impl;

import java.lang.invoke.MethodHandles;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.client.impl.AsynchronousProducerCreditsImpl;
import org.apache.activemq.artemis.core.client.impl.ClientProducerCreditManager;
import org.apache.activemq.artemis.core.client.impl.ClientProducerCredits;
import org.apache.activemq.artemis.core.client.impl.ClientProducerCreditsImpl;
import org.apache.activemq.artemis.core.client.impl.ClientProducerFlowCallback;
import org.apache.activemq.artemis.core.client.impl.ClientSessionInternal;
import org.apache.activemq.artemis.spi.core.remoting.SessionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientProducerCreditManagerImpl
implements ClientProducerCreditManager {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final int MAX_ANONYMOUS_CREDITS_CACHE_SIZE = 1000;
    private final Map<SimpleString, ClientProducerCredits> producerCredits = new LinkedHashMap<SimpleString, ClientProducerCredits>();
    private final Map<SimpleString, ClientProducerCredits> anonymousCredits = new LinkedHashMap<SimpleString, ClientProducerCredits>();
    private final ClientSessionInternal session;
    private int windowSize;
    private ClientProducerFlowCallback callback;

    public ClientProducerCreditManagerImpl(ClientSessionInternal session, int windowSize) {
        this.session = session;
        this.windowSize = windowSize;
    }

    @Override
    public void setCallback(ClientProducerFlowCallback callback) {
        this.callback = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized ClientProducerCredits getCredits(SimpleString address, boolean anon, SessionContext context) {
        ClientProducerCredits credits;
        if (this.windowSize == -1) {
            return ClientProducerCreditsNoFlowControl.instance;
        }
        boolean needInit = false;
        ClientProducerCreditManagerImpl clientProducerCreditManagerImpl = this;
        synchronized (clientProducerCreditManagerImpl) {
            credits = this.producerCredits.get(address);
            if (credits == null) {
                credits = this.build(address);
                needInit = true;
                this.producerCredits.put(address, credits);
            }
            if (anon) {
                this.addToAnonymousList(address, credits);
            } else {
                credits.incrementRefCount();
                this.anonymousCredits.remove(address);
            }
        }
        if (needInit) {
            credits.init(context);
        }
        return credits;
    }

    private ClientProducerCredits build(SimpleString address) {
        if (this.callback != null) {
            return new AsynchronousProducerCreditsImpl(this.session, address, this.windowSize, this.callback);
        }
        return new ClientProducerCreditsImpl(this.session, address, this.windowSize);
    }

    @Override
    public synchronized void returnCredits(SimpleString address) {
        ClientProducerCredits credits = this.producerCredits.get(address);
        if (credits != null && credits.decrementRefCount() == 0) {
            this.addToAnonymousList(address, credits);
        }
    }

    @Override
    public synchronized void receiveCredits(SimpleString address, int credits) {
        ClientProducerCredits cr = this.producerCredits.get(address);
        if (cr != null) {
            cr.receiveCredits(credits);
        }
    }

    @Override
    public synchronized void receiveFailCredits(SimpleString address, int credits) {
        ClientProducerCredits cr = this.producerCredits.get(address);
        if (cr != null) {
            cr.receiveFailCredits(credits);
        }
    }

    @Override
    public synchronized void reset() {
        for (ClientProducerCredits credits : this.producerCredits.values()) {
            credits.reset();
        }
    }

    @Override
    public synchronized void close() {
        this.windowSize = -1;
        for (ClientProducerCredits credits : this.producerCredits.values()) {
            credits.close();
        }
        this.producerCredits.clear();
        this.anonymousCredits.clear();
    }

    @Override
    public synchronized int creditsMapSize() {
        return this.producerCredits.size();
    }

    @Override
    public synchronized int getMaxAnonymousCacheSize() {
        return this.anonymousCredits.size();
    }

    private void addToAnonymousList(SimpleString address, ClientProducerCredits credits) {
        this.anonymousCredits.put(address, credits);
        if (this.anonymousCredits.size() > 1000) {
            logger.trace("Producer list has more than MAX_ANONYMOUS_CREDITS_CACHE_SIZE={}. clearing elements from the list", (Object)this.anonymousCredits.size());
            try {
                Iterator<Map.Entry<SimpleString, ClientProducerCredits>> iter = this.anonymousCredits.entrySet().iterator();
                while (iter.hasNext() && this.anonymousCredits.size() > 1000) {
                    Map.Entry<SimpleString, ClientProducerCredits> entry = iter.next();
                    if (entry.getValue().getArriving() <= 0) {
                        logger.trace("Removing credit {}, {}", (Object)entry.getKey(), (Object)entry.getValue());
                        iter.remove();
                        this.producerCredits.remove(entry.getKey());
                        entry.getValue().close();
                        continue;
                    }
                    logger.trace("Keeping credit for {}, {}", (Object)entry.getKey(), (Object)entry.getValue());
                }
            }
            catch (Throwable e) {
                logger.warn("Error clearing anonymousList - {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    static class ClientProducerCreditsNoFlowControl
    implements ClientProducerCredits {
        static ClientProducerCreditsNoFlowControl instance = new ClientProducerCreditsNoFlowControl();

        ClientProducerCreditsNoFlowControl() {
        }

        @Override
        public int getArriving() {
            return 0;
        }

        @Override
        public void acquireCredits(int credits) {
        }

        @Override
        public void receiveCredits(int credits) {
        }

        @Override
        public void receiveFailCredits(int credits) {
        }

        @Override
        public boolean isBlocked() {
            return false;
        }

        @Override
        public void init(SessionContext ctx) {
        }

        @Override
        public void reset() {
        }

        @Override
        public void close() {
        }

        @Override
        public void incrementRefCount() {
        }

        @Override
        public int decrementRefCount() {
            return 1;
        }

        @Override
        public SimpleString getAddress() {
            return SimpleString.of("");
        }

        @Override
        public int getBalance() {
            return 0;
        }
    }
}

