/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.client;

import jakarta.jms.BytesMessage;
import jakarta.jms.CompletionListener;
import jakarta.jms.Destination;
import jakarta.jms.InvalidDestinationException;
import jakarta.jms.JMSException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.QueueSender;
import jakarta.jms.StreamMessage;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicPublisher;
import java.lang.invoke.MethodHandles;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQInterruptedException;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.SendAcknowledgementHandler;
import org.apache.activemq.artemis.jms.client.ActiveMQBytesMessage;
import org.apache.activemq.artemis.jms.client.ActiveMQConnection;
import org.apache.activemq.artemis.jms.client.ActiveMQDestination;
import org.apache.activemq.artemis.jms.client.ActiveMQJMSClientBundle;
import org.apache.activemq.artemis.jms.client.ActiveMQMapMessage;
import org.apache.activemq.artemis.jms.client.ActiveMQMessage;
import org.apache.activemq.artemis.jms.client.ActiveMQObjectMessage;
import org.apache.activemq.artemis.jms.client.ActiveMQSession;
import org.apache.activemq.artemis.jms.client.ActiveMQStreamMessage;
import org.apache.activemq.artemis.jms.client.ActiveMQTextMessage;
import org.apache.activemq.artemis.jms.client.ConnectionFactoryOptions;
import org.apache.activemq.artemis.jms.client.JMSExceptionHelper;
import org.apache.activemq.artemis.utils.UUID;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveMQMessageProducer
implements MessageProducer,
QueueSender,
TopicPublisher {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final ConnectionFactoryOptions options;
    private final ActiveMQConnection connection;
    private final SimpleString connID;
    private final ClientProducer clientProducer;
    private final ActiveMQSession session;
    private boolean disableMessageID = false;
    private boolean disableMessageTimestamp = false;
    private int defaultPriority = 4;
    private long defaultTimeToLive = 0L;
    private int defaultDeliveryMode = 2;
    private long defaultDeliveryDelay = 0L;
    private final ActiveMQDestination defaultDestination;

    protected ActiveMQMessageProducer(ActiveMQConnection connection, ClientProducer producer, ActiveMQDestination defaultDestination, ActiveMQSession session, ConnectionFactoryOptions options) throws JMSException {
        this.options = options;
        this.connection = connection;
        this.connID = connection.getClientID() != null ? SimpleString.of(connection.getClientID()) : connection.getUID();
        this.clientProducer = producer;
        this.defaultDestination = defaultDestination;
        this.session = session;
    }

    @Override
    public void setDisableMessageID(boolean value) throws JMSException {
        this.checkClosed();
        this.disableMessageID = value;
    }

    @Override
    public boolean getDisableMessageID() throws JMSException {
        this.checkClosed();
        return this.disableMessageID;
    }

    @Override
    public void setDisableMessageTimestamp(boolean value) throws JMSException {
        this.checkClosed();
        this.disableMessageTimestamp = value;
    }

    @Override
    public boolean getDisableMessageTimestamp() throws JMSException {
        this.checkClosed();
        return this.disableMessageTimestamp;
    }

    @Override
    public void setDeliveryMode(int deliveryMode) throws JMSException {
        this.checkClosed();
        if (deliveryMode != 1 && deliveryMode != 2) {
            throw ActiveMQJMSClientBundle.BUNDLE.illegalDeliveryMode(deliveryMode);
        }
        this.defaultDeliveryMode = deliveryMode;
    }

    @Override
    public int getDeliveryMode() throws JMSException {
        this.checkClosed();
        return this.defaultDeliveryMode;
    }

    @Override
    public void setPriority(int defaultPriority) throws JMSException {
        this.checkClosed();
        if (defaultPriority < 0 || defaultPriority > 9) {
            throw new JMSException("Illegal priority value: " + defaultPriority);
        }
        this.defaultPriority = defaultPriority;
    }

    @Override
    public int getPriority() throws JMSException {
        this.checkClosed();
        return this.defaultPriority;
    }

    @Override
    public void setTimeToLive(long timeToLive) throws JMSException {
        this.checkClosed();
        this.defaultTimeToLive = timeToLive;
    }

    @Override
    public long getTimeToLive() throws JMSException {
        this.checkClosed();
        return this.defaultTimeToLive;
    }

    @Override
    public Destination getDestination() throws JMSException {
        this.checkClosed();
        return this.defaultDestination;
    }

    @Override
    public void close() throws JMSException {
        this.connection.getThreadAwareContext().assertNotCompletionListenerThread();
        try {
            this.clientProducer.close();
        }
        catch (ActiveMQException e) {
            throw JMSExceptionHelper.convertFromActiveMQException(e);
        }
    }

    @Override
    public void send(Message message) throws JMSException {
        this.checkDefaultDestination();
        this.doSendx(this.defaultDestination, message, this.defaultDeliveryMode, this.defaultPriority, this.defaultTimeToLive, null);
    }

    @Override
    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.checkDefaultDestination();
        this.doSendx(this.defaultDestination, message, deliveryMode, priority, timeToLive, null);
    }

    @Override
    public void send(Destination destination, Message message) throws JMSException {
        this.send(destination, message, this.defaultDeliveryMode, this.defaultPriority, this.defaultTimeToLive);
    }

    @Override
    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.checkClosed();
        this.checkDestination(destination);
        this.doSendx((ActiveMQDestination)destination, message, deliveryMode, priority, timeToLive, null);
    }

    @Override
    public void setDeliveryDelay(long deliveryDelay) throws JMSException {
        this.defaultDeliveryDelay = deliveryDelay;
    }

    @Override
    public long getDeliveryDelay() throws JMSException {
        return this.defaultDeliveryDelay;
    }

    @Override
    public void send(Message message, CompletionListener completionListener) throws JMSException {
        this.send(message, this.defaultDeliveryMode, this.defaultPriority, this.defaultTimeToLive, completionListener);
    }

    @Override
    public void send(Message message, int deliveryMode, int priority, long timeToLive, CompletionListener completionListener) throws JMSException {
        this.checkCompletionListener(completionListener);
        this.checkDefaultDestination();
        this.doSendx(this.defaultDestination, message, deliveryMode, priority, timeToLive, completionListener);
    }

    @Override
    public void send(Destination destination, Message message, CompletionListener completionListener) throws JMSException {
        this.send(destination, message, this.defaultDeliveryMode, this.defaultPriority, this.defaultTimeToLive, completionListener);
    }

    @Override
    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive, CompletionListener completionListener) throws JMSException {
        this.checkClosed();
        this.checkCompletionListener(completionListener);
        this.checkDestination(destination);
        this.doSendx((ActiveMQDestination)destination, message, deliveryMode, priority, timeToLive, completionListener);
    }

    @Override
    public Topic getTopic() throws JMSException {
        return (Topic)this.getDestination();
    }

    @Override
    public void publish(Message message) throws JMSException {
        this.send(message);
    }

    @Override
    public void publish(Topic topic, Message message) throws JMSException {
        this.send(topic, message);
    }

    @Override
    public void publish(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.send(message, deliveryMode, priority, timeToLive);
    }

    @Override
    public void publish(Topic topic, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.checkDestination(topic);
        this.doSendx((ActiveMQDestination)((Object)topic), message, deliveryMode, priority, timeToLive, null);
    }

    @Override
    public void send(Queue queue, Message message) throws JMSException {
        this.send((Destination)queue, message);
    }

    @Override
    public void send(Queue queue, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.checkDestination(queue);
        this.doSendx((ActiveMQDestination)((Object)queue), message, deliveryMode, priority, timeToLive, null);
    }

    @Override
    public Queue getQueue() throws JMSException {
        return (Queue)this.getDestination();
    }

    public String toString() {
        return "ActiveMQMessageProducer->" + this.clientProducer;
    }

    private void checkDefaultDestination() {
        if (this.defaultDestination == null) {
            throw new UnsupportedOperationException("Producer does not have a default destination");
        }
    }

    private void checkDestination(Destination destination) throws InvalidDestinationException {
        if (destination != null && !(destination instanceof ActiveMQDestination)) {
            throw new InvalidDestinationException("Foreign destination:" + destination);
        }
        if (destination != null && this.defaultDestination != null) {
            throw new UnsupportedOperationException("Cannot specify destination if producer has a default destination");
        }
        if (destination == null) {
            throw ActiveMQJMSClientBundle.BUNDLE.nullTopic();
        }
    }

    private void checkCompletionListener(CompletionListener completionListener) {
        if (completionListener == null) {
            throw ActiveMQJMSClientBundle.BUNDLE.nullArgumentNotAllowed("CompletionListener");
        }
    }

    private void doSendx(ActiveMQDestination destination, Message jmsMessage, int deliveryMode, int priority, long timeToLive, CompletionListener completionListener) throws JMSException {
        ActiveMQMessage activeMQJmsMessage;
        jmsMessage.setJMSDeliveryMode(deliveryMode);
        jmsMessage.setJMSPriority(priority);
        if (timeToLive == 0L) {
            jmsMessage.setJMSExpiration(0L);
        } else {
            jmsMessage.setJMSExpiration(System.currentTimeMillis() + timeToLive);
        }
        if (!this.disableMessageTimestamp) {
            jmsMessage.setJMSTimestamp(System.currentTimeMillis());
        } else {
            jmsMessage.setJMSTimestamp(0L);
        }
        SimpleString address = null;
        ClientSession clientSession = this.session.getCoreSession();
        if (destination == null) {
            if (this.defaultDestination == null) {
                throw new UnsupportedOperationException("Destination must be specified on send with an anonymous producer");
            }
            destination = this.defaultDestination;
        } else {
            if (this.defaultDestination != null && !destination.equals(this.defaultDestination)) {
                throw new UnsupportedOperationException("Where a default destination is specified for the sender and a destination is specified in the arguments to the send, these destinations must be equal");
            }
            this.session.checkDestination(destination);
            address = destination.getSimpleAddress();
        }
        boolean foreign = false;
        if (!(jmsMessage instanceof ActiveMQMessage)) {
            activeMQJmsMessage = jmsMessage instanceof BytesMessage ? new ActiveMQBytesMessage((BytesMessage)jmsMessage, clientSession) : (jmsMessage instanceof MapMessage ? new ActiveMQMapMessage((MapMessage)jmsMessage, clientSession) : (jmsMessage instanceof ObjectMessage ? new ActiveMQObjectMessage((ObjectMessage)jmsMessage, clientSession, this.options) : (jmsMessage instanceof StreamMessage ? new ActiveMQStreamMessage((StreamMessage)jmsMessage, clientSession) : (jmsMessage instanceof TextMessage ? new ActiveMQTextMessage((TextMessage)jmsMessage, clientSession) : new ActiveMQMessage(jmsMessage, clientSession)))));
            jmsMessage.setJMSDestination(destination);
            foreign = true;
        } else {
            activeMQJmsMessage = (ActiveMQMessage)jmsMessage;
        }
        if (!this.disableMessageID) {
            UUID uid = UUIDGenerator.getInstance().generateUUID();
            activeMQJmsMessage.getCoreMessage().setUserID(uid);
            activeMQJmsMessage.resetMessageID(null);
        }
        if (foreign) {
            jmsMessage.setJMSMessageID(activeMQJmsMessage.getJMSMessageID());
        }
        activeMQJmsMessage.setJMSDestination(destination);
        try {
            activeMQJmsMessage.doBeforeSend();
        }
        catch (Exception e) {
            JMSException je = new JMSException(e.getMessage());
            je.initCause(e);
            throw je;
        }
        if (this.defaultDeliveryDelay > 0L) {
            activeMQJmsMessage.setJMSDeliveryTime(System.currentTimeMillis() + this.defaultDeliveryDelay);
        }
        ClientMessage coreMessage = activeMQJmsMessage.getCoreMessage();
        coreMessage.putStringProperty(ActiveMQConnection.CONNECTION_ID_PROPERTY_NAME, this.connID);
        coreMessage.setRoutingType(destination.isQueue() ? RoutingType.ANYCAST : RoutingType.MULTICAST);
        try {
            if (completionListener != null) {
                this.clientProducer.send(address, coreMessage, new CompletionListenerWrapper(completionListener, jmsMessage, this));
            } else {
                this.clientProducer.send(address, (org.apache.activemq.artemis.api.core.Message)coreMessage);
            }
        }
        catch (ActiveMQInterruptedException e) {
            JMSException jmsException = new JMSException(e.getMessage());
            jmsException.initCause(e);
            throw jmsException;
        }
        catch (ActiveMQException e) {
            throw JMSExceptionHelper.convertFromActiveMQException(e);
        }
        catch (IllegalStateException e) {
            jakarta.jms.IllegalStateException je = new jakarta.jms.IllegalStateException(e.getMessage());
            je.setStackTrace(e.getStackTrace());
            je.initCause(e);
            throw je;
        }
    }

    private void checkClosed() throws JMSException {
        if (this.clientProducer.isClosed()) {
            throw new jakarta.jms.IllegalStateException("Producer is closed");
        }
        this.session.checkClosed();
    }

    private static final class CompletionListenerWrapper
    implements SendAcknowledgementHandler {
        private final CompletionListener completionListener;
        private final Message jmsMessage;
        private final ActiveMQMessageProducer producer;

        private CompletionListenerWrapper(CompletionListener listener, Message jmsMessage, ActiveMQMessageProducer producer) {
            this.completionListener = listener;
            this.jmsMessage = jmsMessage;
            this.producer = producer;
        }

        @Override
        public void sendAcknowledged(org.apache.activemq.artemis.api.core.Message clientMessage) {
            if (this.jmsMessage instanceof StreamMessage) {
                try {
                    ((StreamMessage)this.jmsMessage).reset();
                }
                catch (JMSException e) {
                    logger.debug("ignoring exception", e);
                }
            }
            if (this.jmsMessage instanceof BytesMessage) {
                try {
                    ((BytesMessage)this.jmsMessage).reset();
                }
                catch (JMSException e) {
                    logger.debug("ignoring exception", e);
                }
            }
            try {
                this.producer.connection.getThreadAwareContext().setCurrentThread(true);
                this.completionListener.onCompletion(this.jmsMessage);
            }
            finally {
                this.producer.connection.getThreadAwareContext().clearCurrentThread(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sendFailed(org.apache.activemq.artemis.api.core.Message clientMessage, Exception exception) {
            if (this.jmsMessage instanceof StreamMessage) {
                try {
                    ((StreamMessage)this.jmsMessage).reset();
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
            }
            if (this.jmsMessage instanceof BytesMessage) {
                try {
                    ((BytesMessage)this.jmsMessage).reset();
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
            }
            try {
                this.producer.connection.getThreadAwareContext().setCurrentThread(true);
                if (exception instanceof ActiveMQException) {
                    exception = JMSExceptionHelper.convertFromActiveMQException((ActiveMQException)exception);
                } else if (exception instanceof ActiveMQInterruptedException) {
                    exception = JMSExceptionHelper.convertFromActiveMQException((ActiveMQInterruptedException)exception);
                }
                this.completionListener.onException(this.jmsMessage, exception);
            }
            finally {
                this.producer.connection.getThreadAwareContext().clearCurrentThread(true);
            }
        }

        public String toString() {
            return CompletionListenerWrapper.class.getSimpleName() + "( completionListener=" + this.completionListener + ")";
        }
    }
}

