package org.wildfly.naming.client._private;

import java.util.Locale;
import javax.naming.NotContextException;
import java.io.Serializable;
import org.wildfly.naming.client.RenameAcrossNamingProvidersException;
import javax.naming.AuthenticationException;
import org.jboss.logging.DelegatingBasicLogger;
import javax.naming.InterruptedNamingException;
import java.util.ServiceConfigurationError;
import java.lang.String;
import org.jboss.logging.Logger;
import java.net.URI;
import org.wildfly.naming.client.ExhaustedDestinationsException;
import javax.naming.Name;
import java.lang.RuntimeException;
import javax.naming.InvalidNameException;
import javax.naming.ConfigurationException;
import org.jboss.logging.BasicLogger;
import javax.naming.NamingException;
import java.lang.IllegalArgumentException;
import javax.naming.Context;
import javax.naming.OperationNotSupportedException;
import javax.annotation.processing.Generated;
import java.lang.IndexOutOfBoundsException;
import javax.naming.CommunicationException;
import javax.naming.NameNotFoundException;
import java.io.InvalidClassException;
import java.io.IOException;
import java.lang.Exception;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.naming.NoPermissionException;
import java.lang.Throwable;
import java.lang.Object;
import java.util.Arrays;


import static org.jboss.logging.Logger.Level.TRACE;
import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2023-05-26T13:26:29+0200")
public class Messages_$logger extends DelegatingBasicLogger implements Messages, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Messages_$logger.class.getName();
    public Messages_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void serviceConfigFailed(final ServiceConfigurationError error) {
        super.log.logf(FQCN, TRACE, error, serviceConfigFailed$str());
    }
    protected String serviceConfigFailed$str() {
        return "Service configuration failure loading naming providers";
    }
    @Override
    public final void greeting(final String version) {
        super.log.logf(FQCN, INFO, null, greeting$str(), version);
    }
    protected String greeting$str() {
        return "WildFly Naming version %s";
    }
    protected String invalidProviderUri$str() {
        return "WFNAM00003: Invalid naming provider URI: %s";
    }
    @Override
    public final ConfigurationException invalidProviderUri(final Exception cause, final Object providerUri) {
        final ConfigurationException result = new ConfigurationException(String.format(getLoggingLocale(), invalidProviderUri$str(), providerUri));
        result.initCause(cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String nameNotFound$str() {
        return "WFNAM00004: Name \"%s\" is not found";
    }
    @Override
    public final NameNotFoundException nameNotFound(final Name name1, final Name name) {
        final NameNotFoundException result = new NameNotFoundException(String.format(getLoggingLocale(), nameNotFound$str(), name1));
        _copyStackTraceMinusOne(result);
        result.setResolvedName(name);
        return result;
    }
    protected String invalidEmptyName$str() {
        return "WFNAM00005: Invalid empty name";
    }
    @Override
    public final InvalidNameException invalidEmptyName() {
        final InvalidNameException result = new InvalidNameException(String.format(getLoggingLocale(), invalidEmptyName$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String readOnlyContext$str() {
        return "WFNAM00006: Cannot modify read-only naming context";
    }
    @Override
    public final NoPermissionException readOnlyContext() {
        final NoPermissionException result = new NoPermissionException(String.format(getLoggingLocale(), readOnlyContext$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidURLSchemeName$str() {
        return "WFNAM00007: Invalid URL scheme name \"%s\"";
    }
    @Override
    public final InvalidNameException invalidURLSchemeName(final String name) {
        final InvalidNameException result = new InvalidNameException(String.format(getLoggingLocale(), invalidURLSchemeName$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nameIndexOutOfBounds$str() {
        return "WFNAM00009: Name index %d is out of bounds";
    }
    @Override
    public final IndexOutOfBoundsException nameIndexOutOfBounds(final int pos) {
        final IndexOutOfBoundsException result = new IndexOutOfBoundsException(String.format(getLoggingLocale(), nameIndexOutOfBounds$str(), pos));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidNullSegment$str() {
        return "WFNAM00010: Invalid null name segment at index %d";
    }
    @Override
    public final IllegalArgumentException invalidNullSegment(final int index) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidNullSegment$str(), index));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingCloseQuote$str() {
        return "WFNAM00011: Missing close quote '%s' in name \"%s\"";
    }
    @Override
    public final InvalidNameException missingCloseQuote(final char quote, final String name) {
        final InvalidNameException result = new InvalidNameException(String.format(getLoggingLocale(), missingCloseQuote$str(), quote, name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingEscape$str() {
        return "WFNAM00012: Unterminated escape sequence in name \"%s\"";
    }
    @Override
    public final InvalidNameException missingEscape(final String name) {
        final InvalidNameException result = new InvalidNameException(String.format(getLoggingLocale(), missingEscape$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String renameAcrossProviders$str() {
        return "WFNAM00014: Renaming from \"%s\" to \"%s\" across providers is not supported";
    }
    @Override
    public final RenameAcrossNamingProvidersException renameAcrossProviders(final Name oldName, final Name newName) {
        final RenameAcrossNamingProvidersException result = new RenameAcrossNamingProvidersException(String.format(getLoggingLocale(), renameAcrossProviders$str(), oldName, newName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String notContextInCompositeName$str() {
        return "WFNAM00015: Composite name segment \"%s\" does not refer to a context";
    }
    @Override
    public final NotContextException notContextInCompositeName(final String segment) {
        final NotContextException result = new NotContextException(String.format(getLoggingLocale(), notContextInCompositeName$str(), segment));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void contextCloseFailed(final Context context, final Throwable cause) {
        super.log.logf(FQCN, DEBUG, cause, contextCloseFailed$str(), context);
    }
    protected String contextCloseFailed$str() {
        return "WFNAM00016: Closing context \"%s\" failed";
    }
    protected String noRemotingEndpoint$str() {
        return "WFNAM00017: No JBoss Remoting endpoint has been configured";
    }
    @Override
    public final CommunicationException noRemotingEndpoint() {
        final CommunicationException result = new CommunicationException(String.format(getLoggingLocale(), noRemotingEndpoint$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String connectFailed$str() {
        return "WFNAM00018: Failed to connect to remote host";
    }
    @Override
    public final CommunicationException connectFailed(final Throwable cause) {
        final CommunicationException result = new CommunicationException(String.format(getLoggingLocale(), connectFailed$str()));
        result.initCause(cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String operationInterrupted$str() {
        return "WFNAM00019: Naming operation interrupted";
    }
    @Override
    public final InterruptedNamingException operationInterrupted() {
        final InterruptedNamingException result = new InterruptedNamingException(String.format(getLoggingLocale(), operationInterrupted$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String operationFailed$str() {
        return "WFNAM00020: Remote naming operation failed";
    }
    @Override
    public final CommunicationException operationFailed(final Throwable cause) {
        final CommunicationException result = new CommunicationException(String.format(getLoggingLocale(), operationFailed$str()));
        result.initCause(cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noCompatibleVersions$str() {
        return "WFNAM00022: The server provided no compatible protocol versions";
    }
    @Override
    public final CommunicationException noCompatibleVersions() {
        final CommunicationException result = new CommunicationException(String.format(getLoggingLocale(), noCompatibleVersions$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidResponse$str() {
        return "WFNAM00023: Received an invalid response from the server";
    }
    @Override
    public final CommunicationException invalidResponse() {
        final CommunicationException result = new CommunicationException(String.format(getLoggingLocale(), invalidResponse$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String notSupported$str() {
        return "WFNAM00024: Naming operation not supported";
    }
    @Override
    public final OperationNotSupportedException notSupported() {
        final OperationNotSupportedException result = new OperationNotSupportedException(String.format(getLoggingLocale(), notSupported$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void oldContextDeprecated() {
        super.log.logf(FQCN, INFO, null, oldContextDeprecated$str());
    }
    protected String oldContextDeprecated$str() {
        return "WFNAM00025: org.jboss.naming.remote.client.InitialContextFactory is deprecated; new applications should use org.wildfly.naming.client.WildFlyInitialContextFactory instead";
    }
    protected String noProviderForUri$str() {
        return "WFNAM00026: No provider for found for URI: %s";
    }
    @Override
    public final OperationNotSupportedException noProviderForUri(final String uri) {
        final OperationNotSupportedException result = new OperationNotSupportedException(String.format(getLoggingLocale(), noProviderForUri$str(), uri));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidHeader$str() {
        return "WFNAM00029: Invalid leading bytes in header";
    }
    @Override
    public final CommunicationException invalidHeader() {
        final CommunicationException result = new CommunicationException(String.format(getLoggingLocale(), invalidHeader$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String outcomeNotUnderstood$str() {
        return "WFNAM00031: Outcome not understood";
    }
    @Override
    public final IOException outcomeNotUnderstood() {
        final IOException result = new IOException(String.format(getLoggingLocale(), outcomeNotUnderstood$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String authenticationFailed$str() {
        return "WFNAM00032: Peer authentication failed";
    }
    @Override
    public final AuthenticationException authenticationFailed(final org.wildfly.security.auth.AuthenticationException cause) {
        final AuthenticationException result = new AuthenticationException(String.format(getLoggingLocale(), authenticationFailed$str()));
        result.initCause(cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String connectionSharingUnsupported$str() {
        return "WFNAM00033: Connection sharing not supported";
    }
    @Override
    public final AuthenticationException connectionSharingUnsupported() {
        final AuthenticationException result = new AuthenticationException(String.format(getLoggingLocale(), connectionSharingUnsupported$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void unexpectedParameterType(final int expected, final int actual) {
        super.log.logf(FQCN, ERROR, null, unexpectedParameterType$str(), expected, actual);
    }
    protected String unexpectedParameterType$str() {
        return "WFNAM00034: Unexpected parameter type - expected: %d  received: %d";
    }
    @Override
    public final void failedToSendExceptionResponse(final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, failedToSendExceptionResponse$str());
    }
    protected String failedToSendExceptionResponse$str() {
        return "WFNAM00035: Failed to send exception response to client";
    }
    @Override
    public final void unexpectedError(final Throwable cause) {
        super.log.logf(FQCN, WARN, cause, unexpectedError$str());
    }
    protected String unexpectedError$str() {
        return "WFNAM00036: Unexpected internal error";
    }
    @Override
    public final void nullCorrelationId(final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, nullCorrelationId$str());
    }
    protected String nullCorrelationId$str() {
        return "WFNAM00037: null correlationId so error not sent to client";
    }
    protected String unrecognizedMessageId$str() {
        return "WFNAM00038: Unrecognized messageId";
    }
    @Override
    public final IOException unrecognizedMessageId() {
        final IOException result = new IOException(String.format(getLoggingLocale(), unrecognizedMessageId$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void failedToSendHeader(final IOException e) {
        super.log.logf(FQCN, ERROR, e, failedToSendHeader$str());
    }
    protected String failedToSendHeader$str() {
        return "WFNAM00039: Unable to send header, closing channel";
    }
    protected String unsupportedProtocolVersion$str() {
        return "WFNAM00040: Unsupported protocol version [ %d ]";
    }
    @Override
    public final IllegalArgumentException unsupportedProtocolVersion(final int version) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unsupportedProtocolVersion$str(), version));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void failedToDetermineClientVersion(final Throwable t) {
        super.log.logf(FQCN, ERROR, t, failedToDetermineClientVersion$str());
    }
    protected String failedToDetermineClientVersion$str() {
        return "WFNAM00041: Error determining version selected by client";
    }
    protected String failedToLoadCallbackHandlerClass$str() {
        return "WFNAM00043: Unable to load callback handler class \"%s\"";
    }
    @Override
    public final RuntimeException failedToLoadCallbackHandlerClass(final Exception cause, final String callbackHandlerClass) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), failedToLoadCallbackHandlerClass$str(), callbackHandlerClass), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String failedToInstantiateCallbackHandlerInstance$str() {
        return "WFNAM00044: Unable to instantiate callback handler instance of type  \"%s\"";
    }
    @Override
    public final NamingException failedToInstantiateCallbackHandlerInstance(final Exception cause, final String callbackHandlerClass) {
        final NamingException result = new NamingException(String.format(getLoggingLocale(), failedToInstantiateCallbackHandlerInstance$str(), callbackHandlerClass));
        result.initCause(cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void deprecatedProperties() {
        if (super.log.isEnabled(INFO) && deprecatedProperties_$Once.compareAndSet(false, true)) {
            super.log.logf(FQCN, INFO, null, deprecatedProperties$str());
        }
    }
    protected String deprecatedProperties$str() {
        return "WFNAM00049: Usage of the legacy \"remote.connections\" property is deprecated; please use javax.naming.Context#PROVIDER_URL instead";
    }
    private static final AtomicBoolean deprecatedProperties_$Once = new AtomicBoolean(false);
    @Override
    public final void ignoringLegacyProperties() {
        super.log.logf(FQCN, WARN, null, ignoringLegacyProperties$str());
    }
    protected String ignoringLegacyProperties$str() {
        return "WFNAM00051: Provider URLs already given via standard mechanism; ignoring legacy property-based connection configuration";
    }
    protected String invalidNumericProperty$str() {
        return "WFNAM00052: Invalid value given for property \"%s\": \"%s\" is not numeric";
    }
    @Override
    public final ConfigurationException invalidNumericProperty(final Throwable e, final String propertyName, final String resultStr) {
        final ConfigurationException result = new ConfigurationException(String.format(getLoggingLocale(), invalidNumericProperty$str(), propertyName, resultStr));
        result.initCause(e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidProviderGenerated$str() {
        return "WFNAM00053: Failed to synthesize a valid provider URL";
    }
    @Override
    public final ConfigurationException invalidProviderGenerated(final Throwable e) {
        final ConfigurationException result = new ConfigurationException(String.format(getLoggingLocale(), invalidProviderGenerated$str()));
        result.initCause(e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void ignoringDuplicateDestination(final URI uri) {
        super.log.logf(FQCN, WARN, null, ignoringDuplicateDestination$str(), uri);
    }
    protected String ignoringDuplicateDestination$str() {
        return "WFNAM00054: Ignoring duplicate destination URI \"%s\"";
    }
    protected String noMoreDestinations2$str() {
        return "WFNAM00055: No more destinations are available to attempt the operation (%d blocklisted, %d transiently failed). See suppressed exceptions for details";
    }
    @Override
    public final ExhaustedDestinationsException noMoreDestinations(final int blocklisted, final int transientlyFailed) {
        final ExhaustedDestinationsException result = new ExhaustedDestinationsException(String.format(getLoggingLocale(), noMoreDestinations2$str(), blocklisted, transientlyFailed));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noMoreDestinations0$str() {
        return "WFNAM00056: No more destinations are available to attempt the operation.";
    }
    @Override
    public final ExhaustedDestinationsException noMoreDestinations() {
        final ExhaustedDestinationsException result = new ExhaustedDestinationsException(String.format(getLoggingLocale(), noMoreDestinations0$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void oldClientPropertyFileDeprecated() {
        super.log.logf(FQCN, INFO, null, oldClientPropertyFileDeprecated$str());
    }
    protected String oldClientPropertyFileDeprecated$str() {
        return "WFNAM00057: jboss-naming-client.properties is deprecated; new applications should use org.wildfly.naming.client.WildFlyInitialContextFactory instead";
    }
    protected String cannotResolveFilteredClass$str() {
        return "WFNAM00058: Exception resolving class %s for unmarshalling; it has either been blocklisted or not allowlisted";
    }
    @Override
    public final InvalidClassException cannotResolveFilteredClass(final String clazz) {
        final InvalidClassException result = new InvalidClassException(String.format(getLoggingLocale(), cannotResolveFilteredClass$str(), clazz));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void javaeeToJakartaeeBackwardCompatibilityLayerInstalled() {
        super.log.logf(FQCN, DEBUG, null, javaeeToJakartaeeBackwardCompatibilityLayerInstalled$str());
    }
    protected String javaeeToJakartaeeBackwardCompatibilityLayerInstalled$str() {
        return "WFNAM00059: JavaEE to JakartaEE backward compatibility layer have been installed";
    }
}
