package org.wildfly.transaction.client._private;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import org.jboss.logging.DelegatingBasicLogger;
import java.util.ServiceConfigurationError;
import jakarta.transaction.InvalidTransactionException;
import java.lang.String;
import java.net.URISyntaxException;
import org.jboss.logging.Logger;
import jakarta.transaction.RollbackException;
import java.net.URI;
import org.wildfly.transaction.client.DelayedEnlistmentException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.SystemException;
import org.jboss.remoting3.Endpoint;
import java.lang.NullPointerException;
import org.jboss.logging.BasicLogger;
import java.security.Permission;
import java.lang.IllegalArgumentException;
import java.lang.UnsupportedOperationException;
import java.nio.file.Path;
import javax.annotation.processing.Generated;
import javax.transaction.xa.XAException;
import java.lang.SecurityException;
import java.io.IOException;
import java.lang.Exception;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import jakarta.transaction.Transaction;
import jakarta.transaction.HeuristicMixedException;
import java.lang.Throwable;
import java.lang.Class;
import java.util.Arrays;
import jakarta.transaction.NotSupportedException;
import jakarta.transaction.HeuristicCommitException;
import java.io.File;
import org.wildfly.transaction.client.SynchronizationException;


import static org.jboss.logging.Logger.Level.TRACE;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2024-03-13T17:34:54+0100")
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String subordinateXaResource$str() {
        return "Subordinate XAResource at %s";
    }
    @Override
    public final String subordinateXaResource(final URI location) {
        return String.format(getLoggingLocale(), subordinateXaResource$str(), location);
    }
    protected String failedToAddXAResourceToRegistry$str() {
        return "Failed to add XAResource %s with Xid %s pointing to location %s to XAResourceRegistry";
    }
    @Override
    public final String failedToAddXAResourceToRegistry(final XAResource xaResource, final Xid xid, final URI location) {
        return String.format(getLoggingLocale(), failedToAddXAResourceToRegistry$str(), xaResource, xid, location);
    }
    @Override
    public final void serviceConfigurationFailed(final ServiceConfigurationError e) {
        super.log.logf(FQCN, DEBUG, e, serviceConfigurationFailed$str());
    }
    protected String serviceConfigurationFailed$str() {
        return "Failed to configure a remote transaction service provider";
    }
    @Override
    public final void recoverySuppressedException(final XAException e) {
        super.log.logf(FQCN, DEBUG, e, recoverySuppressedException$str());
    }
    protected String recoverySuppressedException$str() {
        return "Closing the recovery stream after recovery failed threw an exception";
    }
    @Override
    public final void setTimeoutUnsuccessful(final int timeout) {
        super.log.logf(FQCN, DEBUG, null, setTimeoutUnsuccessful$str(), timeout);
    }
    protected String setTimeoutUnsuccessful$str() {
        return "Failed to set transaction timeout of %d";
    }
    @Override
    public final void inboundException(final Throwable e) {
        super.log.logf(FQCN, TRACE, e, inboundException$str());
    }
    protected String inboundException$str() {
        return "Got exception on inbound message";
    }
    @Override
    public final void outboundException(final Throwable e) {
        super.log.logf(FQCN, TRACE, e, outboundException$str());
    }
    protected String outboundException$str() {
        return "Got exception on outbound message";
    }
    @Override
    public final void doRecoverFailureOnIntialization(final Throwable e) {
        super.log.logf(FQCN, TRACE, e, doRecoverFailureOnIntialization$str());
    }
    protected String doRecoverFailureOnIntialization$str() {
        return "Failure on running doRecover during initialization";
    }
    @Override
    public final void xaResourceRecoveryFileCreated(final Path path) {
        super.log.logf(FQCN, TRACE, null, xaResourceRecoveryFileCreated$str(), path);
    }
    protected String xaResourceRecoveryFileCreated$str() {
        return "Created xa resource recovery file: %s";
    }
    @Override
    public final void xaResourceRecoveryFileDeleted(final Path path) {
        super.log.logf(FQCN, TRACE, null, xaResourceRecoveryFileDeleted$str(), path);
    }
    protected String xaResourceRecoveryFileDeleted$str() {
        return "Deleted xa resource recovery file: %s";
    }
    @Override
    public final void xaResourceRecoveryRegistryReloaded(final Path filePath) {
        super.log.logf(FQCN, TRACE, null, xaResourceRecoveryRegistryReloaded$str(), filePath);
    }
    protected String xaResourceRecoveryRegistryReloaded$str() {
        return "Reloaded xa resource recovery registry file: %s";
    }
    @Override
    public final void xaResourceAddedToRecoveryRegistry(final URI uri, final Path filePath) {
        super.log.logf(FQCN, TRACE, null, xaResourceAddedToRecoveryRegistry$str(), uri, filePath);
    }
    protected String xaResourceAddedToRecoveryRegistry$str() {
        return "Added resource (%s) to xa resource recovery registry %s";
    }
    @Override
    public final void xaResourceRecoveredFromRecoveryRegistry(final URI uri, final Path filePath) {
        super.log.logf(FQCN, TRACE, null, xaResourceRecoveredFromRecoveryRegistry$str(), uri, filePath);
    }
    protected String xaResourceRecoveredFromRecoveryRegistry$str() {
        return "Recovered in doubt xa resource (%s) from xa resource recovery registry %s";
    }
    @Override
    public final void unknownXidToBeRemovedFromTheKnownTransactionInstances(final Xid xid) {
        super.log.logf(FQCN, TRACE, null, unknownXidToBeRemovedFromTheKnownTransactionInstances$str(), xid);
    }
    protected String unknownXidToBeRemovedFromTheKnownTransactionInstances$str() {
        return "Unknown xid %s to be removed from the instances known to the wfly txn client";
    }
    protected String noTransaction$str() {
        return "No transaction associated with the current thread";
    }
    @Override
    public final IllegalStateException noTransaction() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noTransaction$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String nestedNotSupported$str() {
        return "WFTXN0001: A transaction is already in progress";
    }
    @Override
    public final NotSupportedException nestedNotSupported() {
        final NotSupportedException result = new NotSupportedException(String.format(getLoggingLocale(), nestedNotSupported$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String notSupportedTransaction$str() {
        return "WFTXN0002: Transaction is not a supported instance: %s";
    }
    @Override
    public final InvalidTransactionException notSupportedTransaction(final Transaction transaction) {
        final InvalidTransactionException result = new InvalidTransactionException(String.format(getLoggingLocale(), notSupportedTransaction$str(), transaction));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidTransactionLocationUri$str() {
        return "WFTXN0003: Invalid transaction location URI (must be absolute): %s";
    }
    @Override
    public final IllegalArgumentException invalidTransactionLocationUri(final URI uri) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidTransactionLocationUri$str(), uri));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noProviderForUri$str() {
        return "WFTXN0004: No transaction provider installed for URI: %s";
    }
    @Override
    public final IllegalArgumentException noProviderForUri(final URI uri) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), noProviderForUri$str(), uri));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String transactionNotAssociatedWithThisProvider$str() {
        return "WFTXN0005: Transaction not associated with this provider";
    }
    @Override
    public final InvalidTransactionException transactionNotAssociatedWithThisProvider() {
        final InvalidTransactionException result = new InvalidTransactionException(String.format(getLoggingLocale(), transactionNotAssociatedWithThisProvider$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String negativeTxnTimeout$str() {
        return "WFTXN0006: Negative transaction timeout provided";
    }
    @Override
    public final SystemException negativeTxnTimeout() {
        final SystemException result = new SystemException(String.format(getLoggingLocale(), negativeTxnTimeout$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String alreadyAssociated$str() {
        return "WFTXN0007: A transaction is already associated with the current thread";
    }
    @Override
    public final IllegalStateException alreadyAssociated() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), alreadyAssociated$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String registerSynchRemoteTransaction$str() {
        return "WFTXN0008: Cannot register a synchronization on a remote transaction";
    }
    @Override
    public final UnsupportedOperationException registerSynchRemoteTransaction() {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(getLoggingLocale(), registerSynchRemoteTransaction$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String enlistDelistRemoteTransaction$str() {
        return "WFTXN0009: Cannot enlist or delist resources on a remote transaction";
    }
    @Override
    public final UnsupportedOperationException enlistDelistRemoteTransaction() {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(getLoggingLocale(), enlistDelistRemoteTransaction$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String failedToReceive$str() {
        return "WFTXN0010: Failed to receive protocol message from remote peer";
    }
    @Override
    public final SystemException failedToReceive(final IOException e) {
        final SystemException result = new SystemException(String.format(getLoggingLocale(), failedToReceive$str()));
        result.initCause(e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String failedToSend$str() {
        return "WFTXN0011: Failed to send protocol message to remote peer";
    }
    @Override
    public final SystemException failedToSend(final Exception e) {
        final SystemException result = new SystemException(String.format(getLoggingLocale(), failedToSend$str()));
        result.initCause(e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String peerSystemException$str() {
        return "WFTXN0012: The peer threw a SystemException; see peer logs for more information";
    }
    @Override
    public final SystemException peerSystemException() {
        final SystemException result = new SystemException(String.format(getLoggingLocale(), peerSystemException$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String peerSecurityException$str() {
        return "WFTXN0013: The peer threw a SecurityException; see peer logs for more information";
    }
    @Override
    public final SecurityException peerSecurityException() {
        final SecurityException result = new SecurityException(String.format(getLoggingLocale(), peerSecurityException$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String protocolError$str() {
        return "WFTXN0014: An unexpected protocol error occurred";
    }
    @Override
    public final SystemException protocolError() {
        final SystemException result = new SystemException(String.format(getLoggingLocale(), protocolError$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String operationInterrupted$str() {
        return "WFTXN0015: The protocol operation was interrupted locally";
    }
    @Override
    public final SystemException operationInterrupted() {
        final SystemException result = new SystemException(String.format(getLoggingLocale(), operationInterrupted$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String transactionRolledBackByPeer$str() {
        return "WFTXN0016: The remote peer rolled back the transaction";
    }
    @Override
    public final RollbackException transactionRolledBackByPeer() {
        final RollbackException result = new RollbackException(String.format(getLoggingLocale(), transactionRolledBackByPeer$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String rollbackOnlyRollback$str() {
        return "WFTXN0017: Rollback-only transaction rolled back";
    }
    @Override
    public final RollbackException rollbackOnlyRollback() {
        final RollbackException result = new RollbackException(String.format(getLoggingLocale(), rollbackOnlyRollback$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidTxnState$str() {
        return "WFTXN0018: Invalid transaction state";
    }
    @Override
    public final IllegalStateException invalidTxnState() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), invalidTxnState$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String peerHeuristicMixedException$str() {
        return "WFTXN0019: The peer threw a HeuristicMixedException; see peer logs for more information";
    }
    @Override
    public final HeuristicMixedException peerHeuristicMixedException() {
        final HeuristicMixedException result = new HeuristicMixedException(String.format(getLoggingLocale(), peerHeuristicMixedException$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String peerHeuristicRollbackException$str() {
        return "WFTXN0020: The peer threw a HeuristicRollbackException; see peer logs for more information";
    }
    @Override
    public final HeuristicRollbackException peerHeuristicRollbackException() {
        final HeuristicRollbackException result = new HeuristicRollbackException(String.format(getLoggingLocale(), peerHeuristicRollbackException$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String failedToAcquireConnection$str() {
        return "WFTXN0021: Failed to acquire a connection for this operation";
    }
    @Override
    public final SystemException failedToAcquireConnection(final IOException reason) {
        final SystemException result = new SystemException(String.format(getLoggingLocale(), failedToAcquireConnection$str()));
        result.initCause(reason);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String duplicateEnlistment$str() {
        return "WFTXN0022: The resource manager for remote connection to %s was already enlisted in a transaction";
    }
    @Override
    public final XAException duplicateEnlistment(final int errorCode, final URI uri) {
        final XAException result = new XAException(String.format(getLoggingLocale(), duplicateEnlistment$str(), uri));
        _copyStackTraceMinusOne(result);
        result.errorCode = errorCode;
        return result;
    }
    protected String invalidFlags$str() {
        return "WFTXN0023: Invalid flag value";
    }
    @Override
    public final IllegalArgumentException invalidFlags() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidFlags$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String duplicateTransaction$str() {
        return "WFTXN0024: Duplicate transaction encountered for destination %s, transaction ID %s";
    }
    @Override
    public final XAException duplicateTransaction(final int errorCode, final URI uri, final Xid xid) {
        final XAException result = new XAException(String.format(getLoggingLocale(), duplicateTransaction$str(), uri, xid));
        _copyStackTraceMinusOne(result);
        result.errorCode = errorCode;
        return result;
    }
    protected String failedToReceiveXA$str() {
        return "WFTXN0025: Failed to receive protocol message from remote peer";
    }
    @Override
    public final XAException failedToReceiveXA(final IOException e, final int errorCode) {
        final XAException result = new XAException(String.format(getLoggingLocale(), failedToReceiveXA$str()));
        result.initCause(e);
        _copyStackTraceMinusOne(result);
        result.errorCode = errorCode;
        return result;
    }
    protected String failedToSendXA$str() {
        return "WFTXN0026: Failed to send protocol message to remote peer";
    }
    @Override
    public final XAException failedToSendXA(final Exception e, final int errorCode) {
        final XAException result = new XAException(String.format(getLoggingLocale(), failedToSendXA$str()));
        result.initCause(e);
        _copyStackTraceMinusOne(result);
        result.errorCode = errorCode;
        return result;
    }
    protected String operationInterruptedXA$str() {
        return "WFTXN0027: The protocol operation was interrupted locally";
    }
    @Override
    public final XAException operationInterruptedXA(final int errorCode) {
        final XAException result = new XAException(String.format(getLoggingLocale(), operationInterruptedXA$str()));
        _copyStackTraceMinusOne(result);
        result.errorCode = errorCode;
        return result;
    }
    protected String protocolErrorXA$str() {
        return "WFTXN0028: An unexpected protocol error occurred";
    }
    @Override
    public final XAException protocolErrorXA(final int errorCode) {
        final XAException result = new XAException(String.format(getLoggingLocale(), protocolErrorXA$str()));
        _copyStackTraceMinusOne(result);
        result.errorCode = errorCode;
        return result;
    }
    protected String peerXaException$str() {
        return "WFTXN0029: The peer threw an XA exception";
    }
    @Override
    public final XAException peerXaException(final int errorCode) {
        final XAException result = new XAException(String.format(getLoggingLocale(), peerXaException$str()));
        _copyStackTraceMinusOne(result);
        result.errorCode = errorCode;
        return result;
    }
    protected String invalidHandleType$str() {
        return "WFTXN0030: Invalid handle type; expected %s, actually received %s";
    }
    @Override
    public final IllegalArgumentException invalidHandleType(final Class<?> expected, final Class<?> actual) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidHandleType$str(), expected, actual));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String commitOnImported$str() {
        return "WFTXN0031: Commit not allowed on imported transaction";
    }
    @Override
    public final SystemException commitOnImported() {
        final SystemException result = new SystemException(String.format(getLoggingLocale(), commitOnImported$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String rollbackOnImported$str() {
        return "WFTXN0032: Rollback not allowed on imported transaction";
    }
    @Override
    public final SystemException rollbackOnImported() {
        final SystemException result = new SystemException(String.format(getLoggingLocale(), rollbackOnImported$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String multipleProvidersRegistered$str() {
        return "WFTXN0033: Multiple remote transaction providers registered on endpoint: %s";
    }
    @Override
    public final IllegalStateException multipleProvidersRegistered(final Endpoint e) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), multipleProvidersRegistered$str(), e));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String failedToAcquireConnectionXA$str() {
        return "WFTXN0034: Failed to acquire a connection for this operation";
    }
    @Override
    public final XAException failedToAcquireConnectionXA(final Throwable e, final int errorCode) {
        final XAException result = new XAException(String.format(getLoggingLocale(), failedToAcquireConnectionXA$str()));
        result.initCause(e);
        _copyStackTraceMinusOne(result);
        result.errorCode = errorCode;
        return result;
    }
    protected String invalidHandleTypeRequested$str() {
        return "WFTXN0035: Invalid handle type requested; expected a subtype of Transaction (non-inclusive), got %s";
    }
    @Override
    public final IllegalArgumentException invalidHandleTypeRequested(final Class<?> type) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidHandleTypeRequested$str(), type));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String interruptedXA$str() {
        return "WFTXN0036: Transaction operation failed due to thread interruption";
    }
    @Override
    public final XAException interruptedXA(final int errorCode) {
        final XAException result = new XAException(String.format(getLoggingLocale(), interruptedXA$str()));
        _copyStackTraceMinusOne(result);
        result.errorCode = errorCode;
        return result;
    }
    protected String noTransactionProvider$str() {
        return "WFTXN0037: No transaction provider associated with the current thread";
    }
    @Override
    public final IllegalStateException noTransactionProvider() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noTransactionProvider$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noLocalTransactionProvider$str() {
        return "WFTXN0038: No local transaction provider associated with the current thread";
    }
    @Override
    public final IllegalStateException noLocalTransactionProvider() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noLocalTransactionProvider$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nullTransaction$str() {
        return "WFTXN0039: Invalid null transaction";
    }
    @Override
    public final NullPointerException nullTransaction() {
        final NullPointerException result = new NullPointerException(String.format(getLoggingLocale(), nullTransaction$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void rollbackFailed(final Throwable e) {
        super.log.logf(FQCN, DEBUG, e, rollbackFailed$str());
    }
    protected String rollbackFailed$str() {
        return "WFTXN0040: Rollback failed unexpectedly";
    }
    protected String noProviderInterface$str() {
        return "WFTXN0041: No provider interface matching %s is available from the transaction provider";
    }
    @Override
    public final IllegalStateException noProviderInterface(final Class<?> clazz) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noProviderInterface$str(), clazz));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String connectionFailed$str() {
        return "WFTXN0042: Connection to remote transaction service failed";
    }
    @Override
    public final SystemException connectionFailed(final Throwable cause) {
        final SystemException result = new SystemException(String.format(getLoggingLocale(), connectionFailed$str()));
        result.initCause(cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String connectionInterrupted$str() {
        return "WFTXN0043: Connection to remote transaction service interrupted";
    }
    @Override
    public final SystemException connectionInterrupted() {
        final SystemException result = new SystemException(String.format(getLoggingLocale(), connectionInterrupted$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownResponse$str() {
        return "WFTXN0044: Unknown response received from peer";
    }
    @Override
    public final SystemException unknownResponse() {
        final SystemException result = new SystemException(String.format(getLoggingLocale(), unknownResponse$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String responseFailed$str() {
        return "WFTXN0045: Failed to receive a response from peer";
    }
    @Override
    public final SystemException responseFailed(final IOException cause) {
        final SystemException result = new SystemException(String.format(getLoggingLocale(), responseFailed$str()));
        result.initCause(cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String peerIllegalStateException$str() {
        return "WFTXN0046: The peer threw an IllegalStateException; see peer logs for more information";
    }
    @Override
    public final IllegalStateException peerIllegalStateException() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), peerIllegalStateException$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownResponseXa$str() {
        return "WFTXN0047: Unknown XA response received from peer";
    }
    @Override
    public final XAException unknownResponseXa(final int errorCode) {
        final XAException result = new XAException(String.format(getLoggingLocale(), unknownResponseXa$str()));
        _copyStackTraceMinusOne(result);
        result.errorCode = errorCode;
        return result;
    }
    protected String responseFailedXa$str() {
        return "WFTXN0048: Failed to receive an XA response from peer";
    }
    @Override
    public final XAException responseFailedXa(final IOException cause, final int errorCode) {
        final XAException result = new XAException(String.format(getLoggingLocale(), responseFailedXa$str()));
        result.initCause(cause);
        _copyStackTraceMinusOne(result);
        result.errorCode = errorCode;
        return result;
    }
    protected String negativeTxnTimeoutXa$str() {
        return "WFTXN0049: Negative transaction timeout provided";
    }
    @Override
    public final XAException negativeTxnTimeoutXa(final int errorCode) {
        final XAException result = new XAException(String.format(getLoggingLocale(), negativeTxnTimeoutXa$str()));
        _copyStackTraceMinusOne(result);
        result.errorCode = errorCode;
        return result;
    }
    protected String unrecognizedParameter$str() {
        return "WFTXN0050: Unrecognized parameter with ID 0x%02x received";
    }
    @Override
    public final XAException unrecognizedParameter(final int errorCode, final int id) {
        final XAException result = new XAException(String.format(getLoggingLocale(), unrecognizedParameter$str(), id));
        _copyStackTraceMinusOne(result);
        result.errorCode = errorCode;
        return result;
    }
    protected String expectedParameter$str() {
        return "WFTXN0051: Expected parameter with ID 0x%02x, got parameter with ID 0x%02x instead";
    }
    @Override
    public final SystemException expectedParameter(final int expected, final int actual) {
        final SystemException result = new SystemException(String.format(getLoggingLocale(), expectedParameter$str(), expected, actual));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String expectedParameterXa$str() {
        return "WFTXN0052: Expected parameter with ID 0x%02x, got parameter with ID 0x%02x instead";
    }
    @Override
    public final XAException expectedParameterXa(final int errorCode, final int expected, final int actual) {
        final XAException result = new XAException(String.format(getLoggingLocale(), expectedParameterXa$str(), expected, actual));
        _copyStackTraceMinusOne(result);
        result.errorCode = errorCode;
        return result;
    }
    protected String delayedEnlistmentFailed$str() {
        return "WFTXN0053: Delayed enlistment has failed";
    }
    @Override
    public final DelayedEnlistmentException delayedEnlistmentFailed(final Throwable cause) {
        final DelayedEnlistmentException result = new DelayedEnlistmentException(String.format(getLoggingLocale(), delayedEnlistmentFailed$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String beforeCompletionFailed$str() {
        return "WFTXN0054: Before-completion failed for resource %s";
    }
    @Override
    public final SynchronizationException beforeCompletionFailed(final Throwable cause, final XAResource resource) {
        final SynchronizationException result = new SynchronizationException(String.format(getLoggingLocale(), beforeCompletionFailed$str(), resource), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String onePhaseUserTransaction$str() {
        return "WFTXN0055: Two-phase operation on single-phase transaction";
    }
    @Override
    public final XAException onePhaseUserTransaction(final int errorCode) {
        final XAException result = new XAException(String.format(getLoggingLocale(), onePhaseUserTransaction$str()));
        _copyStackTraceMinusOne(result);
        result.errorCode = errorCode;
        return result;
    }
    protected String unknownProvider$str() {
        return "WFTXN0056: Unknown provider for remote transactions with URI scheme \"%s\"";
    }
    @Override
    public final IllegalArgumentException unknownProvider(final String scheme) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unknownProvider$str(), scheme));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String outflowAcrossTransactionManagers$str() {
        return "WFTXN0057: Attempted to outflow the same transaction from two different transaction managers";
    }
    @Override
    public final SystemException outflowAcrossTransactionManagers() {
        final SystemException result = new SystemException(String.format(getLoggingLocale(), outflowAcrossTransactionManagers$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String alreadyEnlisted$str() {
        return "WFTXN0058: This delayed enlistment handle was already enlisted";
    }
    @Override
    public final IllegalStateException alreadyEnlisted() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), alreadyEnlisted$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String alreadyForgotten$str() {
        return "WFTXN0059: This delayed enlistment handle was already forgotten";
    }
    @Override
    public final IllegalStateException alreadyForgotten() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), alreadyForgotten$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String transactionTimedOut$str() {
        return "WFTXN0060: Transaction timed out";
    }
    @Override
    public final XAException transactionTimedOut(final int errorCode) {
        final XAException result = new XAException(String.format(getLoggingLocale(), transactionTimedOut$str()));
        _copyStackTraceMinusOne(result);
        result.errorCode = errorCode;
        return result;
    }
    protected String markedRollbackOnly$str() {
        return "WFTXN0061: Transaction is marked rollback-only";
    }
    @Override
    public final RollbackException markedRollbackOnly() {
        final RollbackException result = new RollbackException(String.format(getLoggingLocale(), markedRollbackOnly$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String notActive$str() {
        return "WFTXN0062: Transaction is not active";
    }
    @Override
    public final IllegalStateException notActive() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), notActive$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String providerCreatedNullTransaction$str() {
        return "WFTXN0063: Provider created a null transaction";
    }
    @Override
    public final IllegalStateException providerCreatedNullTransaction() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), providerCreatedNullTransaction$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidConnectionEndpoint$str() {
        return "WFTXN0064: Invalid connection endpoint provided";
    }
    @Override
    public final IllegalArgumentException invalidConnectionEndpoint() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidConnectionEndpoint$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noTransactionForId$str() {
        return "WFTXN0065: No transaction for ID %d";
    }
    @Override
    public final SystemException noTransactionForId(final int id) {
        final SystemException result = new SystemException(String.format(getLoggingLocale(), noTransactionForId$str(), id));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String rollbackOnlyFailed$str() {
        return "WFTXN0066: Failed to set transaction as rollback-only";
    }
    @Override
    public final XAException rollbackOnlyFailed(final int errorCode, final SystemException e) {
        final XAException result = new XAException(String.format(getLoggingLocale(), rollbackOnlyFailed$str()));
        result.initCause(e);
        _copyStackTraceMinusOne(result);
        result.errorCode = errorCode;
        return result;
    }
    protected String notActiveXA$str() {
        return "WFTXN0067: Transaction is not active";
    }
    @Override
    public final XAException notActiveXA(final int errorCode) {
        final XAException result = new XAException(String.format(getLoggingLocale(), notActiveXA$str()));
        _copyStackTraceMinusOne(result);
        result.errorCode = errorCode;
        return result;
    }
    protected String couldNotEnlist$str() {
        return "WFTXN0068: Subordinate enlistment failed for unknown reason";
    }
    @Override
    public final SystemException couldNotEnlist() {
        final SystemException result = new SystemException(String.format(getLoggingLocale(), couldNotEnlist$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidTransactionConnection$str() {
        return "WFTXN0069: Connection does not match the transaction; the connection may have closed";
    }
    @Override
    public final InvalidTransactionException invalidTransactionConnection() {
        final InvalidTransactionException result = new InvalidTransactionException(String.format(getLoggingLocale(), invalidTransactionConnection$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noTransactionXa$str() {
        return "WFTXN0070: No such transaction";
    }
    @Override
    public final XAException noTransactionXa(final int errorCode) {
        final XAException result = new XAException(String.format(getLoggingLocale(), noTransactionXa$str()));
        _copyStackTraceMinusOne(result);
        result.errorCode = errorCode;
        return result;
    }
    protected String unexpectedFailure$str() {
        return "WFTXN0071: An unexpected failure condition occurred";
    }
    @Override
    public final IllegalStateException unexpectedFailure(final Throwable e) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unexpectedFailure$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noLocalTransactionProviderNodeName$str() {
        return "WFTXN0072: No local transaction provider node name specified in the transaction manager environment";
    }
    @Override
    public final IllegalStateException noLocalTransactionProviderNodeName() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noLocalTransactionProviderNodeName$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unexpectedProviderTransactionMismatch$str() {
        return "WFTXN0073: Unexpected provider transaction mismatch; expected %s, got %s";
    }
    @Override
    public final IllegalStateException unexpectedProviderTransactionMismatch(final Transaction expected, final Transaction actual) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unexpectedProviderTransactionMismatch$str(), expected, actual));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String heuristicMixedXa$str() {
        return "WFTXN0074: Heuristic-mixed outcome";
    }
    @Override
    public final XAException heuristicMixedXa(final int errorCode, final HeuristicMixedException cause) {
        final XAException result = new XAException(String.format(getLoggingLocale(), heuristicMixedXa$str()));
        result.initCause(cause);
        _copyStackTraceMinusOne(result);
        result.errorCode = errorCode;
        return result;
    }
    protected String heuristicCommitXa$str() {
        return "WFTXN0075: Heuristic-commit outcome";
    }
    @Override
    public final XAException heuristicCommitXa(final int errorCode, final HeuristicCommitException cause) {
        final XAException result = new XAException(String.format(getLoggingLocale(), heuristicCommitXa$str()));
        result.initCause(cause);
        _copyStackTraceMinusOne(result);
        result.errorCode = errorCode;
        return result;
    }
    protected String rollbackXa$str() {
        return "WFTXN0076: Transaction rolled back";
    }
    @Override
    public final XAException rollbackXa(final int errorCode, final RollbackException cause) {
        final XAException result = new XAException(String.format(getLoggingLocale(), rollbackXa$str()));
        result.initCause(cause);
        _copyStackTraceMinusOne(result);
        result.errorCode = errorCode;
        return result;
    }
    protected String heuristicRollbackXa$str() {
        return "WFTXN0077: Heuristic-rollback outcome";
    }
    @Override
    public final XAException heuristicRollbackXa(final int errorCode, final HeuristicRollbackException cause) {
        final XAException result = new XAException(String.format(getLoggingLocale(), heuristicRollbackXa$str()));
        result.initCause(cause);
        _copyStackTraceMinusOne(result);
        result.errorCode = errorCode;
        return result;
    }
    protected String illegalStateXa$str() {
        return "WFTXN0078: Invalid transaction state";
    }
    @Override
    public final XAException illegalStateXa(final int errorCode, final IllegalStateException cause) {
        final XAException result = new XAException(String.format(getLoggingLocale(), illegalStateXa$str()));
        result.initCause(cause);
        _copyStackTraceMinusOne(result);
        result.errorCode = errorCode;
        return result;
    }
    protected String resourceManagerErrorXa$str() {
        return "WFTXN0079: An unexpected resource manager error occurred";
    }
    @Override
    public final XAException resourceManagerErrorXa(final int errorCode, final Throwable cause) {
        final XAException result = new XAException(String.format(getLoggingLocale(), resourceManagerErrorXa$str()));
        result.initCause(cause);
        _copyStackTraceMinusOne(result);
        result.errorCode = errorCode;
        return result;
    }
    protected String notImportedXa$str() {
        return "WFTXN0080: Operation not allowed on non-imported transaction";
    }
    @Override
    public final XAException notImportedXa(final int errorCode) {
        final XAException result = new XAException(String.format(getLoggingLocale(), notImportedXa$str()));
        _copyStackTraceMinusOne(result);
        result.errorCode = errorCode;
        return result;
    }
    protected String invalidTxStateXa$str() {
        return "WFTXN0081: Invalid transaction state for operation";
    }
    @Override
    public final XAException invalidTxStateXa(final int errorCode) {
        final XAException result = new XAException(String.format(getLoggingLocale(), invalidTxStateXa$str()));
        _copyStackTraceMinusOne(result);
        result.errorCode = errorCode;
        return result;
    }
    protected String suspendedCannotCreateNew$str() {
        return "WFTXN0082: Cannot import a new transaction on a suspended server";
    }
    @Override
    public final SystemException suspendedCannotCreateNew() {
        final SystemException result = new SystemException(String.format(getLoggingLocale(), suspendedCannotCreateNew$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String suspendedCannotImportXa$str() {
        return "WFTXN0083: Cannot import a new transaction on a suspended server";
    }
    @Override
    public final XAException suspendedCannotImportXa(final int errorCode) {
        final XAException result = new XAException(String.format(getLoggingLocale(), suspendedCannotImportXa$str()));
        _copyStackTraceMinusOne(result);
        result.errorCode = errorCode;
        return result;
    }
    protected String forbiddenContextForUserTransaction$str() {
        return "WFTXN0084: UserTransaction access is forbidden in the current context";
    }
    @Override
    public final IllegalStateException forbiddenContextForUserTransaction() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), forbiddenContextForUserTransaction$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unexpectedException$str() {
        return "WFTXN0085: Operation failed with an unexpected exception type";
    }
    @Override
    public final SystemException unexpectedException(final Exception e) {
        final SystemException result = new SystemException(String.format(getLoggingLocale(), unexpectedException$str()));
        result.initCause(e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownTransactionType$str() {
        return "WFTXN0086: Unexpected transaction type encountered; expected %s but encountered %s";
    }
    @Override
    public final IllegalStateException unknownTransactionType(final Class<?> expectedType, final Class<?> actualType) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unknownTransactionType$str(), expectedType, actualType));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownTransactionManagerType$str() {
        return "WFTXN0087: Unknown transaction manager type %s";
    }
    @Override
    public final IllegalArgumentException unknownTransactionManagerType(final Class<?> actualType) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unknownTransactionManagerType$str(), actualType));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noPermission$str() {
        return "WFTXN0088: User %s does not have permission %s";
    }
    @Override
    public final SecurityException noPermission(final String user, final Permission permission) {
        final SecurityException result = new SecurityException(String.format(getLoggingLocale(), noPermission$str(), user, permission));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String setTimeoutFailed$str() {
        return "WFTXN0089: Failed to configure transaction timeout of %d";
    }
    @Override
    public final SystemException setTimeoutFailed(final int timeout, final XAException e) {
        final SystemException result = new SystemException(String.format(getLoggingLocale(), setTimeoutFailed$str(), timeout));
        result.initCause(e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String locationAlreadyInitialized$str() {
        return "WFTXN0090: Cannot assign location \"%s\" to transaction because it is already located at \"%s\"";
    }
    @Override
    public final IllegalStateException locationAlreadyInitialized(final URI newLocation, final URI oldLocation) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), locationAlreadyInitialized$str(), newLocation, oldLocation));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String createXAResourceRecoveryFileFailed$str() {
        return "WFTXN0091: Failed to create xa resource recovery file: %s";
    }
    @Override
    public final SystemException createXAResourceRecoveryFileFailed(final Path filePath, final IOException e) {
        final SystemException result = new SystemException(String.format(getLoggingLocale(), createXAResourceRecoveryFileFailed$str(), filePath));
        result.initCause(e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String appendXAResourceRecoveryFileFailed$str() {
        return "WFTXN0092: Failed to append xa resource (%s) to xa recovery file: %s";
    }
    @Override
    public final SystemException appendXAResourceRecoveryFileFailed(final URI uri, final Path filePath, final IOException e) {
        final SystemException result = new SystemException(String.format(getLoggingLocale(), appendXAResourceRecoveryFileFailed$str(), uri, filePath));
        result.initCause(e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String deleteXAResourceRecoveryFileFailed$str() {
        return "WFTXN0093: Failed to delete xa recovery registry file %s on removal of %s";
    }
    @Override
    public final XAException deleteXAResourceRecoveryFileFailed(final int errorCode, final Path filePath, final XAResource resource, final IOException e) {
        final XAException result = new XAException(String.format(getLoggingLocale(), deleteXAResourceRecoveryFileFailed$str(), filePath, resource));
        result.initCause(e);
        _copyStackTraceMinusOne(result);
        result.errorCode = errorCode;
        return result;
    }
    protected String readXAResourceRecoveryFileFailed$str() {
        return "WFTXN0094: Failed to read xa resource recovery file %s";
    }
    @Override
    public final IOException readXAResourceRecoveryFileFailed(final Path filePath, final IOException e) {
        final IOException result = new IOException(String.format(getLoggingLocale(), readXAResourceRecoveryFileFailed$str(), filePath), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String readURIFromXAResourceRecoveryFileFailed$str() {
        return "WFTXN0095: Failed to read URI '%s' from xa resource recovery file %s";
    }
    @Override
    public final IOException readURIFromXAResourceRecoveryFileFailed(final String uriString, final Path filePath, final URISyntaxException e) {
        final IOException result = new IOException(String.format(getLoggingLocale(), readURIFromXAResourceRecoveryFileFailed$str(), uriString, filePath), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unexpectedExceptionOnXAResourceRecovery$str() {
        return "WFTXN0096: Unexpected exception on XA recovery";
    }
    @Override
    public final IllegalStateException unexpectedExceptionOnXAResourceRecovery(final IOException e) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unexpectedExceptionOnXAResourceRecovery$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotEnlistToTimeOutTransaction$str() {
        return "WFTXN0097: Cannot enlist XA resource '%s' to transaction '%s' as timeout already elapsed";
    }
    @Override
    public final SystemException cannotEnlistToTimeOutTransaction(final XAResource xaRes, final Transaction transaction) {
        final SystemException result = new SystemException(String.format(getLoggingLocale(), cannotEnlistToTimeOutTransaction$str(), xaRes, transaction));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void listXAResourceRecoveryFilesNull(final File dir) {
        super.log.logf(FQCN, WARN, null, listXAResourceRecoveryFilesNull$str(), dir);
    }
    protected String listXAResourceRecoveryFilesNull$str() {
        return "WFTXN0098: Unknown I/O error when listing xa resource recovery files in %s (File.list() returned null)";
    }
    @Override
    public final void cannotRemoveImportedTransaction(final Xid xid, final XAException e) {
        super.log.logf(FQCN, WARN, e, cannotRemoveImportedTransaction$str(), xid);
    }
    protected String cannotRemoveImportedTransaction$str() {
        return "WFTXN0099: Error while removing imported transaction of xid %s from the underlying transaction manager";
    }
    protected String failToConvertHexadecimalFormatToSimpleXid$str() {
        return "WFTXN0100: String '%s' has a wrong format to be decoded to SimpleXid. Expected the hexadecimal format separated by '%s' to exactly three parts.";
    }
    @Override
    public final IllegalStateException failToConvertHexadecimalFormatToSimpleXid(final String stringToConvert, final String separator) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), failToConvertHexadecimalFormatToSimpleXid$str(), stringToConvert, separator));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String readXidFromXAResourceRecoveryFileFailed$str() {
        return "WFTXN0101: Failed to read Xid '%s' from xa resource recovery file %s";
    }
    @Override
    public final IOException readXidFromXAResourceRecoveryFileFailed(final String xidString, final Path filePath, final Exception e) {
        final IOException result = new IOException(String.format(getLoggingLocale(), readXidFromXAResourceRecoveryFileFailed$str(), xidString, filePath), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
}
