/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.deployers.ra;

import jakarta.resource.spi.TransactionSupport;
import org.jboss.as.connector.deployers.ra.ConnectionFactoryDefinitionInjectionSource;
import org.jboss.as.ee.logging.EeLogger;
import org.jboss.as.ee.resource.definition.ResourceDefinitionDescriptorProcessor;
import org.jboss.as.ee.resource.definition.ResourceDefinitionInjectionSource;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.metadata.javaee.spec.ConnectionFactoriesMetaData;
import org.jboss.metadata.javaee.spec.ConnectionFactoryMetaData;
import org.jboss.metadata.javaee.spec.RemoteEnvironment;

public class ConnectionFactoryDefinitionDescriptorProcessor
extends ResourceDefinitionDescriptorProcessor {
    protected void processEnvironment(RemoteEnvironment environment, ResourceDefinitionDescriptorProcessor.ResourceDefinitionInjectionSources injectionSources) throws DeploymentUnitProcessingException {
        ConnectionFactoriesMetaData metaDatas = environment.getConnectionFactories();
        if (metaDatas != null) {
            for (ConnectionFactoryMetaData metaData : metaDatas) {
                injectionSources.addResourceDefinitionInjectionSource(this.getResourceDefinitionInjectionSource(metaData));
            }
        }
    }

    private ResourceDefinitionInjectionSource getResourceDefinitionInjectionSource(ConnectionFactoryMetaData metaData) {
        String name = metaData.getName();
        if (name == null || name.isEmpty()) {
            throw EeLogger.ROOT_LOGGER.elementAttributeMissing("<connection-factory>", "name");
        }
        String interfaceName = metaData.getInterfaceName();
        if (interfaceName == null || interfaceName.isEmpty()) {
            throw EeLogger.ROOT_LOGGER.elementAttributeMissing("<connection-factory>", "interfaceName");
        }
        String resourceAdapter = metaData.getResourceAdapter();
        if (resourceAdapter == null || resourceAdapter.isEmpty()) {
            throw EeLogger.ROOT_LOGGER.elementAttributeMissing("<connection-factory>", "resourceAdapter");
        }
        ConnectionFactoryDefinitionInjectionSource resourceDefinitionInjectionSource = new ConnectionFactoryDefinitionInjectionSource(name, interfaceName, resourceAdapter);
        if (metaData.getDescriptions() != null) {
            resourceDefinitionInjectionSource.setDescription(metaData.getDescriptions().toString());
        }
        resourceDefinitionInjectionSource.setMaxPoolSize(metaData.getMaxPoolSize());
        resourceDefinitionInjectionSource.setMinPoolSize(metaData.getMinPoolSize());
        if (metaData.getTransactionSupport() != null) {
            switch (metaData.getTransactionSupport()) {
                case NoTransaction: {
                    resourceDefinitionInjectionSource.setTransactionSupportLevel(TransactionSupport.TransactionSupportLevel.NoTransaction);
                    break;
                }
                case LocalTransaction: {
                    resourceDefinitionInjectionSource.setTransactionSupportLevel(TransactionSupport.TransactionSupportLevel.LocalTransaction);
                    break;
                }
                case XATransaction: {
                    resourceDefinitionInjectionSource.setTransactionSupportLevel(TransactionSupport.TransactionSupportLevel.XATransaction);
                }
            }
        }
        resourceDefinitionInjectionSource.addProperties(metaData.getProperties());
        return resourceDefinitionInjectionSource;
    }
}

