/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.services.workmanager;

import java.util.concurrent.Executor;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.security.ElytronSecurityIntegration;
import org.jboss.as.connector.services.workmanager.NamedWorkManager;
import org.jboss.as.connector.services.workmanager.StatisticsExecutorImpl;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.as.txn.integration.JBossContextXATerminator;
import org.jboss.jca.core.api.workmanager.WorkManager;
import org.jboss.jca.core.spi.transaction.xa.XATerminator;
import org.jboss.jca.core.tx.jbossts.XATerminatorImpl;
import org.jboss.jca.core.workmanager.WorkManagerCoordinator;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.threads.BlockingExecutor;
import org.jboss.tm.JBossXATerminator;

public final class WorkManagerService
implements Service<NamedWorkManager> {
    private final NamedWorkManager value;
    private final InjectedValue<Executor> executorShort = new InjectedValue();
    private final InjectedValue<Executor> executorLong = new InjectedValue();
    private final InjectedValue<JBossContextXATerminator> xaTerminator = new InjectedValue();

    public WorkManagerService(NamedWorkManager value) {
        ConnectorLogger.ROOT_LOGGER.debugf("Building WorkManager", new Object[0]);
        this.value = value;
    }

    public NamedWorkManager getValue() throws IllegalStateException {
        return ConnectorServices.notNull(this.value);
    }

    public void start(StartContext context) throws StartException {
        ConnectorLogger.ROOT_LOGGER.debugf("Starting Jakarta Connectors WorkManager: ", this.value.getName());
        BlockingExecutor longRunning = (BlockingExecutor)this.executorLong.getOptionalValue();
        if (longRunning != null) {
            this.value.setLongRunningThreadPool((Executor)longRunning);
            this.value.setShortRunningThreadPool((Executor)((Object)new StatisticsExecutorImpl((BlockingExecutor)this.executorShort.getValue())));
        } else {
            this.value.setLongRunningThreadPool((Executor)((Object)new StatisticsExecutorImpl((BlockingExecutor)this.executorShort.getValue())));
            this.value.setShortRunningThreadPool((Executor)((Object)new StatisticsExecutorImpl((BlockingExecutor)this.executorShort.getValue())));
        }
        this.value.setXATerminator((XATerminator)new XATerminatorImpl((JBossXATerminator)this.xaTerminator.getValue()));
        if (this.value.getName().equals("default")) {
            WorkManagerCoordinator.getInstance().setDefaultWorkManager((WorkManager)this.value);
        } else {
            WorkManagerCoordinator.getInstance().registerWorkManager((WorkManager)this.value);
        }
        if (this.value.isShutdown()) {
            this.value.cancelShutdown();
        }
        this.value.setSecurityIntegration(new ElytronSecurityIntegration());
        ConnectorLogger.ROOT_LOGGER.debugf("Started Jakarta Connectors WorkManager: ", this.value.getName());
    }

    public void stop(StopContext context) {
        ConnectorLogger.ROOT_LOGGER.debugf("Stopping Jakarta Connectors WorkManager: ", this.value.getName());
        this.value.shutdown();
        if (this.value.getName().equals("default")) {
            WorkManagerCoordinator.getInstance().setDefaultWorkManager(null);
        } else {
            WorkManagerCoordinator.getInstance().unregisterWorkManager((WorkManager)this.value);
        }
        ConnectorLogger.ROOT_LOGGER.debugf("Stopped Jakarta Connectors WorkManager: ", this.value.getName());
    }

    public Injector<Executor> getExecutorShortInjector() {
        return this.executorShort;
    }

    public Injector<Executor> getExecutorLongInjector() {
        return this.executorLong;
    }

    public Injector<JBossContextXATerminator> getXaTerminatorInjector() {
        return this.xaTerminator;
    }
}

