/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.deployers.ds.processors;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import org.jboss.as.connector._drivermanager.DriverManagerAdapter;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.modules.AbstractResourceLoader;
import org.jboss.modules.ClassSpec;
import org.jboss.modules.ResourceLoader;
import org.jboss.modules.ResourceLoaderSpec;

public class DriverManagerAdapterProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ModuleSpecification moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        DriverAdapterResourceLoader resourceLoader = new DriverAdapterResourceLoader();
        moduleSpecification.addResourceLoader(ResourceLoaderSpec.createResourceLoaderSpec((ResourceLoader)resourceLoader));
    }

    static class DriverAdapterResourceLoader
    extends AbstractResourceLoader {
        DriverAdapterResourceLoader() {
        }

        public ClassSpec getClassSpec(String fileName) throws IOException {
            InputStream is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(fileName);
            if (is == null) {
                return null;
            }
            byte[] bytes = DriverAdapterResourceLoader.readAllBytesFromStream(is);
            ClassSpec spec = new ClassSpec();
            spec.setBytes(bytes);
            return spec;
        }

        public Collection<String> getPaths() {
            return Collections.singletonList(DriverManagerAdapter.class.getPackage().getName().replace('.', '/'));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static byte[] readAllBytesFromStream(InputStream is) throws IOException {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                byte[] buffer = new byte[1024];
                int read = 0;
                while ((read = is.read(buffer)) != -1) {
                    bos.write(buffer, 0, read);
                }
                byte[] byArray = bos.toByteArray();
                return byArray;
            }
            finally {
                DriverAdapterResourceLoader.safeClose(is);
                DriverAdapterResourceLoader.safeClose(bos);
            }
        }

        private static void safeClose(Closeable c) {
            if (c != null) {
                try {
                    c.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }
}

