package org.wildfly.extension.datasources.agroal.logging;

import java.util.Locale;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import java.io.Serializable;
import javax.annotation.Generated;
import java.sql.SQLException;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.as.controller.OperationFailedException;
import java.lang.String;
import org.jboss.logging.Logger;
import io.agroal.api.AgroalDataSource.FlushMode;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import org.jboss.msc.service.StartException;
import java.util.Arrays;
import java.lang.IllegalArgumentException;


import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2018-09-05T17:30:45-0700")
public class AgroalLogger_$logger extends DelegatingBasicLogger implements AgroalLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = AgroalLogger_$logger.class.getName();
    public AgroalLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void addingDeploymentProcessors() {
        super.log.logf(FQCN, INFO, null, addingDeploymentProcessors$str());
    }
    private static final String addingDeploymentProcessors = "WFLYAG0001: Adding deployment processors for DataSourceDefinition annotation and resource-ref entries";
    protected String addingDeploymentProcessors$str() {
        return addingDeploymentProcessors;
    }
    @Override
    public final void startedDataSource(final String datasource, final String jndiName) {
        super.log.logf(FQCN, INFO, null, startedDataSource$str(), datasource, jndiName);
    }
    private static final String startedDataSource = "WFLYAG0101: Started datasource '%s' bound to [%s]";
    protected String startedDataSource$str() {
        return startedDataSource;
    }
    @Override
    public final void stoppedDataSource(final String datasource) {
        super.log.logf(FQCN, INFO, null, stoppedDataSource$str(), datasource);
    }
    private static final String stoppedDataSource = "WFLYAG0102: Stopped datasource '%s'";
    protected String stoppedDataSource$str() {
        return stoppedDataSource;
    }
    @Override
    public final void startedXADataSource(final String datasource, final String jndiName) {
        super.log.logf(FQCN, INFO, null, startedXADataSource$str(), datasource, jndiName);
    }
    private static final String startedXADataSource = "WFLYAG0103: Started xa-datasource '%s' bound to [%s]";
    protected String startedXADataSource$str() {
        return startedXADataSource;
    }
    @Override
    public final void stoppedXADataSource(final String datasource) {
        super.log.logf(FQCN, INFO, null, stoppedXADataSource$str(), datasource);
    }
    private static final String stoppedXADataSource = "WFLYAG0104: Stopped xa-datasource '%s'";
    protected String stoppedXADataSource$str() {
        return stoppedXADataSource;
    }
    private static final String datasourceStartException = "WFLYAG0105: Exception starting datasource '%s'";
    protected String datasourceStartException$str() {
        return datasourceStartException;
    }
    @Override
    public final StartException datasourceStartException(final SQLException cause, final String dataSourceName) {
        final StartException result = new StartException(String.format(getLoggingLocale(), datasourceStartException$str(), dataSourceName), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String xaDatasourceStartException = "WFLYAG0106: Exception starting xa-datasource '%s'";
    protected String xaDatasourceStartException$str() {
        return xaDatasourceStartException;
    }
    @Override
    public final StartException xaDatasourceStartException(final SQLException cause, final String dataSourceName) {
        final StartException result = new StartException(String.format(getLoggingLocale(), xaDatasourceStartException$str(), dataSourceName), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidConnectionProvider = "WFLYAG0107: Invalid connection provider. Either a java.sql.Driver or javax.sql.DataSource implementation is required. Fix the connection-provider for the driver";
    protected String invalidConnectionProvider$str() {
        return invalidConnectionProvider;
    }
    @Override
    public final StartException invalidConnectionProvider() {
        final StartException result = new StartException(String.format(getLoggingLocale(), invalidConnectionProvider$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidXAConnectionProvider = "WFLYAG0108: An xa-datasource requires a javax.sql.XADataSource as connection provider. Fix the connection-provider for the driver";
    protected String invalidXAConnectionProvider$str() {
        return invalidXAConnectionProvider;
    }
    @Override
    public final StartException invalidXAConnectionProvider() {
        final StartException result = new StartException(String.format(getLoggingLocale(), invalidXAConnectionProvider$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingTransactionManager = "WFLYAG0109: Could not start datasource: transaction manager is missing";
    protected String missingTransactionManager$str() {
        return missingTransactionManager;
    }
    @Override
    public final StartException missingTransactionManager() {
        final StartException result = new StartException(String.format(getLoggingLocale(), missingTransactionManager$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidAuthentication = "WFLYAG0110: Error obtaining credentials from authentication context for datasource '%s'";
    protected String invalidAuthentication$str() {
        return invalidAuthentication;
    }
    @Override
    public final StartException invalidAuthentication(final Throwable cause, final String dataSourceName) {
        final StartException result = new StartException(String.format(getLoggingLocale(), invalidAuthentication$str(), dataSourceName), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidCredentialSourceSupplier = "WFLYAG0111: CredentialSourceSupplier for datasource '%s' is invalid";
    protected String invalidCredentialSourceSupplier$str() {
        return invalidCredentialSourceSupplier;
    }
    @Override
    public final StartException invalidCredentialSourceSupplier(final Throwable cause, final String dataSourceName) {
        final StartException result = new StartException(String.format(getLoggingLocale(), invalidCredentialSourceSupplier$str(), dataSourceName), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void flushOperation(final FlushMode mode) {
        super.log.logf(FQCN, INFO, null, flushOperation$str(), mode);
    }
    private static final String flushOperation = "WFLYAG0201: Performing flush operation, mode %s";
    protected String flushOperation$str() {
        return flushOperation;
    }
    private static final String unknownDatasourceServiceType = "WFLYAG0301: Unknown datasource service of type: %s";
    protected String unknownDatasourceServiceType$str() {
        return unknownDatasourceServiceType;
    }
    @Override
    public final OperationFailedException unknownDatasourceServiceType(final String serviceType) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), unknownDatasourceServiceType$str(), serviceType));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidConnection = "WFLYAG0302: Invalid connection in '%s'";
    protected String invalidConnection$str() {
        return invalidConnection;
    }
    @Override
    public final OperationFailedException invalidConnection(final SQLException cause, final String dataSourceName) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), invalidConnection$str(), dataSourceName), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String jndiNameInvalidFormat = "WFLYAG0303: JNDI name have to start with java:/ or java:jboss/";
    protected String jndiNameInvalidFormat$str() {
        return jndiNameInvalidFormat;
    }
    @Override
    public final OperationFailedException jndiNameInvalidFormat() {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), jndiNameInvalidFormat$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String jndiNameShouldValidate = "WFLYAG0304: JNDI name shouldn't include '//' or end with '/'";
    protected String jndiNameShouldValidate$str() {
        return jndiNameShouldValidate;
    }
    @Override
    public final OperationFailedException jndiNameShouldValidate() {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), jndiNameShouldValidate$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidDeploymentConnectionProvider = "WFLYAG0401: Invalid connection provider. Either a java.sql.Driver or javax.sql.DataSource implementation is required. Fix the connection-provider for the driver";
    protected String invalidDeploymentConnectionProvider$str() {
        return invalidDeploymentConnectionProvider;
    }
    @Override
    public final DeploymentUnitProcessingException invalidDeploymentConnectionProvider() {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), invalidDeploymentConnectionProvider$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String loadClassDeploymentException = "WFLYAG0402: Failed to load connection provider class '%s'";
    protected String loadClassDeploymentException$str() {
        return loadClassDeploymentException;
    }
    @Override
    public final DeploymentUnitProcessingException loadClassDeploymentException(final Throwable cause, final String className) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), loadClassDeploymentException$str(), className), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingAttributeInDatasourceMetadata = "WFLYAG0403: Element <data-source> must provide attribute '%s'";
    protected String missingAttributeInDatasourceMetadata$str() {
        return missingAttributeInDatasourceMetadata;
    }
    @Override
    public final DeploymentUnitProcessingException missingAttributeInDatasourceMetadata(final String attributeName) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), missingAttributeInDatasourceMetadata$str(), attributeName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void driverLoaded(final String className, final String driverName) {
        super.log.logf(FQCN, INFO, null, driverLoaded$str(), className, driverName);
    }
    private static final String driverLoaded = "WFLYAG0501: Loaded class %s for driver '%s'";
    protected String driverLoaded$str() {
        return driverLoaded;
    }
    private static final String loadModuleException = "WFLYAG0502: Failed to load driver module '%s'";
    protected String loadModuleException$str() {
        return loadModuleException;
    }
    @Override
    public final IllegalArgumentException loadModuleException(final Throwable cause, final String moduleName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), loadModuleException$str(), moduleName), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String loadClassException = "WFLYAG0503: Failed to load driver class '%s'";
    protected String loadClassException$str() {
        return loadClassException;
    }
    @Override
    public final IllegalArgumentException loadClassException(final Throwable cause, final String className) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), loadClassException$str(), className), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void poolWarning(final String datasourceName, final String warn) {
        super.log.logf(FQCN, WARN, null, poolWarning$str(), datasourceName, warn);
    }
    private static final String poolWarning = "WFLYAG0601: %s: %s";
    protected String poolWarning$str() {
        return poolWarning;
    }
}
