/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.metrics;

import io.smallrye.metrics.MetricsRequestHandler;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import java.util.Map;
import java.util.function.Supplier;
import org.jboss.as.controller.OperationContext;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.metrics.MetricsContextService;
import org.wildfly.extension.microprofile.metrics.MicroProfileMetricsSubsystemDefinition;
import org.wildfly.extension.microprofile.metrics.MicroProfileVendorMetricRegistry;

public class MicroProfileMetricsContextService
implements Service {
    private final Supplier<MetricsContextService> metricsContextService;
    private final MetricsRequestHandler metricsRequestHandler = new MetricsRequestHandler();
    private final MicroProfileVendorMetricRegistry vendorMetricsRegistry;

    static void install(OperationContext context, MicroProfileVendorMetricRegistry vendorMetricRegistry) {
        ServiceBuilder serviceBuilder = context.getServiceTarget().addService(MicroProfileMetricsSubsystemDefinition.MICROPROFILE_METRIC_HTTP_CONTEXT_CAPABILITY.getCapabilityServiceName());
        Supplier metricsContextService = serviceBuilder.requires(context.getCapabilityServiceName("org.wildfly.extension.metrics.http-context", MetricsContextService.class));
        MicroProfileMetricsContextService microprofileMetricsContextService = new MicroProfileMetricsContextService(metricsContextService, vendorMetricRegistry);
        serviceBuilder.setInstance((Service)microprofileMetricsContextService).install();
    }

    MicroProfileMetricsContextService(Supplier<MetricsContextService> metricsContextService, MicroProfileVendorMetricRegistry vendorMetricsRegistry) {
        this.metricsContextService = metricsContextService;
        this.vendorMetricsRegistry = vendorMetricsRegistry;
    }

    public void start(StartContext context) {
        this.metricsContextService.get().setOverrideableMetricHandler(new HttpHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleRequest(HttpServerExchange exchange) throws Exception {
                String requestPath = exchange.getRequestPath();
                String method = exchange.getRequestMethod().toString();
                HeaderValues acceptHeaders = exchange.getRequestHeaders().get(Headers.ACCEPT);
                MicroProfileMetricsContextService.this.vendorMetricsRegistry.readLock();
                try {
                    MicroProfileMetricsContextService.this.metricsRequestHandler.handleRequest(requestPath, method, acceptHeaders == null ? null : acceptHeaders.stream(), (status, message, headers) -> {
                        exchange.setStatusCode(status);
                        for (Map.Entry entry : headers.entrySet()) {
                            exchange.getResponseHeaders().put(new HttpString((String)entry.getKey()), (String)entry.getValue());
                        }
                        exchange.getResponseSender().send(message);
                    });
                }
                finally {
                    MicroProfileMetricsContextService.this.vendorMetricsRegistry.unlock();
                }
            }
        });
    }

    public void stop(StopContext context) {
        this.metricsContextService.get().setOverrideableMetricHandler(null);
        this.vendorMetricsRegistry.removeAllMetrics();
    }
}

