/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote.configuration;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.persistence.remote.configuration.AbstractSecurityConfigurationChildBuilder;
import org.infinispan.persistence.remote.configuration.MechanismConfiguration;
import org.infinispan.persistence.remote.configuration.SecurityConfigurationBuilder;

public class MechanismConfigurationBuilder
extends AbstractSecurityConfigurationChildBuilder
implements Builder<MechanismConfiguration> {
    MechanismConfigurationBuilder(SecurityConfigurationBuilder builder) {
        super(builder, MechanismConfiguration.attributeDefinitionSet());
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public MechanismConfigurationBuilder saslMechanism(String mechanism) {
        this.attributes.attribute(MechanismConfiguration.SASL_MECHANISM).set((Object)mechanism);
        return this;
    }

    public MechanismConfigurationBuilder username(String username) {
        this.attributes.attribute(MechanismConfiguration.USERNAME).set((Object)username);
        return this;
    }

    public MechanismConfigurationBuilder password(String password) {
        this.attributes.attribute(MechanismConfiguration.PASSWORD).set((Object)password);
        return this;
    }

    public MechanismConfigurationBuilder password(char[] password) {
        this.password(new String(password));
        return this;
    }

    public MechanismConfigurationBuilder realm(String realm) {
        this.attributes.attribute(MechanismConfiguration.REALM).set((Object)realm);
        return this;
    }

    public MechanismConfiguration create() {
        return new MechanismConfiguration(this.attributes.protect());
    }

    public Builder<?> read(MechanismConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }
}

