/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.deployment;

import java.util.Map;
import javax.jms.Destination;
import javax.jms.Queue;
import org.jboss.as.connector.deployers.ra.AdministeredObjectDefinitionInjectionSource;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.ee.resource.definition.ResourceDefinitionInjectionSource;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentResourceSupport;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.LifecycleEvent;
import org.jboss.msc.service.LifecycleListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq.ServerDefinition;
import org.wildfly.extension.messaging.activemq.deployment.JMSConnectionFactoryDefinitionInjectionSource;
import org.wildfly.extension.messaging.activemq.deployment.MessagingJMSDestinationManagedReferenceFactory;
import org.wildfly.extension.messaging.activemq.deployment.MessagingXmlInstallDeploymentUnitProcessor;
import org.wildfly.extension.messaging.activemq.jms.DestinationConfiguration;
import org.wildfly.extension.messaging.activemq.jms.ExternalJMSQueueService;
import org.wildfly.extension.messaging.activemq.jms.ExternalJMSTopicService;
import org.wildfly.extension.messaging.activemq.jms.JMSQueueConfigurationRuntimeHandler;
import org.wildfly.extension.messaging.activemq.jms.JMSQueueService;
import org.wildfly.extension.messaging.activemq.jms.JMSServices;
import org.wildfly.extension.messaging.activemq.jms.JMSTopicConfigurationRuntimeHandler;
import org.wildfly.extension.messaging.activemq.jms.JMSTopicService;
import org.wildfly.extension.messaging.activemq.logging.MessagingLogger;

public class JMSDestinationDefinitionInjectionSource
extends ResourceDefinitionInjectionSource {
    private final String interfaceName;
    private String description;
    private String className;
    private String resourceAdapter;
    private String destinationName;

    public JMSDestinationDefinitionInjectionSource(String jndiName, String interfaceName) {
        super(jndiName);
        this.interfaceName = interfaceName;
    }

    void setDescription(String description) {
        this.description = description;
    }

    void setClassName(String className) {
        this.className = className;
    }

    void setResourceAdapter(String resourceAdapter) {
        this.resourceAdapter = resourceAdapter;
    }

    void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }

    private String uniqueName(InjectionSource.ResolutionContext context) {
        if (this.destinationName != null && !this.destinationName.isEmpty()) {
            return this.destinationName;
        }
        StringBuilder uniqueName = new StringBuilder();
        uniqueName.append(context.getApplicationName()).append("_");
        uniqueName.append(context.getModuleName()).append("_");
        if (context.getComponentName() != null) {
            uniqueName.append(context.getComponentName()).append("_");
        }
        uniqueName.append(this.jndiName);
        return uniqueName.toString();
    }

    public void getResourceValue(InjectionSource.ResolutionContext context, ServiceBuilder<?> serviceBuilder, DeploymentPhaseContext phaseContext, Injector<ManagedReferenceFactory> injector) throws DeploymentUnitProcessingException {
        boolean external;
        if (this.resourceAdapter == null || this.resourceAdapter.isEmpty()) {
            this.resourceAdapter = JMSConnectionFactoryDefinitionInjectionSource.getDefaulResourceAdapter(phaseContext.getDeploymentUnit());
        }
        if ((external = JMSConnectionFactoryDefinitionInjectionSource.targetsExternalPooledConnectionFactory(this.resourceAdapter, phaseContext.getServiceRegistry())) || JMSConnectionFactoryDefinitionInjectionSource.targetsPooledConnectionFactory(JMSConnectionFactoryDefinitionInjectionSource.getActiveMQServerName(this.properties), this.resourceAdapter, phaseContext.getServiceRegistry())) {
            this.startActiveMQDestination(context, serviceBuilder, phaseContext, injector, external);
        } else {
            AdministeredObjectDefinitionInjectionSource aodis = new AdministeredObjectDefinitionInjectionSource(this.jndiName, this.className, this.resourceAdapter);
            aodis.setInterface(this.interfaceName);
            aodis.setDescription(this.description);
            for (Map.Entry property : this.properties.entrySet()) {
                aodis.addProperty((String)property.getKey(), (String)property.getValue());
            }
            aodis.getResourceValue(context, serviceBuilder, phaseContext, injector);
        }
    }

    private void startActiveMQDestination(InjectionSource.ResolutionContext context, ServiceBuilder<?> serviceBuilder, DeploymentPhaseContext phaseContext, Injector<ManagedReferenceFactory> injector, boolean external) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        String uniqueName = this.uniqueName(context);
        try {
            ServiceName serviceName = external ? MessagingServices.getActiveMQServiceName() : MessagingServices.getActiveMQServiceName(JMSConnectionFactoryDefinitionInjectionSource.getActiveMQServerName(this.properties));
            if (this.interfaceName.equals(Queue.class.getName())) {
                this.startQueue(uniqueName, phaseContext.getServiceTarget(), serviceName, serviceBuilder, deploymentUnit, injector, external);
            } else {
                this.startTopic(uniqueName, phaseContext.getServiceTarget(), serviceName, serviceBuilder, deploymentUnit, injector, external);
            }
        }
        catch (Exception e) {
            throw new DeploymentUnitProcessingException((Throwable)e);
        }
    }

    private void startQueue(String queueName, ServiceTarget serviceTarget, ServiceName serverServiceName, ServiceBuilder<?> serviceBuilder, DeploymentUnit deploymentUnit, Injector<ManagedReferenceFactory> injector, boolean external) {
        PathAddress registration;
        Service<Queue> queueService;
        String selector = this.properties.containsKey(CommonAttributes.SELECTOR.getName()) ? (String)this.properties.get(CommonAttributes.SELECTOR.getName()) : null;
        boolean durable = this.properties.containsKey(CommonAttributes.DURABLE.getName()) ? Boolean.valueOf((String)this.properties.get(CommonAttributes.DURABLE.getName())).booleanValue() : CommonAttributes.DURABLE.getDefaultValue().asBoolean();
        String managementAddress = this.properties.containsKey(ServerDefinition.MANAGEMENT_ADDRESS.getName()) ? (String)this.properties.get(ServerDefinition.MANAGEMENT_ADDRESS.getName()) : ServerDefinition.MANAGEMENT_ADDRESS.getDefaultValue().asString();
        String user = this.properties.containsKey("management-user") ? (String)this.properties.get("management-user") : null;
        String password = this.properties.containsKey("management-password") ? (String)this.properties.get("management-password") : null;
        ModelNode destination = new ModelNode();
        destination.get("name").set(queueName);
        destination.get(CommonAttributes.DURABLE.getName()).set(durable);
        if (selector != null) {
            destination.get(CommonAttributes.SELECTOR.getName()).set(selector);
        }
        destination.get("entries").add(this.jndiName);
        if (external) {
            ServiceName pcfName = JMSServices.getPooledConnectionFactoryBaseServiceName(serverServiceName).append(new String[]{this.resourceAdapter});
            ServiceName jmsQueueServiceName = JMSServices.getJmsQueueBaseServiceName(serverServiceName).append(new String[]{queueName});
            queueService = ExternalJMSQueueService.installRuntimeQueueService(DestinationConfiguration.Builder.getInstance().setResourceAdapter(this.resourceAdapter).setName(queueName).setManagementQueueAddress(managementAddress).setDestinationServiceName(jmsQueueServiceName).setDurable(durable).setSelector(selector).setManagementUsername(user).setManagementPassword(password).build(), serviceTarget, pcfName);
        } else {
            queueService = JMSQueueService.installService(queueName, serviceTarget, serverServiceName, selector, durable);
        }
        this.inject(serviceBuilder, injector, queueService);
        String serverName = null;
        DeploymentResourceSupport deploymentResourceSupport = (DeploymentResourceSupport)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_RESOURCE_SUPPORT);
        if (external) {
            PathElement dest = PathElement.pathElement((String)"external-jms-queue", (String)queueName);
            deploymentResourceSupport.getDeploymentSubsystemModel("messaging-activemq");
            registration = PathAddress.pathAddress((PathElement[])new PathElement[]{dest});
        } else {
            serverName = JMSConnectionFactoryDefinitionInjectionSource.getActiveMQServerName(this.properties);
            PathElement dest = PathElement.pathElement((String)"jms-queue", (String)queueName);
            PathElement serverElement = PathElement.pathElement((String)"server", (String)serverName);
            deploymentResourceSupport.getDeploymentSubModel("messaging-activemq", serverElement);
            registration = PathAddress.pathAddress((PathElement[])new PathElement[]{serverElement, dest});
        }
        MessagingXmlInstallDeploymentUnitProcessor.createDeploymentSubModel(registration, deploymentUnit);
        JMSQueueConfigurationRuntimeHandler.INSTANCE.registerResource(serverName, queueName, destination);
    }

    private void startTopic(String topicName, ServiceTarget serviceTarget, ServiceName serverServiceName, ServiceBuilder<?> serviceBuilder, DeploymentUnit deploymentUnit, Injector<ManagedReferenceFactory> injector, boolean external) {
        PathAddress registration;
        Object topicService;
        String managementAddress = this.properties.containsKey(ServerDefinition.MANAGEMENT_ADDRESS.getName()) ? (String)this.properties.get(ServerDefinition.MANAGEMENT_ADDRESS.getName()) : ServerDefinition.MANAGEMENT_ADDRESS.getDefaultValue().asString();
        String user = this.properties.containsKey("management-user") ? (String)this.properties.get("management-user") : null;
        String password = this.properties.containsKey("management-password") ? (String)this.properties.get("management-password") : null;
        ModelNode destination = new ModelNode();
        destination.get("name").set(topicName);
        destination.get("entries").add(this.jndiName);
        if (external) {
            ServiceName pcfName = JMSServices.getPooledConnectionFactoryBaseServiceName(serverServiceName).append(new String[]{this.resourceAdapter});
            ServiceName jmsTopicServiceName = JMSServices.getJmsTopicBaseServiceName(serverServiceName).append(new String[]{topicName});
            topicService = ExternalJMSTopicService.installRuntimeTopicService(DestinationConfiguration.Builder.getInstance().setResourceAdapter(this.resourceAdapter).setName(topicName).setManagementQueueAddress(managementAddress).setManagementUsername(user).setManagementPassword(password).setDestinationServiceName(jmsTopicServiceName).build(), serviceTarget, pcfName);
        } else {
            topicService = JMSTopicService.installService(topicName, serverServiceName, serviceTarget);
        }
        this.inject(serviceBuilder, injector, (Service)topicService);
        String serverName = null;
        DeploymentResourceSupport deploymentResourceSupport = (DeploymentResourceSupport)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_RESOURCE_SUPPORT);
        if (external) {
            PathElement dest = PathElement.pathElement((String)"external-jms-topic", (String)topicName);
            deploymentResourceSupport.getDeploymentSubsystemModel("messaging-activemq");
            registration = PathAddress.pathAddress((PathElement[])new PathElement[]{dest});
        } else {
            serverName = JMSConnectionFactoryDefinitionInjectionSource.getActiveMQServerName(this.properties);
            PathElement dest = PathElement.pathElement((String)"jms-topic", (String)topicName);
            PathElement serverElement = PathElement.pathElement((String)"server", (String)serverName);
            deploymentResourceSupport.getDeploymentSubModel("messaging-activemq", serverElement);
            registration = PathAddress.pathAddress((PathElement[])new PathElement[]{serverElement, dest});
        }
        MessagingXmlInstallDeploymentUnitProcessor.createDeploymentSubModel(registration, deploymentUnit);
        JMSTopicConfigurationRuntimeHandler.INSTANCE.registerResource(serverName, topicName, destination);
    }

    private <D extends Destination> void inject(ServiceBuilder<?> serviceBuilder, Injector<ManagedReferenceFactory> injector, Service<D> destinationService) {
        MessagingJMSDestinationManagedReferenceFactory<D> referenceFactoryService = new MessagingJMSDestinationManagedReferenceFactory<D>(destinationService);
        injector.inject(referenceFactoryService);
        serviceBuilder.addListener(new LifecycleListener(){
            private volatile boolean bound;

            public void handleEvent(ServiceController<?> controller, LifecycleEvent event) {
                switch (event) {
                    case UP: {
                        MessagingLogger.ROOT_LOGGER.boundJndiName(JMSDestinationDefinitionInjectionSource.this.jndiName);
                        this.bound = true;
                        break;
                    }
                    case DOWN: {
                        if (!this.bound) break;
                        MessagingLogger.ROOT_LOGGER.unboundJndiName(JMSDestinationDefinitionInjectionSource.this.jndiName);
                        break;
                    }
                    case REMOVED: {
                        MessagingLogger.ROOT_LOGGER.debugf("Removed messaging object [%s]", (Object)JMSDestinationDefinitionInjectionSource.this.jndiName);
                    }
                }
            }
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JMSDestinationDefinitionInjectionSource that = (JMSDestinationDefinitionInjectionSource)((Object)o);
        if (this.className != null ? !this.className.equals(that.className) : that.className != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.destinationName != null ? !this.destinationName.equals(that.destinationName) : that.destinationName != null) {
            return false;
        }
        if (this.interfaceName != null ? !this.interfaceName.equals(that.interfaceName) : that.interfaceName != null) {
            return false;
        }
        return !(this.resourceAdapter != null ? !this.resourceAdapter.equals(that.resourceAdapter) : that.resourceAdapter != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.interfaceName != null ? this.interfaceName.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.className != null ? this.className.hashCode() : 0);
        result = 31 * result + (this.resourceAdapter != null ? this.resourceAdapter.hashCode() : 0);
        result = 31 * result + (this.destinationName != null ? this.destinationName.hashCode() : 0);
        return result;
    }
}

