/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.stomp;

import java.nio.charset.StandardCharsets;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.message.impl.CoreMessage;
import org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException;
import org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompProtocolMessageBundle;
import org.apache.activemq.artemis.core.protocol.stomp.StompConnection;
import org.apache.activemq.artemis.core.protocol.stomp.StompDecoder;
import org.apache.activemq.artemis.core.protocol.stomp.StompFrame;
import org.apache.activemq.artemis.core.protocol.stomp.StompPostReceiptFunction;
import org.apache.activemq.artemis.core.protocol.stomp.StompSubscription;
import org.apache.activemq.artemis.core.protocol.stomp.StompUtils;
import org.apache.activemq.artemis.core.protocol.stomp.StompVersions;
import org.apache.activemq.artemis.core.protocol.stomp.v10.StompFrameHandlerV10;
import org.apache.activemq.artemis.core.protocol.stomp.v11.StompFrameHandlerV11;
import org.apache.activemq.artemis.core.protocol.stomp.v12.StompFrameHandlerV12;
import org.apache.activemq.artemis.utils.ExecutorFactory;

public abstract class VersionedStompFrameHandler {
    protected StompConnection connection;
    protected StompDecoder decoder;
    protected final ScheduledExecutorService scheduledExecutorService;
    protected final ExecutorFactory executorFactory;

    protected void disconnect() {
    }

    public static VersionedStompFrameHandler getHandler(StompConnection connection, StompVersions version, ScheduledExecutorService scheduledExecutorService, ExecutorFactory executorFactory) {
        if (version == StompVersions.V1_0) {
            return new StompFrameHandlerV10(connection, scheduledExecutorService, executorFactory);
        }
        if (version == StompVersions.V1_1) {
            return new StompFrameHandlerV11(connection, scheduledExecutorService, executorFactory);
        }
        if (version == StompVersions.V1_2) {
            return new StompFrameHandlerV12(connection, scheduledExecutorService, executorFactory);
        }
        return null;
    }

    protected VersionedStompFrameHandler(StompConnection connection, ScheduledExecutorService scheduledExecutorService, ExecutorFactory executorFactory) {
        this.connection = connection;
        this.scheduledExecutorService = scheduledExecutorService;
        this.executorFactory = executorFactory;
    }

    public StompFrame decode(ActiveMQBuffer buffer) throws ActiveMQStompException {
        return this.decoder.decode(buffer);
    }

    public boolean hasBytes() {
        return this.decoder.hasBytes();
    }

    public StompDecoder getDecoder() {
        return this.decoder;
    }

    public StompFrame handleFrame(StompFrame request) {
        StompFrame response = null;
        if ("SEND".equals(request.getCommand())) {
            response = this.onSend(request);
        } else if ("ACK".equals(request.getCommand())) {
            response = this.onAck(request);
        } else if ("NACK".equals(request.getCommand())) {
            response = this.onNack(request);
        } else if ("BEGIN".equals(request.getCommand())) {
            response = this.onBegin(request);
        } else if ("COMMIT".equals(request.getCommand())) {
            response = this.onCommit(request);
        } else if ("ABORT".equals(request.getCommand())) {
            response = this.onAbort(request);
        } else {
            if ("SUBSCRIBE".equals(request.getCommand())) {
                return this.handleSubscribe(request);
            }
            response = "UNSUBSCRIBE".equals(request.getCommand()) ? this.onUnsubscribe(request) : ("CONNECT".equals(request.getCommand()) ? this.onConnect(request) : ("STOMP".equals(request.getCommand()) ? this.onStomp(request) : ("DISCONNECT".equals(request.getCommand()) ? this.onDisconnect(request) : this.onUnknown(request.getCommand()))));
        }
        if (response == null) {
            response = this.postprocess(request);
        } else if (request.hasHeader("receipt")) {
            response.addHeader("receipt-id", request.getHeader("receipt"));
        }
        return response;
    }

    private StompFrame handleSubscribe(StompFrame request) {
        StompFrame response = null;
        try {
            StompPostReceiptFunction postProcessFunction = this.onSubscribe(request);
            response = this.postprocess(request);
            this.connection.sendFrame(response, postProcessFunction);
            return null;
        }
        catch (ActiveMQStompException e) {
            return e.getFrame();
        }
        catch (Exception e) {
            return new ActiveMQStompException(e.getMessage(), e).setHandler(this).getFrame();
        }
    }

    public abstract StompFrame onConnect(StompFrame var1);

    public abstract StompFrame onDisconnect(StompFrame var1);

    public abstract StompFrame onAck(StompFrame var1);

    public abstract StompFrame onUnsubscribe(StompFrame var1);

    public abstract StompFrame onStomp(StompFrame var1);

    public abstract StompFrame onNack(StompFrame var1);

    public abstract StompFrame createStompFrame(String var1);

    public StompFrame onUnknown(String command) {
        ActiveMQStompException error = ActiveMQStompProtocolMessageBundle.BUNDLE.unknownCommand(command).setHandler(this);
        StompFrame response = error.getFrame();
        return response;
    }

    public StompFrame handleReceipt(String receiptID) {
        StompFrame receipt = this.createStompFrame("RECEIPT");
        receipt.addHeader("receipt-id", receiptID);
        return receipt;
    }

    public StompFrame onCommit(StompFrame request) {
        StompFrame response = null;
        String txID = request.getHeader("transaction");
        if (txID == null) {
            ActiveMQStompException error = ActiveMQStompProtocolMessageBundle.BUNDLE.needTxIDHeader().setHandler(this);
            response = error.getFrame();
            return response;
        }
        try {
            this.connection.commitTransaction(txID);
        }
        catch (ActiveMQStompException e) {
            response = e.getFrame();
        }
        return response;
    }

    public StompFrame onSend(StompFrame frame) {
        StompFrame response = null;
        try {
            this.connection.validate();
            String destination = this.getDestination(frame);
            RoutingType routingType = this.getRoutingType(frame.getHeader("destination-type"), frame.getHeader("destination"));
            this.connection.autoCreateDestinationIfPossible(destination, routingType);
            this.connection.checkDestination(destination);
            this.connection.checkRoutingSemantics(destination, routingType);
            String txID = frame.getHeader("transaction");
            long timestamp = System.currentTimeMillis();
            CoreMessage message = this.connection.createServerMessage();
            if (routingType != null) {
                message.setRoutingType(routingType);
            }
            message.setTimestamp(timestamp);
            message.setAddress(SimpleString.toSimpleString((String)destination));
            StompUtils.copyStandardHeadersFromFrameToMessage(frame, (Message)message, this.getPrefix(frame));
            if (frame.hasHeader("content-length")) {
                message.setType((byte)4);
                message.getBodyBuffer().writeBytes(frame.getBodyAsBytes());
            } else {
                message.setType((byte)3);
                String text = frame.getBody();
                message.getBodyBuffer().writeNullableSimpleString(SimpleString.toSimpleString((String)text));
            }
            this.connection.sendServerMessage((ICoreMessage)message, txID);
        }
        catch (ActiveMQStompException e) {
            response = e.getFrame();
        }
        catch (Exception e) {
            ActiveMQStompException error = ActiveMQStompProtocolMessageBundle.BUNDLE.errorHandleSend(e).setHandler(this);
            response = error.getFrame();
        }
        return response;
    }

    public StompFrame onBegin(StompFrame frame) {
        StompFrame response = null;
        String txID = frame.getHeader("transaction");
        if (txID == null) {
            ActiveMQStompException error = ActiveMQStompProtocolMessageBundle.BUNDLE.beginTxNoID().setHandler(this);
            response = error.getFrame();
        } else {
            try {
                this.connection.beginTransaction(txID);
            }
            catch (ActiveMQStompException e) {
                response = e.getFrame();
            }
        }
        return response;
    }

    public StompFrame onAbort(StompFrame request) {
        StompFrame response = null;
        String txID = request.getHeader("transaction");
        if (txID == null) {
            ActiveMQStompException error = ActiveMQStompProtocolMessageBundle.BUNDLE.abortTxNoID().setHandler(this);
            response = error.getFrame();
            return response;
        }
        try {
            this.connection.abortTransaction(txID);
        }
        catch (ActiveMQStompException e) {
            response = e.getFrame();
        }
        return response;
    }

    public StompPostReceiptFunction onSubscribe(StompFrame frame) throws Exception {
        String destination = this.getDestination(frame);
        String selector = frame.getHeader("selector");
        String ack = frame.getHeader("ack");
        String id = frame.getHeader("id");
        String durableSubscriptionName = frame.getHeader("durable-subscriber-name");
        if (durableSubscriptionName == null) {
            durableSubscriptionName = frame.getHeader("durable-subscription-name");
        }
        if (durableSubscriptionName == null) {
            durableSubscriptionName = frame.getHeader("activemq.subscriptionName");
        }
        RoutingType routingType = this.getRoutingType(frame.getHeader("subscription-type"), frame.getHeader("destination"));
        boolean noLocal = false;
        if (frame.hasHeader("no-local")) {
            noLocal = Boolean.parseBoolean(frame.getHeader("no-local"));
        } else if (frame.hasHeader("activemq.noLocal")) {
            noLocal = Boolean.parseBoolean(frame.getHeader("no-local"));
        }
        Integer consumerWindowSize = null;
        if (frame.hasHeader("consumer-window-size")) {
            consumerWindowSize = Integer.parseInt(frame.getHeader("consumer-window-size"));
        } else if (frame.hasHeader("activemq.prefetchSize")) {
            consumerWindowSize = Integer.parseInt(frame.getHeader("activemq.prefetchSize"));
        }
        return this.connection.subscribe(destination, selector, ack, id, durableSubscriptionName, noLocal, routingType, consumerWindowSize);
    }

    public String getDestination(StompFrame request) throws Exception {
        return this.getDestination(request, "destination");
    }

    public String getDestination(StompFrame request, String header) throws Exception {
        String destination = request.getHeader(header);
        if (destination == null) {
            return null;
        }
        return this.connection.getSession().getCoreSession().removePrefix(SimpleString.toSimpleString((String)destination)).toString();
    }

    public String getPrefix(StompFrame request) throws Exception {
        String destination = request.getHeader("destination");
        if (destination == null) {
            return null;
        }
        SimpleString prefix = this.connection.getSession().getCoreSession().getPrefix(SimpleString.toSimpleString((String)destination));
        return prefix == null ? null : prefix.toString();
    }

    public StompFrame postprocess(StompFrame request) {
        StompFrame response = null;
        if (request.hasHeader("receipt")) {
            response = this.handleReceipt(request.getHeader("receipt"));
            if (request.getCommand().equals("DISCONNECT")) {
                response.setNeedsDisconnect(true);
            }
        } else if (request.getCommand().equals("DISCONNECT")) {
            this.connection.disconnect(false);
        }
        return response;
    }

    public StompFrame createMessageFrame(ICoreMessage serverMessage, ActiveMQBuffer bodyBuffer, StompSubscription subscription, int deliveryCount) throws Exception {
        StompFrame frame = this.createStompFrame("MESSAGE");
        if (subscription.getID() != null) {
            frame.addHeader("subscription", subscription.getID());
        }
        ActiveMQBuffer buffer = bodyBuffer != null ? bodyBuffer : serverMessage.getReadOnlyBodyBuffer();
        int size = buffer.writerIndex();
        byte[] data = new byte[size];
        if (serverMessage.containsProperty("content-length") || serverMessage.getType() == 4) {
            frame.addHeader("content-length", String.valueOf(data.length));
            buffer.readBytes(data);
        } else {
            SimpleString text = buffer.readNullableSimpleString();
            data = text != null ? text.toString().getBytes(StandardCharsets.UTF_8) : new byte[]{};
        }
        frame.setByteBody(data);
        StompUtils.copyStandardHeadersFromMessageToFrame((Message)serverMessage, frame, deliveryCount);
        return frame;
    }

    public void initDecoder(VersionedStompFrameHandler existingHandler) {
        throw ActiveMQStompProtocolMessageBundle.BUNDLE.invalidCall();
    }

    public void onError(ActiveMQStompException e) {
        this.connection.sendFrame(e.getFrame(), null);
        this.connection.destroy();
    }

    private RoutingType getRoutingType(String typeHeader, String destination) throws Exception {
        RoutingType routingType = typeHeader != null ? RoutingType.valueOf((String)typeHeader) : this.connection.getSession().getCoreSession().getRoutingTypeFromPrefix(new SimpleString(destination), null);
        return routingType;
    }

    protected StompFrame getFailedAuthenticationResponse(String login) {
        StompFrame response = this.createStompFrame("ERROR");
        response.setNeedsDisconnect(true);
        String responseText = "Security Error occurred: User name [" + login + "] or password is invalid";
        response.setBody(responseText);
        response.addHeader("message", responseText);
        return response;
    }
}

