/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.federation.model;

import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelOnlyAddStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.access.constraint.SensitivityClassification;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.wildfly.extension.picketlink.common.model.ModelElement;
import org.wildfly.extension.picketlink.federation.FederationExtension;
import org.wildfly.extension.picketlink.federation.model.AbstractFederationResourceDefinition;
import org.wildfly.extension.picketlink.federation.model.idp.IdentityProviderResourceDefinition;
import org.wildfly.extension.picketlink.federation.model.keystore.KeyStoreProviderResourceDefinition;
import org.wildfly.extension.picketlink.federation.model.saml.SAMLResourceDefinition;
import org.wildfly.extension.picketlink.federation.model.sp.ServiceProviderResourceDefinition;

public class FederationResourceDefinition
extends AbstractFederationResourceDefinition {
    private static final List<AccessConstraintDefinition> CONSTRAINTS = new SensitiveTargetAccessConstraintDefinition(new SensitivityClassification("picketlink-federation", "federation", false, true, true)).wrapAsList();

    public FederationResourceDefinition() {
        super(ModelElement.FEDERATION, new ModelOnlyAddStepHandler(new AttributeDefinition[0]), new SimpleAttributeDefinition[0]);
        this.setDeprecated(FederationExtension.DEPRECATED_SINCE);
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        this.addChildResourceDefinition(KeyStoreProviderResourceDefinition.INSTANCE, resourceRegistration);
        this.addChildResourceDefinition(new IdentityProviderResourceDefinition(), resourceRegistration);
        this.addChildResourceDefinition(new ServiceProviderResourceDefinition(), resourceRegistration);
        this.addChildResourceDefinition(SAMLResourceDefinition.INSTANCE, resourceRegistration);
    }

    public List<AccessConstraintDefinition> getAccessConstraints() {
        return CONSTRAINTS;
    }
}

