/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.x500;

import org.wildfly.common.Assert;
import org.wildfly.security.asn1.ASN1Encodable;
import org.wildfly.security.asn1.ASN1Encoder;

public final class X500AttributeTypeAndValue
implements ASN1Encodable {
    private final String attributeType;
    private final ASN1Encodable value;

    private X500AttributeTypeAndValue(String attributeType, ASN1Encodable value) {
        this.attributeType = attributeType;
        this.value = value;
    }

    public static X500AttributeTypeAndValue create(String attributeType, ASN1Encodable value) {
        Assert.checkNotNullParam((String)"attributeType", (Object)attributeType);
        Assert.checkNotNullParam((String)"value", (Object)value);
        return new X500AttributeTypeAndValue(attributeType, value);
    }

    public static X500AttributeTypeAndValue createUtf8(String attributeType, String stringValue) {
        Assert.checkNotNullParam((String)"stringValue", (Object)stringValue);
        return X500AttributeTypeAndValue.create(attributeType, ASN1Encodable.ofUtf8String((String)stringValue));
    }

    public static X500AttributeTypeAndValue createObjectId(String attributeType, String oid) {
        return X500AttributeTypeAndValue.create(attributeType, ASN1Encodable.ofOid((String)oid));
    }

    public void encodeTo(ASN1Encoder encoder) {
        encoder.startSequence();
        encoder.encodeObjectIdentifier(this.attributeType);
        this.value.encodeTo(encoder);
        encoder.endSequence();
    }
}

