/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.ra;

import jakarta.jms.JMSException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Enumeration;
import org.apache.activemq.artemis.ra.ActiveMQRAMessage;
import org.apache.activemq.artemis.ra.ActiveMQRASession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveMQRAMapMessage
extends ActiveMQRAMessage
implements MapMessage {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public ActiveMQRAMapMessage(MapMessage message, ActiveMQRASession session) {
        super((Message)message, session);
        logger.trace("constructor({}, {})", (Object)message, (Object)session);
    }

    public boolean getBoolean(String name) throws JMSException {
        logger.trace("getBoolean({})", (Object)name);
        return ((MapMessage)this.message).getBoolean(name);
    }

    public byte getByte(String name) throws JMSException {
        logger.trace("getByte({})", (Object)name);
        return ((MapMessage)this.message).getByte(name);
    }

    public byte[] getBytes(String name) throws JMSException {
        logger.trace("getBytes({})", (Object)name);
        return ((MapMessage)this.message).getBytes(name);
    }

    public char getChar(String name) throws JMSException {
        logger.trace("getChar({})", (Object)name);
        return ((MapMessage)this.message).getChar(name);
    }

    public double getDouble(String name) throws JMSException {
        logger.trace("getDouble({})", (Object)name);
        return ((MapMessage)this.message).getDouble(name);
    }

    public float getFloat(String name) throws JMSException {
        logger.trace("getFloat({})", (Object)name);
        return ((MapMessage)this.message).getFloat(name);
    }

    public int getInt(String name) throws JMSException {
        logger.trace("getInt({})", (Object)name);
        return ((MapMessage)this.message).getInt(name);
    }

    public long getLong(String name) throws JMSException {
        logger.trace("getLong({})", (Object)name);
        return ((MapMessage)this.message).getLong(name);
    }

    public Enumeration getMapNames() throws JMSException {
        logger.trace("getMapNames()");
        return ((MapMessage)this.message).getMapNames();
    }

    public Object getObject(String name) throws JMSException {
        logger.trace("getObject({})", (Object)name);
        return ((MapMessage)this.message).getObject(name);
    }

    public short getShort(String name) throws JMSException {
        logger.trace("getShort({})", (Object)name);
        return ((MapMessage)this.message).getShort(name);
    }

    public String getString(String name) throws JMSException {
        logger.trace("getString({})", (Object)name);
        return ((MapMessage)this.message).getString(name);
    }

    public boolean itemExists(String name) throws JMSException {
        logger.trace("itemExists({})", (Object)name);
        return ((MapMessage)this.message).itemExists(name);
    }

    public void setBoolean(String name, boolean value) throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("setBoolean({}, {})", (Object)name, (Object)value);
        }
        ((MapMessage)this.message).setBoolean(name, value);
    }

    public void setByte(String name, byte value) throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("setByte({}, {})", (Object)name, (Object)value);
        }
        ((MapMessage)this.message).setByte(name, value);
    }

    public void setBytes(String name, byte[] value, int offset, int length) throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("setBytes({}, {}, {}, {})", new Object[]{name, Arrays.toString(value), offset, length});
        }
        ((MapMessage)this.message).setBytes(name, value, offset, length);
    }

    public void setBytes(String name, byte[] value) throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("setBytes({}, {})", (Object)name, (Object)Arrays.toString(value));
        }
        ((MapMessage)this.message).setBytes(name, value);
    }

    public void setChar(String name, char value) throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("setChar({}, {})", (Object)name, (Object)Character.valueOf(value));
        }
        ((MapMessage)this.message).setChar(name, value);
    }

    public void setDouble(String name, double value) throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("setDouble({}, {})", (Object)name, (Object)value);
        }
        ((MapMessage)this.message).setDouble(name, value);
    }

    public void setFloat(String name, float value) throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("setFloat({}, {})", (Object)name, (Object)Float.valueOf(value));
        }
        ((MapMessage)this.message).setFloat(name, value);
    }

    public void setInt(String name, int value) throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("setInt({}, {})", (Object)name, (Object)value);
        }
        ((MapMessage)this.message).setInt(name, value);
    }

    public void setLong(String name, long value) throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("setLong({}, {})", (Object)name, (Object)value);
        }
        ((MapMessage)this.message).setLong(name, value);
    }

    public void setObject(String name, Object value) throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("setObject({}, {})", (Object)name, value);
        }
        ((MapMessage)this.message).setObject(name, value);
    }

    public void setShort(String name, short value) throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("setShort({}, {})", (Object)name, (Object)value);
        }
        ((MapMessage)this.message).setShort(name, value);
    }

    public void setString(String name, String value) throws JMSException {
        logger.trace("setString({}, {})", (Object)name, (Object)value);
        ((MapMessage)this.message).setString(name, value);
    }
}

