/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.MultiOperator;
import io.smallrye.mutiny.operators.multi.MultiSwitchOnEmptyOp;
import io.smallrye.mutiny.operators.multi.builders.FailedMulti;
import java.util.concurrent.Flow;
import java.util.function.Supplier;

public class MultiSwitchOnEmpty<T>
extends MultiOperator<T, T> {
    private final Supplier<Flow.Publisher<? extends T>> supplier;

    public MultiSwitchOnEmpty(Multi<T> upstream, Supplier<Flow.Publisher<? extends T>> supplier) {
        super(upstream);
        this.supplier = supplier;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> downstream) {
        if (downstream == null) {
            throw new NullPointerException("The subscriber must not be `null`");
        }
        Supplier actual = () -> {
            Flow.Publisher<? extends T> publisher;
            try {
                publisher = this.supplier.get();
            }
            catch (Throwable e) {
                return Infrastructure.onMultiCreation(new FailedMulti(e));
            }
            if (publisher == null) {
                return Infrastructure.onMultiCreation(new FailedMulti(new NullPointerException("The supplier returned `null`")));
            }
            if (publisher instanceof Multi) {
                return (Multi)publisher;
            }
            return Multi.createFrom().publisher(publisher);
        };
        Multi deferred = Multi.createFrom().deferred(actual);
        Multi<? super T> op = Infrastructure.onMultiCreation(new MultiSwitchOnEmptyOp(this.upstream(), deferred));
        op.subscribe(downstream);
    }
}

