/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.event.logger;

import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.PrintStream;
import org.wildfly.event.logger.Event;
import org.wildfly.event.logger.EventFormatter;
import org.wildfly.event.logger.EventWriter;

public class StdoutEventWriter
implements EventWriter {
    private static final PrintStream STDOUT = new PrintStream(new FileOutputStream(FileDescriptor.out), true);
    private final EventFormatter formatter;

    private StdoutEventWriter(EventFormatter formatter) {
        this.formatter = formatter;
    }

    public static StdoutEventWriter of(EventFormatter formatter) {
        return new StdoutEventWriter(formatter);
    }

    @Override
    public void write(Event event) {
        EventFormatter formatter = this.formatter;
        STDOUT.println(formatter.format(event));
    }

    @Override
    public void close() {
        STDOUT.flush();
    }
}

