/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.microprofile.reactive.messaging.common.security;

import io.smallrye.config.SmallRyeConfig;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.modules.Module;
import org.jboss.msc.service.ServiceName;
import org.wildfly.microprofile.reactive.messaging.common.ReactiveMessagingAttachments;
import org.wildfly.microprofile.reactive.messaging.common._private.MicroProfileReactiveMessagingCommonLogger;
import org.wildfly.microprofile.reactive.messaging.common.security.ElytronSSLContextRegistry;
import org.wildfly.microprofile.reactive.messaging.config.ReactiveMessagingConfigSource;

public abstract class BaseReactiveMessagingSslConfigProcessor
implements DeploymentUnitProcessor {
    private static final String RM_CONNECTOR_GLOBAL_PROPERTY_PREFIX = "mp.messaging.connector.";
    private static final String RM_INCOMING_PROPERTY_PREFIX = "mp.messaging.outgoing.";
    private static final String RM_OUTGOING_PROPERTY_PREFIX = "mp.messaging.incoming.";
    private static final String RM_CONNECTION_CONNECTOR_PROPERTY_SUFFIX = "connector";
    static final String SSL_CONTEXT_PROPERTY_SUFFIX = "wildfly.elytron.ssl.context";
    private static final AttachmentKey<Object> DEPLOYMENT_ATTACHMENT_KEY = AttachmentKey.create(Object.class);
    private final String connectorName;
    private final String globalPropertyPrefix;

    protected BaseReactiveMessagingSslConfigProcessor(String connectorName) {
        this.globalPropertyPrefix = RM_CONNECTOR_GLOBAL_PROPERTY_PREFIX + connectorName + ".";
        this.connectorName = connectorName;
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!this.isReactiveMessagingDeployment(deploymentUnit)) {
            return;
        }
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        Config config = ConfigProviderResolver.instance().getConfig((ClassLoader)module.getClassLoader());
        SecurityDeploymentContext sdc = this.createSecurityDeploymentContext();
        HashSet<ServiceName> mscDependencies = new HashSet<ServiceName>();
        for (String propertyName : config.getPropertyNames()) {
            if (propertyName.equals(this.globalPropertyPrefix + SSL_CONTEXT_PROPERTY_SUFFIX)) {
                String propertyValue = (String)config.getValue(propertyName, String.class);
                this.logAndCheck(mscDependencies, propertyName, propertyValue);
                sdc.setGlobalSslContext(this.globalPropertyPrefix, propertyValue);
            } else if ((propertyName.startsWith(RM_INCOMING_PROPERTY_PREFIX) || propertyName.startsWith(RM_OUTGOING_PROPERTY_PREFIX)) && propertyName.endsWith(RM_CONNECTION_CONNECTOR_PROPERTY_SUFFIX) && ((String)config.getValue(propertyName, String.class)).equals(this.connectorName)) {
                String connectorPrefix = propertyName.substring(0, propertyName.indexOf(RM_CONNECTION_CONNECTOR_PROPERTY_SUFFIX));
                String sslContext = config.getOptionalValue(connectorPrefix + SSL_CONTEXT_PROPERTY_SUFFIX, String.class).orElse(null);
                if (sslContext != null) {
                    this.logAndCheck(mscDependencies, propertyName, sslContext);
                }
                sdc.setConnectorSslContext(connectorPrefix, sslContext);
            }
            if (!this.isExtraConfigValueCheck() || !propertyName.startsWith(this.globalPropertyPrefix) && !propertyName.startsWith(RM_INCOMING_PROPERTY_PREFIX) && !propertyName.startsWith(RM_OUTGOING_PROPERTY_PREFIX)) continue;
            this.extraConfigValueCheck(propertyName, (String)config.getValue(propertyName, String.class));
        }
        Map<String, String> addedProperties = sdc.complete(phaseContext);
        if (addedProperties.size() > 0) {
            ReactiveMessagingConfigSource.addProperties((Config)config, addedProperties);
            for (ServiceName svcName : mscDependencies) {
                phaseContext.addDeploymentDependency(svcName, DEPLOYMENT_ATTACHMENT_KEY);
            }
            if (config instanceof SmallRyeConfig) {
                ((SmallRyeConfig)config).getLatestPropertyNames();
            }
        }
    }

    protected boolean isExtraConfigValueCheck() {
        return false;
    }

    protected void extraConfigValueCheck(String key, String value) throws DeploymentUnitProcessingException {
    }

    private void logAndCheck(Set<ServiceName> mscDependencies, String propertyName, String sslContextName) {
        if (sslContextName == null) {
            return;
        }
        MicroProfileReactiveMessagingCommonLogger.LOGGER.foundPropertyUsingElytronClientSSLContext(propertyName, sslContextName);
        if (!ElytronSSLContextRegistry.isSSLContextInstalled(sslContextName)) {
            throw MicroProfileReactiveMessagingCommonLogger.LOGGER.noElytronClientSSLContext(sslContextName);
        }
        mscDependencies.add(ElytronSSLContextRegistry.getSSLContextName(sslContextName));
    }

    private boolean isReactiveMessagingDeployment(DeploymentUnit deploymentUnit) {
        if (deploymentUnit.hasAttachment(ReactiveMessagingAttachments.IS_REACTIVE_MESSAGING_DEPLOYMENT)) {
            Boolean isRm = (Boolean)deploymentUnit.getAttachment(ReactiveMessagingAttachments.IS_REACTIVE_MESSAGING_DEPLOYMENT);
            return isRm;
        }
        return false;
    }

    protected abstract SecurityDeploymentContext createSecurityDeploymentContext();

    protected static interface SecurityDeploymentContext {
        public void setGlobalSslContext(String var1, String var2);

        public void setConnectorSslContext(String var1, String var2);

        public Map<String, String> complete(DeploymentPhaseContext var1);
    }
}

