/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.oidc;

import org.wildfly.security.http.oidc.AuthenticationError;
import org.wildfly.security.http.oidc.BearerTokenRequestAuthenticator;
import org.wildfly.security.http.oidc.Oidc;
import org.wildfly.security.http.oidc.OidcClientConfiguration;
import org.wildfly.security.http.oidc.OidcHttpFacade;

class QueryParameterTokenRequestAuthenticator
extends BearerTokenRequestAuthenticator {
    public static final String ACCESS_TOKEN = "access_token";

    public QueryParameterTokenRequestAuthenticator(OidcHttpFacade facade, OidcClientConfiguration oidcClientConfiguration) {
        super(facade, oidcClientConfiguration);
    }

    @Override
    public Oidc.AuthOutcome authenticate() {
        if (!this.oidcClientConfiguration.isOAuthQueryParameterEnabled()) {
            return Oidc.AuthOutcome.NOT_ATTEMPTED;
        }
        this.tokenString = this.getAccessTokenFromQueryParameter();
        if (this.tokenString == null || this.tokenString.trim().isEmpty()) {
            this.challenge = this.challengeResponse(AuthenticationError.Reason.NO_QUERY_PARAMETER_ACCESS_TOKEN, null, null);
            return Oidc.AuthOutcome.NOT_ATTEMPTED;
        }
        return this.verifyToken(this.tokenString);
    }

    String getAccessTokenFromQueryParameter() {
        try {
            if (this.facade != null && this.facade.getRequest() != null) {
                return this.facade.getRequest().getQueryParamValue(ACCESS_TOKEN);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

