/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.server.handlers.PathHandler;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityReferenceRecorder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.ValueExpression;
import org.jboss.msc.service.ServiceName;
import org.wildfly.common.function.ExceptionFunction;
import org.wildfly.extension.undertow.ApplicationSecurityDomainDefinition;
import org.wildfly.extension.undertow.BufferCacheDefinition;
import org.wildfly.extension.undertow.ByteBufferPoolDefinition;
import org.wildfly.extension.undertow.Host;
import org.wildfly.extension.undertow.ServerDefinition;
import org.wildfly.extension.undertow.ServletContainerDefinition;
import org.wildfly.extension.undertow.UndertowExtension;
import org.wildfly.extension.undertow.UndertowService;
import org.wildfly.extension.undertow.UndertowSubsystemAdd;
import org.wildfly.extension.undertow.filters.FilterDefinitions;
import org.wildfly.extension.undertow.handlers.HandlerDefinitions;
import org.wildfly.service.capture.FunctionExecutor;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.capture.FunctionExecutorRegistry;
import org.wildfly.subsystem.service.capture.ServiceValueExecutorRegistry;
import org.wildfly.subsystem.service.capture.ServiceValueRegistry;

class UndertowRootDefinition
extends PersistentResourceDefinition {
    static final PathElement PATH_ELEMENT = PathElement.pathElement((String)"subsystem", (String)"undertow");
    static final RuntimeCapability<Void> UNDERTOW_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.undertow", (boolean)false, UndertowService.class).build();
    static final RuntimeCapability<Void> HTTP_INVOKER_RUNTIME_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.undertow.http-invoker", (boolean)false, PathHandler.class).build();
    protected static final SimpleAttributeDefinition DEFAULT_SERVLET_CONTAINER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("default-servlet-container", ModelType.STRING, true).setRestartAllServices()).setDefaultValue(new ModelNode("default"))).setCapabilityReference(UNDERTOW_CAPABILITY, "org.wildfly.undertow.servlet-container", new AttributeDefinition[0])).build();
    protected static final SimpleAttributeDefinition DEFAULT_SERVER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("default-server", ModelType.STRING, true).setRestartAllServices()).setDefaultValue(new ModelNode("default-server"))).setCapabilityReference(UNDERTOW_CAPABILITY, "org.wildfly.undertow.server", new AttributeDefinition[0])).build();
    protected static final SimpleAttributeDefinition DEFAULT_VIRTUAL_HOST = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("default-virtual-host", ModelType.STRING, true).setRestartAllServices()).setDefaultValue(new ModelNode("default-host"))).setCapabilityReference((CapabilityReferenceRecorder)org.wildfly.subsystem.resource.capability.CapabilityReferenceRecorder.builder(UNDERTOW_CAPABILITY, Host.SERVICE_DESCRIPTOR).withParentAttribute((AttributeDefinition)DEFAULT_SERVER).build())).build();
    protected static final SimpleAttributeDefinition INSTANCE_ID = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("instance-id", ModelType.STRING, true).setRestartAllServices()).setAllowExpression(true)).setDefaultValue(new ModelNode().set(new ValueExpression("${jboss.node.name}")))).build();
    protected static final SimpleAttributeDefinition OBFUSCATE_SESSION_ROUTE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("obfuscate-session-route", ModelType.BOOLEAN, true).setRestartAllServices()).setAllowExpression(true)).setDefaultValue(ModelNode.FALSE)).build();
    protected static final SimpleAttributeDefinition STATISTICS_ENABLED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("statistics-enabled", ModelType.BOOLEAN, true).setRestartAllServices()).setAllowExpression(true)).setDefaultValue(ModelNode.FALSE)).build();
    protected static final SimpleAttributeDefinition DEFAULT_SECURITY_DOMAIN = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("default-security-domain", ModelType.STRING, true).setAllowExpression(true)).setDefaultValue(new ModelNode("other"))).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.SECURITY_DOMAIN_REF)).setRestartAllServices()).build();
    static final Collection<AttributeDefinition> ATTRIBUTES = List.of(DEFAULT_VIRTUAL_HOST, DEFAULT_SERVLET_CONTAINER, DEFAULT_SERVER, INSTANCE_ID, OBFUSCATE_SESSION_ROUTE, STATISTICS_ENABLED, DEFAULT_SECURITY_DOMAIN);
    private final FunctionExecutorRegistry<UndertowService> registry;
    private final Set<String> knownApplicationSecurityDomains;

    UndertowRootDefinition() {
        this(new CopyOnWriteArraySet<String>(), (ServiceValueExecutorRegistry<UndertowService>)ServiceValueExecutorRegistry.newInstance());
    }

    private UndertowRootDefinition(Set<String> knownApplicationSecurityDomains, ServiceValueExecutorRegistry<UndertowService> registry) {
        super(new SimpleResourceDefinition.Parameters(PATH_ELEMENT, (ResourceDescriptionResolver)UndertowExtension.getResolver(new String[0])).setAddHandler((OperationStepHandler)new UndertowSubsystemAdd(knownApplicationSecurityDomains::contains, (ServiceValueRegistry<UndertowService>)registry)).setRemoveHandler((OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE).addCapabilities(new RuntimeCapability[]{UNDERTOW_CAPABILITY, HTTP_INVOKER_RUNTIME_CAPABILITY}));
        this.knownApplicationSecurityDomains = knownApplicationSecurityDomains;
        this.registry = registry;
    }

    public Collection<AttributeDefinition> getAttributes() {
        return ATTRIBUTES;
    }

    public List<? extends PersistentResourceDefinition> getChildren() {
        return List.of(new ByteBufferPoolDefinition(), new BufferCacheDefinition(), new ServerDefinition(), new ServletContainerDefinition(), new HandlerDefinitions(), new FilterDefinitions(), new ApplicationSecurityDomainDefinition(this.knownApplicationSecurityDomains));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        for (AttributeDefinition attr : this.getAttributes()) {
            if (attr == STATISTICS_ENABLED) {
                final ExceptionFunction identity = service -> service;
                resourceRegistration.registerReadWriteAttribute(attr, null, (OperationStepHandler)new AbstractWriteAttributeHandler<Void>(){

                    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
                        FunctionExecutor executor = UndertowRootDefinition.this.registry.getExecutor((Object)ServiceDependency.on((ServiceName)UNDERTOW_CAPABILITY.getCapabilityServiceName()));
                        if (executor != null) {
                            ((UndertowService)executor.execute(identity)).setStatisticsEnabled(resolvedValue.asBoolean());
                        }
                        return false;
                    }

                    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
                        FunctionExecutor executor = UndertowRootDefinition.this.registry.getExecutor((Object)ServiceDependency.on((ServiceName)UNDERTOW_CAPABILITY.getCapabilityServiceName()));
                        if (executor != null) {
                            ((UndertowService)executor.execute(identity)).setStatisticsEnabled(valueToRestore.asBoolean());
                        }
                    }
                });
                continue;
            }
            resourceRegistration.registerReadWriteAttribute(attr, null, ReloadRequiredWriteAttributeHandler.INSTANCE);
        }
    }
}

